/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotplugin.commands.music.commands;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.List;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.utils.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.mangorage.commonutils.misc.Arguments;
import org.mangorage.mangobotcore.jda.command.api.CommandResult;
import org.mangorage.mangobotcore.jda.command.api.ICommand;
import org.mangorage.mangobotplugin.commands.music.MusicPlayer;
import org.mangorage.mangobotplugin.commands.music.MusicUtil;

public final class PlayCommand
implements ICommand {
    public String id() {
        return "play";
    }

    public List<String> commands() {
        return List.of("play");
    }

    public String usage() {
        return "Play Usage: N/A";
    }

    @NotNull
    public CommandResult execute(Message message, Arguments arg) {
        if (!message.isFromGuild()) {
            return CommandResult.GUILD_ONLY;
        }
        MessageChannelUnion channel = message.getChannel();
        Guild guild = message.getGuild();
        Member member = message.getMember();
        if (member == null) {
            return CommandResult.FAIL;
        }
        GuildVoiceState voiceState = member.getVoiceState();
        if (voiceState == null) {
            return CommandResult.FAIL;
        }
        MusicPlayer player = MusicPlayer.getInstance(guild.getId());
        if (!voiceState.inAudioChannel()) {
            message.reply((CharSequence)"Must be in a Voice Channel!").queue();
            return CommandResult.PASS;
        }
        if (player.isPlaying() && !player.isPaused()) {
            return CommandResult.PASS;
        }
        MusicUtil.connectToAudioChannel(voiceState.getChannel().asVoiceChannel());
        player.resume();
        AudioTrack track = player.getPlaying();
        channel.sendMessage((CharSequence)"Playing:\n%s/%s\n%s\n".formatted(MusicUtil.formatDuration(track.getPosition()), MusicUtil.formatDuration(track.getDuration()), MarkdownUtil.maskedLink((String)track.getInfo().title, (String)track.getInfo().uri))).queue();
        return CommandResult.PASS;
    }
}

