/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotplugin.commands.internal;

import java.io.InputStream;
import java.util.List;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import org.mangorage.commonutils.jda.slash.command.Command;
import org.mangorage.commonutils.jda.slash.command.CommandOption;
import org.mangorage.commonutils.misc.Arguments;
import org.mangorage.mangobotcore.jda.command.api.CommandResult;
import org.mangorage.mangobotcore.jda.command.api.ICommand;

public final class EmojiCommand
implements ICommand {
    public static String getInfo(CustomEmoji emoji) {
        return "URL: %s\nId: %s\nName: %s\nCreated: %s\nFormatted: %s\nReaction Code: %s\nMention: %s\n".formatted(emoji.getImageUrl(), emoji.getId(), emoji.getName(), emoji.getTimeCreated().toString(), emoji.getFormatted(), emoji.getAsReactionCode(), emoji.getAsMention());
    }

    public EmojiCommand() {
        Command.slash((String)"emoji", (String)"Useful emoji Comamnd").addSubCommand("info", "Get info about Emoji").addOption(new CommandOption(OptionType.STRING, "emoji", "The Emoji", true)).executes(e -> {
            OptionMapping valueOption = e.getInteraction().getOption("emoji");
            if (valueOption != null) {
                CustomEmoji emoji = Emoji.fromFormatted((String)valueOption.getAsString()).asCustom();
                e.reply(EmojiCommand.getInfo(emoji)).queue();
            }
        }).build().addSubCommand("create", "Create an Emoji").addOptions(new CommandOption[]{new CommandOption(OptionType.STRING, "name", "The Name for the emoji you are creating", true), new CommandOption(OptionType.STRING, "emoji", "The Actual Emoji you are wanting", true)}).executes(e -> {
            if (!e.getMember().hasPermission(new Permission[]{Permission.ADMINISTRATOR})) {
                e.reply("Insufficient Permissions!").setEphemeral(true).queue();
            } else {
                OptionMapping name = e.getInteraction().getOption("name");
                OptionMapping emoji = e.getInteraction().getOption("emoji");
                if (name == null || emoji == null) {
                    e.reply("Incomplete Command").setEphemeral(true).queue();
                } else {
                    CustomEmoji ce = Emoji.fromFormatted((String)emoji.getAsString()).asCustom();
                    try {
                        e.getGuild().createEmoji(name.getAsString(), Icon.from((InputStream)((InputStream)ce.getImage().download().get())), new Role[0]).queue();
                        e.reply("Created Emoji!").setEphemeral(true).queue();
                    }
                    catch (Throwable ignored) {
                        e.reply("Failed to create Emoji!").setEphemeral(true).queue();
                    }
                }
            }
        }).build().buildAndRegister();
    }

    public String id() {
        return "emoji";
    }

    public List<String> commands() {
        return List.of("emoji");
    }

    public String usage() {
        return "Emoji Usage:\n\n!emoji create <name/id> <emoji>\n!emoji create <name/id> <emojiName> <emojiId>\n\n!emoji send <emoji>\n!emoji send <emojiName> <emojiId>\n";
    }

    public CommandResult execute(Message message, Arguments arguments) {
        String sub_cmd = arguments.get(0);
        if (sub_cmd.contains("create")) {
            Member requester = message.getMember();
            if (!requester.hasPermission(new Permission[]{Permission.ADMINISTRATOR})) {
                return CommandResult.NO_PERMISSION;
            }
            if (arguments.getArgs().length == 4) {
                CustomEmoji ce = Emoji.fromFormatted((String)("<:" + arguments.get(2) + ":" + arguments.get(3) + ">")).asCustom();
                try {
                    message.getGuild().createEmoji(arguments.get(1), Icon.from((InputStream)((InputStream)ce.getImage().download().get())), new Role[0]).queue(s -> message.reply((CharSequence)"Successfully added new Emoji!").queue());
                }
                catch (Throwable e) {
                    message.reply((CharSequence)"Failed").queue();
                }
            } else if (arguments.getArgs().length == 3) {
                CustomEmoji ce = Emoji.fromFormatted((String)arguments.get(2)).asCustom();
                try {
                    message.getGuild().createEmoji(arguments.get(1), Icon.from((InputStream)((InputStream)ce.getImage().download().get())), new Role[0]).queue(s -> message.reply((CharSequence)"Successfully added new Emoji!").queue());
                }
                catch (Throwable e) {
                    message.reply((CharSequence)"Failed").queue();
                }
            } else {
                message.reply((CharSequence)"Improper Usage").queue();
            }
            return CommandResult.PASS;
        }
        if (sub_cmd.contains("info")) {
            if (arguments.getArgs().length == 3) {
                EmojiUnion ce = Emoji.fromFormatted((String)("<:" + arguments.get(1) + ":" + arguments.get(2) + ">"));
                message.reply((CharSequence)EmojiCommand.getInfo(ce.asCustom())).queue();
            } else if (arguments.getArgs().length == 2) {
                EmojiUnion ce = Emoji.fromFormatted((String)arguments.get(1));
                message.reply((CharSequence)EmojiCommand.getInfo(ce.asCustom())).queue();
            } else {
                message.reply((CharSequence)"Improper Usage").queue();
            }
        }
        return CommandResult.PASS;
    }
}

