/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotplugin.entrypoint;

import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumSet;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.hooks.AnnotatedEventManager;
import net.dv8tion.jda.api.hooks.IEventManager;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import org.mangorage.commonutils.config.Config;
import org.mangorage.commonutils.config.ConfigSetting;
import org.mangorage.commonutils.config.ISetting;
import org.mangorage.commonutils.jda.ButtonAction;
import org.mangorage.commonutils.jda.ButtonActionRegistry;
import org.mangorage.commonutils.jda.MessageSettings;
import org.mangorage.commonutils.jda.slash.command.Command;
import org.mangorage.mangobotcore.jda.command.api.CommandManager;
import org.mangorage.mangobotcore.jda.command.api.ICommand;
import org.mangorage.mangobotcore.plugin.api.MangoBotPlugin;
import org.mangorage.mangobotcore.plugin.api.Plugin;
import org.mangorage.mangobotplugin.BotEventListener;
import org.mangorage.mangobotplugin.actions.TrashButtonAction;
import org.mangorage.mangobotplugin.commands.PingCommand;
import org.mangorage.mangobotplugin.commands.PingsCommand;
import org.mangorage.mangobotplugin.commands.internal.EmojiCommand;
import org.mangorage.mangobotplugin.commands.music.commands.PauseCommand;
import org.mangorage.mangobotplugin.commands.music.commands.PlayCommand;
import org.mangorage.mangobotplugin.commands.music.commands.PlayingCommand;
import org.mangorage.mangobotplugin.commands.music.commands.QueueCommand;
import org.mangorage.mangobotplugin.commands.music.commands.SkipCommand;
import org.mangorage.mangobotplugin.commands.music.commands.StopCommand;
import org.mangorage.mangobotplugin.commands.music.commands.VolumeCommand;
import org.mangorage.mangobotplugin.commands.trick.TrickCommand;
import org.mangorage.mangobotplugin.pagedlist.PagedListManager;

@MangoBotPlugin(id="mangobot")
public final class MangoBot
implements Plugin {
    public static final String ID = "mangobot";
    public static final ButtonActionRegistry ACTION_REGISTRY = new ButtonActionRegistry();
    public static final Config CONFIG = new Config(Path.of("plugins/%s/.env".formatted("mangobot"), new String[0]));
    public static final ISetting<String> BOT_TOKEN = ConfigSetting.create((Config)CONFIG, (String)"BOT_TOKEN", (String)"empty");
    private static final EnumSet<GatewayIntent> intents = EnumSet.of(GatewayIntent.GUILD_MESSAGES, new GatewayIntent[]{GatewayIntent.DIRECT_MESSAGES, GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MESSAGE_REACTIONS, GatewayIntent.DIRECT_MESSAGE_REACTIONS, GatewayIntent.GUILD_VOICE_STATES, GatewayIntent.GUILD_EMOJIS_AND_STICKERS, GatewayIntent.SCHEDULED_EVENTS, GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_PRESENCES});
    private static final EnumSet<CacheFlag> cacheFlags = EnumSet.of(CacheFlag.EMOJI, new CacheFlag[]{CacheFlag.ROLE_TAGS, CacheFlag.VOICE_STATE, CacheFlag.ACTIVITY, CacheFlag.CLIENT_STATUS, CacheFlag.MEMBER_OVERRIDES, CacheFlag.STICKER, CacheFlag.SCHEDULED_EVENTS, CacheFlag.FORUM_TAGS});
    private final CommandManager commandManager = CommandManager.create();
    private final PagedListManager pagedListManager = new PagedListManager();
    private JDA jda;

    public MangoBot() {
        ACTION_REGISTRY.register((ButtonAction)new TrashButtonAction());
        this.commandManager.register((ICommand)new EmojiCommand());
        this.commandManager.register((ICommand)new PingCommand());
        this.commandManager.register((ICommand)new TrickCommand(this));
        this.commandManager.register((ICommand)new PingsCommand());
        this.commandManager.register((ICommand)new PauseCommand());
        this.commandManager.register((ICommand)new PlayCommand());
        this.commandManager.register((ICommand)new PlayingCommand());
        this.commandManager.register((ICommand)new QueueCommand(this.pagedListManager));
        this.commandManager.register((ICommand)new StopCommand());
        this.commandManager.register((ICommand)new VolumeCommand());
        this.commandManager.register((ICommand)new SkipCommand());
    }

    public String getId() {
        return ID;
    }

    public void load() {
        this.jda = JDABuilder.createDefault((String)((String)BOT_TOKEN.get())).setEnabledIntents(intents).enableCache(cacheFlags).setActivity(Activity.of((Activity.ActivityType)Activity.ActivityType.WATCHING, (String)"https://mangobot.mangorage.org/")).setStatus(OnlineStatus.ONLINE).setMemberCachePolicy(MemberCachePolicy.ALL).setEventManager((IEventManager)new AnnotatedEventManager()).setEnableShutdownHook(true).setAutoReconnect(true).build();
        this.getJDA().addEventListener(new Object[]{new BotEventListener(this)});
        this.jda.updateCommands().addCommands((Collection)Command.globalCommands).queue();
        System.out.println("Launched");
    }

    public JDA getJDA() {
        return this.jda;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public PagedListManager getPagedListManager() {
        return this.pagedListManager;
    }

    public Path getPluginDirectory() {
        return Path.of("plugins", new String[0]).resolve(ID).toAbsolutePath();
    }

    public MessageSettings getMessageSettings() {
        return MessageSettings.create().build();
    }
}

