/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotplugin.commands.music;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.bandcamp.BandcampAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.local.LocalAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.twitch.TwitchStreamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import net.dv8tion.jda.api.audio.AudioSendHandler;
import net.dv8tion.jda.api.audio.SpeakingMode;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.managers.AudioManager;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import net.dv8tion.jda.api.utils.MarkdownUtil;
import org.mangorage.commonutils.log.LogHelper;
import org.mangorage.commonutils.misc.PagedList;
import org.mangorage.entrypoint.MangoBotCore;
import org.mangorage.mangobotplugin.commands.music.MusicPlayer;
import org.mangorage.mangobotplugin.pagedlist.PagedListManager;
import org.mangorage.mangobotplugin.pagedlist.PagedListWithAction;

public class MusicUtil {
    public static void connectToAudioChannel(VoiceChannel channel) {
        try {
            Guild guild = channel.getGuild();
            AudioManager audioManager = guild.getAudioManager();
            MusicPlayer musicPlayer = MusicPlayer.getInstance(guild.getId());
            audioManager.setSendingHandler((AudioSendHandler)musicPlayer);
            audioManager.setSelfDeafened(true);
            audioManager.setSelfMuted(false);
            audioManager.setAutoReconnect(true);
            audioManager.setSpeakingMode(new SpeakingMode[]{SpeakingMode.SOUNDSHARE});
            audioManager.setConnectTimeout(30000L);
            musicPlayer.setVolume(5);
            audioManager.openAudioConnection((AudioChannel)channel);
        }
        catch (Exception e) {
            LogHelper.error((String)("Failed to connect to voice channel: " + e.getMessage()));
        }
    }

    public static void connectToAudioChannelNoMusic(VoiceChannel channel) {
        try {
            Guild guild = channel.getGuild();
            AudioManager audioManager = guild.getAudioManager();
            audioManager.setSelfDeafened(true);
            audioManager.setSelfMuted(false);
            audioManager.setAutoReconnect(true);
            audioManager.setSpeakingMode(new SpeakingMode[]{SpeakingMode.SOUNDSHARE});
            audioManager.setConnectTimeout(30000L);
            audioManager.openAudioConnection((AudioChannel)channel);
        }
        catch (Exception e) {
            LogHelper.error((String)("Failed to connect to voice channel: " + e.getMessage()));
        }
    }

    public static void leaveVoiceChannel(Guild guild) {
        guild.getAudioManager().closeAudioConnection();
    }

    public static void registerRemoteSources(AudioPlayerManager playerManager) {
        playerManager.registerSourceManager((AudioSourceManager)new TwitchStreamAudioSourceManager());
        playerManager.registerSourceManager((AudioSourceManager)new VimeoAudioSourceManager());
        playerManager.registerSourceManager((AudioSourceManager)SoundCloudAudioSourceManager.createDefault());
        playerManager.registerSourceManager((AudioSourceManager)new BandcampAudioSourceManager());
        playerManager.registerSourceManager((AudioSourceManager)new YoutubeAudioSourceManager());
        if (MangoBotCore.isDevMode()) {
            playerManager.registerSourceManager((AudioSourceManager)new LocalAudioSourceManager());
        }
        playerManager.registerSourceManager((AudioSourceManager)new HttpAudioSourceManager());
    }

    public static String formatDuration(long millis) {
        long seconds = millis / 1000L;
        long hours = seconds / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        if (secs > 0L || sb.length() == 0) {
            sb.append(secs).append("s");
        }
        return sb.toString().trim();
    }

    private static String getResult(PagedList.Page<String> page, int currentPage, int totalPage) {
        return "Song: (%s/%s)\n%s\n".formatted(currentPage, totalPage, ((String[])page.getEntries())[0]);
    }

    public static String getResultTrack(PagedList.Page<AudioTrack> page, int currentPage, int totalPage) {
        return "Song: (%s/%s)\n%s\n".formatted(currentPage, totalPage, MarkdownUtil.maskedLink((String)((AudioTrack[])page.getEntries())[0].getInfo().title, (String)((AudioTrack[])page.getEntries())[0].getInfo().uri));
    }

    public static void sendSongsQueue(MessageChannel channel, PagedListManager listManager, MusicPlayer manager, AudioTrack[] songs) {
        channel.sendMessage((CharSequence)"Getting List...\n").queue(m -> {
            PagedListWithAction list = new PagedListWithAction((pageList, button, id, total) -> {
                switch (id) {
                    case "next": {
                        pageList.next();
                        break;
                    }
                    case "prev": {
                        pageList.previous();
                        break;
                    }
                    case "add": {
                        manager.add(((AudioTrack[])pageList.current().getEntries())[0].makeClone());
                        ((ReplyCallbackAction)button.deferReply(true).setContent("Added Song to queue!")).queue();
                        return;
                    }
                }
                m.editMessage((CharSequence)MusicUtil.getResultTrack((PagedList.Page<AudioTrack>)pageList.current(), pageList.getPage(), total)).queue();
            });
            list.get().rebuild((Object[])songs, 1);
            Button prev = Button.primary((String)"prev", (String)"Previous");
            Button next = Button.primary((String)"next", (String)"Next");
            Button add = Button.primary((String)"add", (String)"Add to Queue");
            ((MessageEditAction)m.editMessage((CharSequence)MusicUtil.getResultTrack((PagedList.Page<AudioTrack>)list.get().current(), list.get().getPage(), list.get().totalPages())).setActionRow(new ItemComponent[]{prev, next, add})).queue();
            listManager.putList(m.getId(), list);
        });
    }

    public static void sendSongs(MessageChannel channel, PagedListManager listManager, MusicPlayer player) {
        String[] songs = (String[])player.getTracks().stream().map(track -> MarkdownUtil.maskedLink((String)track.getInfo().title, (String)track.getInfo().uri)).toArray(String[]::new);
        channel.sendMessage((CharSequence)"Getting List...\n").queue(m -> {
            PagedListWithAction list = new PagedListWithAction((pageList, button, id, total) -> {
                switch (id) {
                    case "next": {
                        pageList.next();
                        break;
                    }
                    case "prev": {
                        pageList.previous();
                    }
                }
                m.editMessage((CharSequence)MusicUtil.getResult((PagedList.Page<String>)pageList.current(), pageList.getPage(), total)).queue();
            });
            list.get().rebuild((Object[])songs, 1);
            Button prev = Button.primary((String)"prev", (String)"Previous");
            Button next = Button.primary((String)"next", (String)"Next");
            ((MessageEditAction)m.editMessage((CharSequence)MusicUtil.getResult((PagedList.Page<String>)list.get().current(), list.get().getPage(), list.get().totalPages())).setActionRow(new ItemComponent[]{prev, next})).queue();
            listManager.putList(m.getId(), list);
        });
    }
}

