/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotplugin.commands.music.commands;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import java.util.List;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.utils.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.mangorage.commonutils.misc.Arguments;
import org.mangorage.mangobotcore.jda.command.api.CommandResult;
import org.mangorage.mangobotcore.jda.command.api.ICommand;
import org.mangorage.mangobotplugin.commands.music.MusicPlayer;
import org.mangorage.mangobotplugin.commands.music.MusicUtil;
import org.mangorage.mangobotplugin.pagedlist.PagedListManager;

public final class QueueCommand
implements ICommand {
    private final PagedListManager pagedListManager;

    public QueueCommand(PagedListManager pagedListManager) {
        this.pagedListManager = pagedListManager;
    }

    public String id() {
        return "queue";
    }

    public List<String> commands() {
        return List.of("queue");
    }

    public String usage() {
        return "Queue Usage:\n\n!queue\n!queue url\n";
    }

    @NotNull
    public CommandResult execute(Message message, Arguments args) {
        MessageChannelUnion channel = message.getChannel();
        Guild guild = message.getGuild();
        MusicPlayer player = MusicPlayer.getInstance(guild.getId());
        if (args.getArgs().length == 0) {
            MusicUtil.sendSongs((MessageChannel)channel, this.pagedListManager, player);
            return CommandResult.PASS;
        }
        String URL2 = args.getFrom(0);
        if (URL2 != null) {
            player.load(URL2, e -> {
                switch (e.getReason()) {
                    case SUCCESS: {
                        if (URL2.startsWith("https://")) {
                            e.getTracks().forEach(player::add);
                            channel.sendMessage((CharSequence)"send '!queue' to see list of songs in queue!\nsend '!play' to have bot join and start playing next song!\n\n\nAdded to Queue:\n%s\n".formatted(MarkdownUtil.maskedLink((String)e.getTrack().getInfo().title, (String)e.getTrack().getInfo().uri))).queue();
                            break;
                        }
                        MusicUtil.sendSongsQueue((MessageChannel)channel, this.pagedListManager, player, (AudioTrack[])e.getTracks().toArray(AudioTrack[]::new));
                        break;
                    }
                    case FAILED: {
                        channel.sendMessage((CharSequence)"Failed").queue();
                        break;
                    }
                    case NO_MATCHES: {
                        channel.sendMessage((CharSequence)"No matches was found!").queue();
                    }
                }
            });
        }
        return CommandResult.PASS;
    }
}

