/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotplugin.commands.music;

import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import net.dv8tion.jda.api.audio.AudioSendHandler;
import org.mangorage.commonutils.log.LogHelper;
import org.mangorage.mangobotplugin.commands.music.AudioStatus;
import org.mangorage.mangobotplugin.commands.music.AudioTrackEvent;
import org.mangorage.mangobotplugin.commands.music.MusicUtil;

public final class MusicPlayer
extends AudioEventAdapter
implements AudioSendHandler {
    private static final HashMap<String, MusicPlayer> MUSIC_PLAYERS = new HashMap();
    private final DefaultAudioPlayerManager manager;
    private final DefaultAudioPlayer audioPlayer;
    private final Deque<AudioTrack> tracks = new ArrayDeque<AudioTrack>();
    private final String guildID;
    private AudioStatus status = AudioStatus.STOPPED;
    private AudioFrame lastFrame;

    public static MusicPlayer getInstance(String guildID) {
        if (!MUSIC_PLAYERS.containsKey(guildID)) {
            MusicPlayer player = new MusicPlayer(guildID);
            MUSIC_PLAYERS.put(guildID, player);
            return player;
        }
        return MUSIC_PLAYERS.get(guildID);
    }

    private MusicPlayer(String guildID) {
        this.guildID = guildID;
        this.manager = new DefaultAudioPlayerManager();
        this.audioPlayer = new DefaultAudioPlayer(this.manager);
        MusicUtil.registerRemoteSources((AudioPlayerManager)this.manager);
        this.audioPlayer.addListener((AudioEventListener)this);
    }

    public AudioTrack getPlaying() {
        return this.audioPlayer.getPlayingTrack();
    }

    public void setVolume(int volume) {
        this.audioPlayer.setVolume(volume);
    }

    public boolean isPlaying() {
        if (this.audioPlayer.getPlayingTrack() == null) {
            return false;
        }
        return this.audioPlayer.getPlayingTrack() != null;
    }

    public boolean isPaused() {
        return this.audioPlayer.isPaused();
    }

    public boolean isQueueEmpty() {
        return this.tracks.isEmpty();
    }

    public void load(String URL2, final Consumer<AudioTrackEvent> eventConsumer) {
        try {
            this.manager.loadItem(URL2, new AudioLoadResultHandler(){

                public void trackLoaded(AudioTrack track) {
                    eventConsumer.accept(new AudioTrackEvent(track, AudioTrackEvent.Info.SUCCESS));
                }

                public void playlistLoaded(AudioPlaylist playlist) {
                    eventConsumer.accept(new AudioTrackEvent(playlist.getTracks(), AudioTrackEvent.Info.SUCCESS));
                }

                public void noMatches() {
                    eventConsumer.accept(new AudioTrackEvent(AudioTrackEvent.Info.NO_MATCHES));
                }

                public void loadFailed(FriendlyException exception) {
                    eventConsumer.accept(new AudioTrackEvent(AudioTrackEvent.Info.FAILED));
                    LogHelper.info((String)exception.getMessage());
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public AudioStatus getStatus() {
        return this.status;
    }

    public List<AudioTrack> getTracks() {
        return this.tracks.stream().toList();
    }

    public void play() {
        AudioTrack track = this.tracks.poll();
        if (track != null) {
            this.audioPlayer.playTrack(track);
        }
    }

    public void playNext() {
        this.play();
    }

    public void add(AudioTrack track) {
        this.tracks.add(track);
    }

    public void pause() {
        this.audioPlayer.setPaused(true);
    }

    public void resume() {
        this.audioPlayer.setPaused(false);
        if (this.audioPlayer.getPlayingTrack() == null) {
            this.playNext();
        }
    }

    public void stop() {
        this.audioPlayer.stopTrack();
    }

    public void onPlayerPause(AudioPlayer player) {
        this.status = AudioStatus.PAUSED;
    }

    public void onPlayerResume(AudioPlayer player) {
        this.status = AudioStatus.PLAYING;
    }

    public void onTrackStart(AudioPlayer player, AudioTrack track) {
        this.status = AudioStatus.PLAYING;
    }

    public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
        this.status = AudioStatus.STOPPED;
        if (endReason.mayStartNext) {
            this.playNext();
        }
    }

    public void onTrackException(AudioPlayer player, AudioTrack track, FriendlyException exception) {
        LogHelper.info((String)exception.getMessage());
    }

    public boolean canProvide() {
        this.lastFrame = this.audioPlayer.provide();
        return this.lastFrame != null;
    }

    public ByteBuffer provide20MsAudio() {
        return ByteBuffer.wrap(this.lastFrame.getData());
    }

    public boolean isOpus() {
        return true;
    }
}

