/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotplugin;

import java.util.HashMap;
import java.util.Map;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import org.mangorage.commonutils.misc.PagedList;
import org.mangorage.mangobotcore.jda.event.DiscordButtonInteractEvent;
import org.mangorage.mangobotplugin.PagedListWithAction;

public final class PagedListManager {
    private final Map<String, PagedListWithAction> pages = new HashMap<String, PagedListWithAction>();

    public PagedListManager() {
        DiscordButtonInteractEvent.BUS.addListener(this::onButton);
    }

    public void putList(String id, PagedListWithAction pagedListWithAction) {
        this.pages.put(id, pagedListWithAction);
    }

    public void removeList(String id) {
        this.pages.remove(id);
    }

    public PagedList.Page<String> next(String id) {
        return this.pages.get(id).get().next();
    }

    public PagedList.Page<String> previous(String id) {
        return this.pages.get(id).get().previous();
    }

    private void update(PagedListWithAction action, String buttonID) {
        PagedList<String> list = action.get();
        switch (buttonID) {
            case "next": {
                list.next();
                break;
            }
            case "prev": {
                list.previous();
            }
        }
        action.consume();
    }

    public void onButton(DiscordButtonInteractEvent event) {
        ButtonInteractionEvent interaction = (ButtonInteractionEvent)event.getDiscordEvent();
        Message message = interaction.getMessage();
        String ID = message.getId();
        if (this.pages.containsKey(ID)) {
            this.update(this.pages.get(ID), interaction.getButton().getId());
            interaction.getInteraction().deferEdit().queue();
        }
    }
}

