/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotplugin.commands.music;

import com.sedmelluq.discord.lavaplayer.container.MediaContainerRegistry;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.bandcamp.BandcampAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.beam.BeamAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.getyarn.GetyarnAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.http.HttpAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.soundcloud.SoundCloudAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.vimeo.VimeoAudioSourceManager;
import dev.lavalink.youtube.YoutubeAudioSourceManager;
import net.dv8tion.jda.api.audio.AudioSendHandler;
import net.dv8tion.jda.api.audio.SpeakingMode;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.channel.concrete.VoiceChannel;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.managers.AudioManager;
import org.mangorage.commonutils.log.LogHelper;
import org.mangorage.mangobotplugin.commands.music.MusicPlayer;

public class MusicUtil {
    public static void connectToAudioChannel(VoiceChannel channel) {
        try {
            Guild guild = channel.getGuild();
            AudioManager audioManager = guild.getAudioManager();
            audioManager.setSendingHandler((AudioSendHandler)MusicPlayer.getInstance(guild.getId()));
            audioManager.setSelfDeafened(true);
            audioManager.setSelfMuted(false);
            audioManager.setAutoReconnect(true);
            audioManager.setSpeakingMode(new SpeakingMode[]{SpeakingMode.SOUNDSHARE});
            audioManager.setConnectTimeout(30000L);
            MusicPlayer.getInstance(guild.getId()).setVolume(5);
            audioManager.openAudioConnection((AudioChannel)channel);
        }
        catch (Exception e) {
            LogHelper.error((String)("Failed to connect to voice channel: " + e.getMessage()));
        }
    }

    public static void connectToAudioChannelNoMusic(VoiceChannel channel) {
        try {
            Guild guild = channel.getGuild();
            AudioManager audioManager = guild.getAudioManager();
            audioManager.setSelfDeafened(true);
            audioManager.setSelfMuted(false);
            audioManager.setAutoReconnect(true);
            audioManager.setSpeakingMode(new SpeakingMode[]{SpeakingMode.SOUNDSHARE});
            audioManager.setConnectTimeout(30000L);
            audioManager.openAudioConnection((AudioChannel)channel);
        }
        catch (Exception e) {
            LogHelper.error((String)("Failed to connect to voice channel: " + e.getMessage()));
        }
    }

    public static void leaveVoiceChannel(Guild guild) {
        guild.getAudioManager().closeAudioConnection();
    }

    public static void registerRemoteSources(AudioPlayerManager playerManager) {
        MediaContainerRegistry containerRegistry = MediaContainerRegistry.DEFAULT_REGISTRY;
        playerManager.registerSourceManager((AudioSourceManager)new YoutubeAudioSourceManager());
        playerManager.registerSourceManager((AudioSourceManager)SoundCloudAudioSourceManager.createDefault());
        playerManager.registerSourceManager((AudioSourceManager)new BandcampAudioSourceManager());
        playerManager.registerSourceManager((AudioSourceManager)new VimeoAudioSourceManager());
        playerManager.registerSourceManager((AudioSourceManager)new BeamAudioSourceManager());
        playerManager.registerSourceManager((AudioSourceManager)new GetyarnAudioSourceManager());
        playerManager.registerSourceManager((AudioSourceManager)new HttpAudioSourceManager(containerRegistry));
    }
}

