/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotplugin.commands.internal;

import java.io.InputStream;
import java.util.List;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Icon;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import org.mangorage.commonutils.misc.Arguments;
import org.mangorage.mangobotcore.jda.command.api.CommandResult;
import org.mangorage.mangobotcore.jda.command.api.ICommand;

public final class EmojiCommand
implements ICommand {
    public String id() {
        return "emoji";
    }

    public List<String> commands() {
        return List.of("emoji");
    }

    public String usage() {
        return "Emoji Usage:\n\n!emoji create <name/id> <emoji>\n!emoji create <name/id> <emojiName> <emojiId>\n";
    }

    public CommandResult execute(Message message, Arguments arguments) {
        String sub_cmd = arguments.get(0);
        if (sub_cmd.contains("create")) {
            Member requester = message.getMember();
            if (!requester.hasPermission(new Permission[]{Permission.ADMINISTRATOR})) {
                return CommandResult.NO_PERMISSION;
            }
            if (arguments.getArgs().length == 4) {
                CustomEmoji ce = Emoji.fromFormatted((String)("<:" + arguments.get(2) + ":" + arguments.get(3) + ">")).asCustom();
                try {
                    message.getGuild().createEmoji(arguments.get(1), Icon.from((InputStream)((InputStream)ce.getImage().download().get())), new Role[0]).queue(s -> message.reply((CharSequence)"Successfully added new Emoji!").queue());
                }
                catch (Throwable e) {
                    message.reply((CharSequence)"Failed").queue();
                }
            } else if (arguments.getArgs().length == 3) {
                CustomEmoji ce = Emoji.fromFormatted((String)arguments.get(2)).asCustom();
                try {
                    message.getGuild().createEmoji(arguments.get(1), Icon.from((InputStream)((InputStream)ce.getImage().download().get())), new Role[0]).queue(s -> message.reply((CharSequence)"Successfully added new Emoji!").queue());
                }
                catch (Throwable e) {
                    message.reply((CharSequence)"Failed").queue();
                }
            } else {
                message.reply((CharSequence)"Improper Usage").queue();
            }
            return CommandResult.PASS;
        }
        return CommandResult.PASS;
    }
}

