/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobotplugin.commands.trick.lua;

import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import org.mangorage.commonutils.data.IFileNameResolver;
import org.mangorage.mangobotplugin.MangoBot;
import org.mangorage.mangobotplugin.commands.trick.Trick;
import org.mangorage.mangobotplugin.commands.trick.TrickCommand;
import org.mangorage.mangobotplugin.commands.trick.lua.builders.LuaEmbedBuilder;
import org.mangorage.mangobotplugin.commands.trick.lua.builders.LuaMessageResponseBuilder;
import org.mangorage.mangobotplugin.commands.trick.lua.helpers.LuaInfoHelper;
import org.mangorage.mangobotplugin.commands.trick.lua.helpers.LuaObjectHelper;

public final class LuaJDA {
    private final MangoBot JDAPlugin;
    private final Message message;
    private final MessageChannel messageChannel;
    private final Trick trick;

    public LuaJDA(MangoBot plugin, Trick trick, Message message, MessageChannel channel) {
        this.JDAPlugin = plugin;
        this.message = message;
        this.messageChannel = channel;
        this.trick = trick;
    }

    public Object getStored(String key) {
        return this.trick.getMemoryBank().bank().get(key);
    }

    public Object getStoredOrSetAndGet(String key, Object value) {
        Object result = this.getStored(key);
        if (result == null) {
            this.storeValue(key, value);
            return value;
        }
        return result;
    }

    public void storeValue(String key, Object o) {
        this.trick.getMemoryBank().bank().put(key, o);
        TrickCommand.TRICK_DATA_HANDLER.save(this.JDAPlugin.getPluginDirectory(), (IFileNameResolver[])new Trick[]{this.trick});
    }

    public LuaEmbedBuilder createEmbed() {
        return new LuaEmbedBuilder();
    }

    public LuaMessageResponseBuilder respond() {
        return new LuaMessageResponseBuilder(this.message.reply((CharSequence)""));
    }

    public LuaInfoHelper getInfoHelper() {
        return new LuaInfoHelper(this.message, this.messageChannel);
    }

    public LuaObjectHelper getObjectHelper() {
        return new LuaObjectHelper();
    }
}

