/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.music;

import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioReference;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import com.sedmelluq.discord.lavaplayer.track.playback.AudioFrame;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.function.Consumer;
import net.dv8tion.jda.api.audio.AudioSendHandler;
import org.mangorage.basicutils.LogHelper;
import org.mangorage.mangobot.modules.music.AudioStatus;
import org.mangorage.mangobot.modules.music.AudioTrackEvent;
import org.mangorage.mangobot.modules.music.MusicUtil;

public class MusicPlayer
extends AudioEventAdapter
implements AudioSendHandler {
    private static final HashMap<String, MusicPlayer> MUSIC_PLAYERS = new HashMap();
    private final DefaultAudioPlayerManager manager;
    private final DefaultAudioPlayer audioPlayer;
    private final Deque<AudioTrack> TRACKS_QUEUE = new ArrayDeque<AudioTrack>();
    private final String guildID;
    private AudioStatus status = AudioStatus.STOPPED;
    private AudioFrame lastFrame;

    public static MusicPlayer getInstance(String guildID) {
        if (!MUSIC_PLAYERS.containsKey(guildID)) {
            MusicPlayer player = new MusicPlayer(guildID);
            MUSIC_PLAYERS.put(guildID, player);
            return player;
        }
        return MUSIC_PLAYERS.get(guildID);
    }

    private MusicPlayer(String guildID) {
        this.guildID = guildID;
        this.manager = new DefaultAudioPlayerManager();
        this.audioPlayer = new DefaultAudioPlayer(this.manager);
        MusicUtil.registerRemoteSources((AudioPlayerManager)this.manager);
        this.audioPlayer.addListener((AudioEventListener)this);
    }

    public AudioTrack getPlaying() {
        return this.audioPlayer.getPlayingTrack();
    }

    public void setVolume(int volume) {
        this.audioPlayer.setVolume(volume);
    }

    public boolean isPlaying() {
        if (this.audioPlayer.getPlayingTrack() == null) {
            return false;
        }
        return this.audioPlayer.getPlayingTrack() != null;
    }

    public boolean isQueueEmpty() {
        return this.TRACKS_QUEUE.isEmpty();
    }

    public void load(String URL2, final Consumer<AudioTrackEvent> eventConsumer) {
        this.manager.loadItem(new AudioReference(URL2.trim(), null), new AudioLoadResultHandler(){

            public void trackLoaded(AudioTrack track) {
                eventConsumer.accept(new AudioTrackEvent(track, AudioTrackEvent.Info.SUCCESS));
            }

            public void playlistLoaded(AudioPlaylist playlist) {
            }

            public void noMatches() {
                eventConsumer.accept(new AudioTrackEvent(null, AudioTrackEvent.Info.NO_MATCHES));
            }

            public void loadFailed(FriendlyException exception) {
                eventConsumer.accept(new AudioTrackEvent(null, AudioTrackEvent.Info.FAILED));
                LogHelper.info((String)exception.getMessage());
            }
        });
    }

    public AudioStatus getStatus() {
        return this.status;
    }

    public void play() {
        AudioTrack track = this.TRACKS_QUEUE.poll();
        if (track != null) {
            this.audioPlayer.playTrack(track);
        }
    }

    public void playNext() {
    }

    public void add(AudioTrack track) {
        this.TRACKS_QUEUE.add(track);
    }

    public void pause() {
        this.audioPlayer.setPaused(true);
    }

    public void resume() {
        this.audioPlayer.setPaused(false);
    }

    public void stop() {
        this.audioPlayer.stopTrack();
    }

    public void onPlayerPause(AudioPlayer player) {
        this.status = AudioStatus.PAUSED;
    }

    public void onPlayerResume(AudioPlayer player) {
        this.status = AudioStatus.PLAYING;
    }

    public void onTrackStart(AudioPlayer player, AudioTrack track) {
        this.status = AudioStatus.PLAYING;
    }

    public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
        this.status = AudioStatus.STOPPED;
        if (endReason.mayStartNext) {
            this.playNext();
        }
    }

    public void onTrackException(AudioPlayer player, AudioTrack track, FriendlyException exception) {
        LogHelper.info((String)exception.getMessage());
    }

    public boolean canProvide() {
        this.lastFrame = this.audioPlayer.provide();
        return this.lastFrame != null;
    }

    public ByteBuffer provide20MsAudio() {
        return ByteBuffer.wrap(this.lastFrame.getData());
    }

    public boolean isOpus() {
        return true;
    }
}

