/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.logs;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import org.mangorage.mangobot.modules.logs.LogAnalyserModule;

public final class LogAnalyser {
    private final Set<LogAnalyserModule> mods = new HashSet<LogAnalyserModule>();

    public static LogAnalyser of(LogAnalyserModule ... modules) {
        return new LogAnalyser(List.of(modules));
    }

    public static LogAnalyserModule createModule(LogAnalyserModule module, List<String> strings) {
        return LogAnalyser.createModule(module, String::contains, strings);
    }

    public static LogAnalyserModule createModule(final LogAnalyserModule module, final BiPredicate<String, String> comparePredicate, final List<String> strings) {
        return new LogAnalyserModule(){
            private final List<String> stringsList;
            {
                this.stringsList = strings;
            }

            @Override
            public void analyse(String str, StringBuilder message) {
                boolean foundAll = true;
                for (String string : this.stringsList) {
                    if (comparePredicate.test(str, string)) continue;
                    foundAll = false;
                    break;
                }
                if (foundAll) {
                    module.analyse(str, message);
                }
            }
        };
    }

    private LogAnalyser(List<LogAnalyserModule> mods) {
        this.mods.addAll(mods);
    }

    public void add(LogAnalyserModule module) {
        this.mods.add(module);
    }

    public void addAll(LogAnalyserModule ... modules) {
        this.mods.addAll(List.of(modules));
    }

    public void readLog(StringBuilder message, String log) {
        log = log.replaceAll("\\r?\\n", "\\n");
        for (LogAnalyserModule mod : this.mods) {
            mod.analyse(log, message);
        }
    }
}

