/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.logs.modules;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;

public class StackTraceReader {
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("(?m)(^\\S.*(?:\\r?\\n[ \\t]+at\\s+.*)+)");
    private static final Pattern JSON_FILE_PATTERN = Pattern.compile("(\\S+\\.json)(?=[: ])");
    private static final Pattern BRACE_CONTENT_PATTERN = Pattern.compile("\\{([^}]+)\\}");
    public static String nl = System.lineSeparator();
    List<String> sm_config = new ArrayList<String>();
    Map<String, Boolean> jars = new LinkedHashMap<String, Boolean>();
    Map<String, Boolean> modids = new LinkedHashMap<String, Boolean>();
    Map<String, Boolean> packs = new LinkedHashMap<String, Boolean>();
    List<String> braceContents = new LinkedList<String>();
    List<String> fatal_missing_classes = new ArrayList<String>();
    List<String> bad_jar = new ArrayList<String>();
    List<String> bad_modid = new ArrayList<String>();
    List<String> bad_package = new ArrayList<String>();
    StringBuilder build = new StringBuilder();

    /*
     * WARNING - void declaration
     */
    public void analyse(String log, Message message) {
        int lvl = 0;
        for (Iterator<Object> trace : this.getFatalTraces(log).reversed()) {
            this.processTrace((String)((Object)trace), true, ++lvl);
        }
        for (Iterator<Object> trace : StackTraceReader.getTraces(log).reversed()) {
            this.processTrace((String)((Object)trace), false, ++lvl);
        }
        ArrayList<CallSite> jar_names = new ArrayList<CallSite>();
        if (!this.jars.isEmpty()) {
            this.build.append("**Found potentially problematic JAR files (Prioritise FATAL then Higher lvl then lower ln):**").append(nl);
            for (Map.Entry<String, Boolean> entry : this.jars.entrySet()) {
                void var8_17;
                String jar_name;
                String[] lvl_info_arr = entry.getKey().split(Pattern.quote(" **lvl ** "));
                String string = "";
                if (lvl_info_arr.length > 1) {
                    String string2 = " **lvl ** " + lvl_info_arr[1];
                } else {
                    System.out.println(lvl_info_arr[0]);
                }
                if (jar_names.contains(jar_name = entry.getKey().split(".jar")[0] + ".jar" + (String)var8_17)) continue;
                if (entry.getValue().booleanValue()) {
                    this.build.append("**Possibly Fatal:** ");
                }
                this.build.append(jar_name).append(nl);
                jar_names.add((CallSite)((Object)jar_name));
            }
        }
        if (!this.modids.isEmpty()) {
            this.build.append("**Found potentially problematic modids (Prioritise FATAL then Higher lvl then lower ln):**").append(nl);
            for (Map.Entry<String, Boolean> entry : this.modids.entrySet()) {
                if (entry.getValue().booleanValue()) {
                    this.build.append("**Possibly Fatal:** ");
                }
                this.build.append(entry.getKey()).append(nl);
            }
        }
        if (!this.packs.isEmpty()) {
            this.build.append("**Found potentially problematic packages (Prioritise FATAL then Higher lvl then lower ln):**").append(nl);
            for (Map.Entry entry : this.packs.entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) {
                    this.build.append("**Possibly Fatal:** ");
                }
                this.build.append((String)entry.getKey()).append(nl);
            }
        }
        if (!this.packs.isEmpty()) {
            this.build.append("**Found potentially fatal mising classes:**").append(nl);
            for (String string : this.fatal_missing_classes) {
                this.build.append(string).append(nl);
            }
        }
        LinkedList<String> injected_configs = new LinkedList<String>();
        for (String content : this.braceContents.reversed()) {
            for (String ind : StackTraceReader.removeDuplicates(content.split(","))) {
                String cleansed = ind.replace("pl:runtimedistcleaner:A", "").replace("re:classloading", "").replace("pl:mixin:APP:", "").replace("re:computing_frames", "").replace("pl:accesstransformer:B", "").replace("pl:mixin:A", "").replace("xf:fml", "").replace("featurecreep", "").replace("re:mixin", "");
                if (injected_configs.contains(cleansed) || cleansed.isEmpty()) continue;
                injected_configs.add(cleansed);
            }
        }
        if (!injected_configs.isEmpty()) {
            this.build.append("**Found contents in {} (Top is most important, only top 8 shown):**").append(nl);
            boolean bl = false;
            for (String string : injected_configs) {
                void var6_15;
                if (var6_15 > 8) continue;
                this.build.append(string.split(".json")[0].replace(".mixin", "").replace("mixin.", "")).append(nl);
                ++var6_15;
            }
        }
        if (!this.build.toString().isEmpty()) {
            ((MessageCreateAction)((MessageCreateAction)message.reply((CharSequence)this.build.toString()).setSuppressEmbeds(true)).mentionRepliedUser(true)).queue();
        }
    }

    public void processTrace(String trace, boolean fatal, int lvl) {
        List<String> jsonFiles = this.findJsonFilesInMixinExceptions(trace);
        if (!jsonFiles.isEmpty()) {
            for (String jsonFile : jsonFiles) {
                if (this.sm_config.contains(jsonFile) || jsonFile.endsWith(".refmap.json")) continue;
                this.sm_config.add(jsonFile);
                this.build.append("**Potentially Problematic SpongeMixin Config:** " + jsonFile).append(nl);
            }
        } else {
            String[] arr = trace.split(nl);
            int line_num = 0;
            for (String untrimmed : arr) {
                ++line_num;
                String line = untrimmed.trim();
                if (line.contains("[")) {
                    this.extractJarNamesSquareBracket(line, fatal, lvl, line_num);
                } else if (line.contains("/")) {
                    String modid;
                    String[] arr_modid = line.split("/");
                    if (arr_modid.length > 1 && !this.bad_modid.contains(modid = arr_modid[1].split("@")[0]) && !line.split("/")[0].startsWith("java.") && !this.isModIDDenylisted(modid) && line.startsWith("at")) {
                        this.bad_modid.add(modid);
                        this.modids.put(modid + " **lvl ** " + String.valueOf(lvl) + "** ln** " + String.valueOf(line_num), fatal);
                    }
                } else if (line.startsWith("at")) {
                    String pack;
                    int line_len = 25;
                    if (line.length() - 11 < 25) {
                        line_len = line.length() - 11;
                    }
                    if (!this.bad_package.contains(pack = line.substring(3, line_len)) && !this.packIsDenyListed(pack)) {
                        this.packs.put(pack + " **lvl ** " + Integer.toString(lvl) + "** ln** " + Integer.toString(line_num), fatal);
                        this.bad_package.add(pack);
                    }
                } else if (line.contains("ClassNotFoundException") && fatal) {
                    this.fatal_missing_classes.add("**FATAL** Missing Class: " + line);
                }
                Matcher braceMatcher = BRACE_CONTENT_PATTERN.matcher(line);
                while (braceMatcher.find()) {
                    String content = braceMatcher.group(1).trim();
                    if (this.braceContents.contains(content)) continue;
                    this.braceContents.add(content);
                }
            }
        }
    }

    private boolean isModIDDenylisted(String modid) {
        String[] ids;
        if (modid.isBlank()) {
            return true;
        }
        for (String id : ids = new String[]{"java", "minecraft", "minecraftforge", "eventbus", "cpw.", "coremods", "featurecreep", "mixin", "accesstransformer", "authlib", "jdk.", "java.", "fmlloader", "fmlcore", "org.spongepowered.mixin", "fmlearlydisplay"}) {
            if (!modid.startsWith(id)) continue;
            return true;
        }
        return false;
    }

    private boolean packIsDenyListed(String pack) {
        String[] prefixes;
        for (String prefix : prefixes = new String[]{"java.", "net.minecraft.", "net.minecraftforge.", "com.mojang.", "cpw.", "featurecreep.", "jdk.", "sun.", "com.sun.", "org.lwjgl.", "org.apache.", "io.netty", "org.prismlauncher", "io.github.zekerzhayard", "org.multimc", "org.polymc", "org.tlauncher"}) {
            if (!pack.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static String[] removeDuplicates(String[] inputArray) {
        HashSet<String> set = new HashSet<String>(Arrays.asList(inputArray));
        String[] resultArray = set.toArray(new String[0]);
        return resultArray;
    }

    private List<String> getFatalTraces(String log) {
        ArrayList<String> ret = new ArrayList<String>();
        String[] lines = log.split(nl);
        int len = lines.length;
        for (int i = 0; i < len; ++i) {
            String line = lines[i];
            if (!line.contains("/FATAL]") || i + 2 > len) continue;
            StringBuilder trace = new StringBuilder();
            trace.append(lines[i + 1]);
            this.addFatalTraces(trace, lines, i + 2);
            ret.add(trace.toString());
        }
        return ret;
    }

    private void addFatalTraces(StringBuilder trace, String[] lines, int index) {
        int len = lines.length;
        for (int i = index; i < len; ++i) {
            String line = lines[i];
            if (!line.trim().startsWith("at ")) {
                return;
            }
            trace.append(line);
        }
    }

    private void extractJarNamesSquareBracket(String line, boolean fatal, int lvl, int line_num) {
        int startIdx = line.indexOf(91);
        int endIdx = line.indexOf(93);
        while (startIdx != -1 && endIdx != -1 && startIdx < endIdx) {
            String candidate = line.substring(startIdx + 1, endIdx);
            if (candidate.contains(".jar") && !this.isJarDenied(candidate) && !this.bad_jar.contains(candidate)) {
                this.bad_jar.add(candidate);
                this.jars.put(candidate + " **lvl ** " + Integer.toString(lvl) + "** ln** " + Integer.toString(line_num), fatal);
            }
            startIdx = line.indexOf(91, endIdx);
            endIdx = line.indexOf(93, endIdx + 1);
        }
    }

    public static List<String> getTraces(String log) {
        ArrayList<String> stackTraces = new ArrayList<String>();
        Matcher matcher = STACK_TRACE_PATTERN.matcher(log);
        while (matcher.find()) {
            stackTraces.add(matcher.group());
        }
        return stackTraces;
    }

    public List<String> findJsonFilesInMixinExceptions(String logContent) {
        String[] lines;
        ArrayList<String> jsonFiles = new ArrayList<String>();
        for (String line : lines = logContent.split("\r?\n")) {
            if (!line.contains("org.spongepowered.asm.mixin")) continue;
            Matcher matcher = JSON_FILE_PATTERN.matcher(line.trim());
            while (matcher.find()) {
                if (matcher.group(1) == null) continue;
                jsonFiles.add(matcher.group(1));
            }
        }
        return jsonFiles;
    }

    private boolean isJarDenied(String jarName) {
        if (jarName.startsWith("fml")) {
            return true;
        }
        if (jarName.startsWith("forge-")) {
            return true;
        }
        if (jarName.contains("fmlcore")) {
            return true;
        }
        if (jarName.startsWith("mixin")) {
            return true;
        }
        if (jarName.startsWith("gson-")) {
            return true;
        }
        if (jarName.startsWith("eventbus")) {
            return true;
        }
        if (jarName.startsWith("featurecreep-")) {
            return true;
        }
        if (jarName.startsWith("server-")) {
            return true;
        }
        if (jarName.startsWith("modlauncher")) {
            return true;
        }
        if (jarName.startsWith("javafmllanguage")) {
            return true;
        }
        if (jarName.startsWith("client-")) {
            return true;
        }
        if (jarName.startsWith("lwjgl-")) {
            return true;
        }
        if (jarName.startsWith("netty-")) {
            return true;
        }
        if (jarName.startsWith("bootstraplauncher")) {
            return true;
        }
        if (jarName.startsWith("securejarhandler")) {
            return true;
        }
        if (jarName.startsWith("core-")) {
            return true;
        }
        if (jarName.startsWith("loader-")) {
            return true;
        }
        if (jarName.startsWith("language-")) {
            return true;
        }
        if (jarName.startsWith("minecraft-") && jarName.contains("server")) {
            return true;
        }
        return jarName.startsWith("minecraft-") && jarName.contains("client");
    }
}

