/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.logs;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import net.dv8tion.jda.api.entities.Message;
import org.mangorage.mangobot.core.Util;
import org.mangorage.mangobot.modules.logs.LogAnalyserModule;

public final class LogAnalyser {
    private final Set<LogAnalyserModule> mods = new HashSet<LogAnalyserModule>();
    public String[] supported_paste_sites = new String[]{"paste.mikumikudance.jp/", "paste.centos.org/", "pastebin.com/", "mclo.gs/"};

    public static LogAnalyser of(LogAnalyserModule ... modules) {
        return new LogAnalyser(List.of(modules));
    }

    public static LogAnalyserModule createModule(LogAnalyserModule module, List<String> strings) {
        return LogAnalyser.createModule(module, String::contains, strings);
    }

    public static LogAnalyserModule createModule(final LogAnalyserModule module, final BiPredicate<String, String> comparePredicate, final List<String> strings) {
        return new LogAnalyserModule(){
            private final List<String> stringsList;
            {
                this.stringsList = strings;
            }

            @Override
            public void analyse(String str, StringBuilder message) {
                boolean foundAll = true;
                for (String string : this.stringsList) {
                    if (comparePredicate.test(str, string)) continue;
                    foundAll = false;
                    break;
                }
                if (foundAll) {
                    module.analyse(str, message);
                }
            }
        };
    }

    private LogAnalyser(List<LogAnalyserModule> mods) {
        this.mods.addAll(mods);
    }

    public void add(LogAnalyserModule module) {
        this.mods.add(module);
    }

    public void addAll(LogAnalyserModule ... modules) {
        this.mods.addAll(List.of(modules));
    }

    public void scanMessage(Message message, StringBuilder stringBuilder) {
        String content = message.getContentStripped();
        for (String uri : this.getLogURLs(content)) {
            InputStream log = Util.getFileInputStream(uri);
            if (log == null) continue;
            try {
                String str = Util.getStringFromInputStream(log);
                this.readLog(stringBuilder, str);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public ArrayList<String> getLogURLs(String message) {
        ArrayList<String> list = new ArrayList<String>();
        for (String word : message.split(" ")) {
            for (String paste : this.supported_paste_sites) {
                String slug;
                String[] url_arr;
                if (!word.contains(paste)) continue;
                if (paste.equals("mclo.gs/")) {
                    url_arr = word.split("/");
                    slug = url_arr[url_arr.length - 1];
                    list.add("https://api.mclo.gs/1/raw/" + slug);
                    continue;
                }
                if (paste.equals("pastebin.com/")) {
                    url_arr = word.split("/");
                    slug = url_arr[url_arr.length - 1];
                    list.add("https://pastebin.com/raw/" + slug);
                    continue;
                }
                if (word.contains("/view/raw/")) {
                    list.add(word);
                    continue;
                }
                if (!word.contains("/view/")) continue;
                list.add(word.replace("/view/", "/view/raw/"));
            }
        }
        return list;
    }

    public void readLog(StringBuilder message, String log) {
        for (LogAnalyserModule mod : this.mods) {
            mod.analyse(log, message);
        }
    }
}

