/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.basic.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import org.jetbrains.annotations.NotNull;
import org.mangorage.mangobot.modules.basic.commands.PingCommand;
import org.mangorage.mangobotapi.core.commands.Arguments;
import org.mangorage.mangobotapi.core.commands.CommandResult;
import org.mangorage.mangobotapi.core.commands.IBasicCommand;
import org.mangorage.mangobotapi.core.data.DataHandler;
import org.mangorage.mangobotapi.core.data.IEmptyFileNameResolver;
import org.mangorage.mangobotapi.core.data.IFileNameResolver;
import org.mangorage.mangobotapi.core.events.DiscordEvent;
import org.mangorage.mangobotapi.core.events.LoadEvent;
import org.mangorage.mangobotapi.core.events.SaveEvent;
import org.mangorage.mangobotapi.core.plugin.extra.JDAPlugin;

public class AntiPingCommand
implements IBasicCommand {
    private static final HashMap<Key, Boolean> FLAGS = new HashMap();
    private static final DataHandler<SaveData> HANDLER = DataHandler.create().path("data/antiping/config").file().build(SaveData.class);
    private final JDAPlugin plugin;

    public AntiPingCommand(JDAPlugin plugin) {
        this.plugin = plugin;
        plugin.getPluginBus().addGenericListener(0, MessageReceivedEvent.class, DiscordEvent.class, this::onMessage2);
        plugin.getPluginBus().addListener(0, LoadEvent.class, loadEvent -> {
            Optional data = HANDLER.loadFile(plugin.getPluginDirectory());
            data.ifPresent(save -> FLAGS.putAll(save.toMap()));
        });
        plugin.getPluginBus().addListener(0, SaveEvent.class, save -> HANDLER.save(plugin.getPluginDirectory(), (IFileNameResolver[])new SaveData[]{SaveData.fromMap(FLAGS)}));
    }

    public void onMessage2(DiscordEvent<MessageReceivedEvent> event) {
        MessageReceivedEvent dEvent = (MessageReceivedEvent)event.getInstance();
        Message msg = dEvent.getMessage();
        if (msg.getAuthor().isBot()) {
            return;
        }
        Message msgReference = msg.getReferencedMessage();
        if (msgReference != null) {
            long guildID;
            User authorPinged = msgReference.getAuthor();
            if (authorPinged.isBot()) {
                return;
            }
            long l = guildID = dEvent.isFromGuild() ? dEvent.getGuild().getIdLong() : -1L;
            if (guildID == -1L) {
                return;
            }
            User whoPinged = msg.getAuthor();
            if (!msg.getMentions().isMentioned((IMentionable)authorPinged, new Message.MentionType[0])) {
                return;
            }
            Key key = new Key(guildID, authorPinged.getIdLong());
            if (FLAGS.containsKey(key) && FLAGS.get(key).booleanValue()) {
                whoPinged.openPrivateChannel().queue(pc -> ((MessageCreateAction)((MessageCreateAction)pc.sendMessageEmbeds(PingCommand.EMBED, new MessageEmbed[0]).setContent("")).setContent("Please do not ping this person -> %s".formatted(msgReference.getJumpUrl()))).queue());
            }
        }
    }

    @NotNull
    public CommandResult execute(Message message, Arguments args) {
        long serverID;
        long userID = message.getAuthor().getIdLong();
        long l = serverID = message.isFromGuild() ? message.getGuild().getIdLong() : -1L;
        if (serverID == -1L) {
            return CommandResult.PASS;
        }
        Key key = new Key(serverID, userID);
        FLAGS.compute(key, (k, value) -> {
            boolean returnValue = value == null || value == false;
            message.reply((CharSequence)("Set Anti Ping Reponse " + (!returnValue ? "Off" : "On"))).queue();
            return returnValue;
        });
        HANDLER.save(this.plugin.getPluginDirectory(), (IFileNameResolver[])new SaveData[]{SaveData.fromMap(FLAGS)});
        return CommandResult.PASS;
    }

    public String commandId() {
        return "antiping";
    }

    public String usage() {
        return "!antiping";
    }

    public List<String> commandAliases() {
        return List.of();
    }

    public String description() {
        return "Makes it so bot asks people nicely to not ping you if you are pinged.\n\nCurrently only works when reply-pinged. Will add message pings later.\n";
    }

    record Key(long serverID, long userID) {
    }

    public record SaveData(List<Entry> entries) implements IEmptyFileNameResolver
    {
        public static SaveData fromMap(Map<Key, Boolean> map) {
            ArrayList<Entry> entryList = new ArrayList<Entry>();
            for (Map.Entry<Key, Boolean> e : map.entrySet()) {
                entryList.add(new Entry(e.getKey(), e.getValue()));
            }
            return new SaveData(entryList);
        }

        public Map<Key, Boolean> toMap() {
            HashMap<Key, Boolean> map = new HashMap<Key, Boolean>();
            for (Entry entry : this.entries) {
                map.put(entry.key(), entry.value());
            }
            return map;
        }

        public record Entry(Key key, Boolean value) {
        }
    }
}

