/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.util;

import java.util.Set;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.UserStore;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;

public final class ConstraintSecurityHandlerBuilder {
    private final HashLoginService hashLoginService = new HashLoginService("MyRealm");
    private final UserStore userStore = new UserStore();
    private final ConstraintSecurityHandler handler = new ConstraintSecurityHandler();

    public static ConstraintSecurityHandlerBuilder create() {
        return new ConstraintSecurityHandlerBuilder();
    }

    ConstraintSecurityHandlerBuilder() {
        this.handler.setLoginService((LoginService)this.hashLoginService);
        this.hashLoginService.setUserStore(this.userStore);
    }

    public ConstraintSecurityHandlerBuilder lock(Set<String> permittedRoles, String pathSpec) {
        Constraint constraint = new Constraint();
        constraint.setAuthenticate(true);
        constraint.setRoles((String[])permittedRoles.toArray(String[]::new));
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec(pathSpec);
        this.handler.addConstraintMapping(mapping);
        return this;
    }

    public ConstraintSecurityHandlerBuilder setFullValidate(boolean validate) {
        this.hashLoginService.setFullValidate(validate);
        return this;
    }

    public ConstraintSecurityHandlerBuilder addUser(String userName, String password, Set<String> providedRoles) {
        this.userStore.addUser(userName, Credential.getCredential((String)password), (String[])providedRoles.toArray(String[]::new));
        return this;
    }

    public ConstraintSecurityHandlerBuilder setAuthenticator(Authenticator authenticator) {
        this.handler.setAuthenticator(authenticator);
        return this;
    }

    public ConstraintSecurityHandler getConstraintSecurityHandler() {
        return this.handler;
    }
}

