/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.mangorage.mangobot.website.impl.ObjectMap;
import org.mangorage.mangobot.website.impl.StandardHttpServlet;

public class LoginServlet
extends StandardHttpServlet {
    public UserIdentity getUserIdentity(HttpServletRequest request) {
        Request baseRequest = Request.getBaseRequest((ServletRequest)request);
        return baseRequest != null ? baseRequest.getUserIdentity() : null;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserIdentity identity;
        ObjectMap map = (ObjectMap)this.getServletConfig().getServletContext().getAttribute("web_object");
        Authenticator authenticator = map.get("auth", Authenticator.class);
        Authentication authentication = null;
        try {
            authentication = authenticator.validateRequest((ServletRequest)req, (ServletResponse)resp, true);
        }
        catch (ServerAuthException e) {
            throw new RuntimeException(e);
        }
        if (authentication instanceof Authentication.User && (identity = ((Authentication.User)authentication).getUserIdentity()) != null) {
            req.setAttribute("org.eclipse.jetty.server.UserIdentity", (Object)identity);
            resp.sendRedirect("/account");
            return;
        }
        resp.setHeader("WWW-Authenticate", "Basic realm=\"My Secure Area\"");
        resp.setStatus(401);
        resp.getWriter().println("HTTP 401 - Unauthorized");
    }

    @Override
    public boolean hasEmbed() {
        return true;
    }
}

