/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.servlet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import htmlflow.HtmlFlow;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.mangorage.mangobot.website.WebServer;
import org.mangorage.mangobot.website.impl.StandardHttpServlet;
import org.mangorage.mangobot.website.servlet.file.TargetFile;
import org.mangorage.mangobot.website.servlet.file.UploadConfig;
import org.mangorage.mangobot.website.util.ResolveString;
import org.xmlet.htmlapifaster.A;
import org.xmlet.htmlapifaster.Body;
import org.xmlet.htmlapifaster.Button;
import org.xmlet.htmlapifaster.Div;
import org.xmlet.htmlapifaster.EnumHttpEquivType;
import org.xmlet.htmlapifaster.EnumRelType;
import org.xmlet.htmlapifaster.EnumTypeInputType;
import org.xmlet.htmlapifaster.H1;
import org.xmlet.htmlapifaster.H3;
import org.xmlet.htmlapifaster.H4;
import org.xmlet.htmlapifaster.Head;
import org.xmlet.htmlapifaster.Html;
import org.xmlet.htmlapifaster.Input;
import org.xmlet.htmlapifaster.Meta;
import org.xmlet.htmlapifaster.Title;

public class FileServlet
extends StandardHttpServlet {
    private static final ResolveString UPLOADS_DATA = WebServer.WEBPAGE_ROOT.resolve("uploads").resolve("data");
    private static final ResolveString UPLOADS_CONFIGS = WebServer.WEBPAGE_ROOT.resolve("uploads").resolve("cfg");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, String> EXTENSIONS = new HashMap<String, String>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id = request.getParameter("id");
        String target = request.getParameter("target");
        String download = request.getParameter("dl");
        String delete = request.getParameter("delete");
        String header = request.getParameter("h");
        if (header != null) {
            ((Head)((Head)((Head)((Head)HtmlFlow.doc((Appendable)response.getWriter()).html().head().meta().attrName("og:title").attrContent("MangoBot").__()).meta().attrName("og:description").attrContent("The Official MangoBot Discord Bot.").__()).meta().attrName("og:image").attrContent("https://mangobot.mangorage.org/file?id=%s&target=%s".formatted(id, target)).attrHttpEquiv(EnumHttpEquivType.CONTENT_TYPE).__()).meta().attrName("og:url").attrContent("https://mangobot.mangorage.org/file?id=%s&target=%s".formatted(id, target)).attrHttpEquiv(EnumHttpEquivType.CONTENT_TYPE).__()).meta().attrName("og:type").attrContent("website").__();
            return;
        }
        if (id == null || id.isBlank()) {
            response.sendError(400, "File ID is required.");
            return;
        }
        UploadConfig config = this.fetchConfig(id);
        if (config == null) {
            response.sendError(400, "Invalid File ID");
            return;
        }
        boolean isOwner = config.isAccount(request, response);
        if (!isOwner && delete != null) {
            ((Html)((Body)((H3)((Body)((H1)((Html)((Head)((Head)((Meta)((Meta)HtmlFlow.doc((Appendable)response.getWriter()).html().head().meta().addAttr("http-equiv", "refresh")).addAttr("content", "5;url=/file?id=" + id)).__()).link().attrRel(EnumRelType.STYLESHEET).attrHref(this.getStyles()).__()).__()).body().h1().text((Object)"Insufficient Permission")).__()).h3().text((Object)"Redirecting you back in 5 seconds...")).__()).__()).__();
            return;
        }
        if (isOwner && delete != null) {
            if (target != null) {
                TargetFile targetFile2 = config.targets().get(target);
                if (targetFile2 == null) {
                    ((Html)((Body)((H1)((Html)((Head)HtmlFlow.doc((Appendable)response.getWriter()).html().head().link().attrRel(EnumRelType.STYLESHEET).attrHref(this.getStyles()).__()).__()).body().h1().text((Object)"Invalid Target")).__()).__()).__();
                    return;
                }
                config.targets().remove(target);
                Path uploadCfgPath = Paths.get(UPLOADS_CONFIGS.value(), new String[0]);
                Path dataPath = Paths.get(UPLOADS_DATA.value(), new String[0]);
                targetFile2.delete(dataPath);
                if (!Files.exists(uploadCfgPath, new LinkOption[0])) {
                    Files.createDirectories(uploadCfgPath, new FileAttribute[0]);
                }
                Files.write(uploadCfgPath.resolve(id), GSON.toJson((Object)config).getBytes(), new OpenOption[0]);
            } else {
                Path uploadCfgPath = Paths.get(UPLOADS_CONFIGS.value(), new String[0]);
                Path dataPath = Paths.get(UPLOADS_DATA.value(), new String[0]);
                config.delete(uploadCfgPath, dataPath);
            }
            ((Html)((Body)((H3)((Body)((H1)((Html)((Head)((Head)((Meta)((Meta)HtmlFlow.doc((Appendable)response.getWriter()).html().head().meta().addAttr("http-equiv", "refresh")).addAttr("content", "5;url=/file?id=" + id)).__()).link().attrRel(EnumRelType.STYLESHEET).attrHref(this.getStyles()).__()).__()).body().h1().text((Object)"Deleted")).__()).h3().text((Object)"Redirecting you back in 5 seconds...")).__()).__()).__();
            return;
        }
        if (target == null) {
            Div view = (Div)((Div)((Button)((Button)((Button)((Div)((Input)((Div)((Div)((H1)((H1)((Div)((Html)((Head)((Head)((Title)HtmlFlow.doc((Appendable)response.getWriter()).html().head().title().text((Object)"File Management")).__()).link().attrRel(EnumRelType.STYLESHEET).attrHref(this.getStyles()).__()).__()).body().div().attrClass("container")).h1().attrClass("title")).text((Object)"File Management")).__()).div().attrClass("url-section")).input().attrType(EnumTypeInputType.TEXT).attrValue("https://mangobot.mangorage.org/file?id=" + id).attrReadonly(Boolean.valueOf(true)).attrId("copyInput")).__()).button().attrClass("copy-button")).attrOnclick("document.getElementById('copyInput').select(); document.execCommand('copy');")).text((Object)"Click to copy URL to clipboard")).__()).__();
            if (isOwner) {
                view = (Div)((Div)((A)((Div)view.div().attrClass("owner-actions")).a().attrHref("/file?id=" + id + "&delete=1").text((Object)"Delete File")).__()).__();
            }
            Div finalView = view;
            config.targets().forEach((k, targetFile) -> {
                ((A)((Div)((H4)((A)((Div)finalView.div().attrClass("target-section")).h4().a().attrHref("/file?id=" + id + "&target=" + targetFile.index()).text((Object)targetFile.name())).__()).__()).a().attrHref("/file?id=" + id + "&target=" + targetFile.index() + "&dl=1").text((Object)"Download")).__();
                if (isOwner) {
                    ((A)finalView.a().attrHref("/file?id=" + id + "&target=" + targetFile.index() + "&delete=1").text((Object)"Delete")).__();
                }
                finalView.__();
            });
            ((Body)view.__()).__();
            return;
        }
        if (download == null) {
            TargetFile targetFile3 = config.targets().get(target);
            if (targetFile3 != null) {
                this.handleFileRequest(targetFile3, false, response);
                return;
            }
            response.sendError(400, "Invalid Target");
            return;
        }
        TargetFile targetFile4 = config.targets().get(target);
        if (targetFile4 != null) {
            this.handleFileRequest(targetFile4, true, response);
            return;
        }
        response.sendError(400, "Invalid Target");
    }

    private UploadConfig fetchConfig(String id) {
        Path file = Paths.get(UPLOADS_CONFIGS.value(), new String[0]).resolve(id);
        if (Files.exists(file, new LinkOption[0])) {
            UploadConfig uploadConfig;
            FileReader reader = new FileReader(file.toFile());
            try {
                uploadConfig = (UploadConfig)GSON.fromJson((Reader)reader, UploadConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return null;
                }
            }
            reader.close();
            return uploadConfig;
        }
        return null;
    }

    private void handleFileRequest(TargetFile targetFile, boolean download, HttpServletResponse response) throws IOException {
        File file = new File(UPLOADS_DATA.value(), targetFile.path());
        if (file.exists() && file.isFile()) {
            String contentType = download ? "application/octet-stream" : EXTENSIONS.getOrDefault(targetFile.extension(), "text/plain");
            response.setContentType(contentType);
            response.setContentLengthLong(file.length());
            if (download) {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + targetFile.name() + "\"");
            }
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                ((InputStream)fileInputStream).transferTo((OutputStream)response.getOutputStream());
            }
        } else {
            response.sendError(404, "File not found.");
        }
    }

    @Override
    public boolean useDefaultStyles() {
        return false;
    }

    static {
        EXTENSIONS.put(".jpg", "image/jpeg");
        EXTENSIONS.put(".jpeg", "image/jpeg");
        EXTENSIONS.put(".png", "image/png");
        EXTENSIONS.put(".gif", "image/gif");
        EXTENSIONS.put(".bmp", "image/bmp");
        EXTENSIONS.put(".webp", "image/webp");
        EXTENSIONS.put(".ico", "image/x-icon");
        EXTENSIONS.put(".svg", "image/svg+xml");
        EXTENSIONS.put(".tif", "image/tiff");
        EXTENSIONS.put(".tiff", "image/tiff");
        EXTENSIONS.put(".pdf", "application/pdf");
        EXTENSIONS.put(".txt", "text/plain");
        EXTENSIONS.put(".csv", "text/csv");
        EXTENSIONS.put(".json", "application/json");
        EXTENSIONS.put(".xml", "application/xml");
        EXTENSIONS.put(".mp3", "audio/mpeg");
        EXTENSIONS.put(".wav", "audio/wav");
        EXTENSIONS.put(".ogg", "audio/ogg");
        EXTENSIONS.put(".flac", "audio/flac");
        EXTENSIONS.put(".aac", "audio/aac");
        EXTENSIONS.put(".mp4", "video/mp4");
        EXTENSIONS.put(".avi", "video/x-msvideo");
        EXTENSIONS.put(".mov", "video/quicktime");
        EXTENSIONS.put(".wmv", "video/x-ms-wmv");
        EXTENSIONS.put(".flv", "video/x-flv");
        EXTENSIONS.put(".webm", "video/webm");
        EXTENSIONS.put(".ttf", "font/ttf");
        EXTENSIONS.put(".otf", "font/otf");
        EXTENSIONS.put(".woff", "font/woff");
        EXTENSIONS.put(".woff2", "font/woff2");
    }
}

