/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.mangorage.mangobot.website.impl.ObjectMap;
import org.mangorage.mangobot.website.impl.StandardHttpServlet;

public class AccountServlet
extends StandardHttpServlet {
    public UserIdentity getUserIdentity(HttpServletRequest request) {
        Request baseRequest = Request.getBaseRequest((ServletRequest)request);
        return baseRequest != null ? baseRequest.getUserIdentity() : null;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ObjectMap map = (ObjectMap)this.getServletConfig().getServletContext().getAttribute("web_object");
        SecurityHandler service = map.get("login_service", SecurityHandler.class);
        UserIdentity identity = this.getUserIdentity(req);
        if (identity != null && service.getLoginService().validate(identity)) {
            resp.getWriter().write("Welcome %s!".formatted(identity.getUserPrincipal().getName()));
        } else {
            resp.getWriter().write("No Account Signed In");
        }
    }

    @Override
    public boolean hasEmbed() {
        return true;
    }
}

