/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.music.commands;

import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.unions.MessageChannelUnion;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import org.jetbrains.annotations.NotNull;
import org.mangorage.basicutils.LogHelper;
import org.mangorage.mangobot.core.BotPermissions;
import org.mangorage.mangobot.modules.music.MusicPlayer;
import org.mangorage.mangobot.modules.music.MusicUtil;
import org.mangorage.mangobotapi.core.commands.Arguments;
import org.mangorage.mangobotapi.core.commands.CommandResult;
import org.mangorage.mangobotapi.core.commands.IBasicCommand;
import org.mangorage.mangobotapi.core.registry.commands.AutoRegister;

@AutoRegister.BasicCommand
public class PlayCommand
implements IBasicCommand {
    @NotNull
    public CommandResult execute(Message message, Arguments arg) {
        CharSequence[] args = arg.getArgs();
        if (!message.isFromGuild()) {
            return CommandResult.GUILD_ONLY;
        }
        String URL2 = args[0];
        MessageChannelUnion channel = message.getChannel();
        Guild guild = message.getGuild();
        Member member = message.getMember();
        if (member == null) {
            return CommandResult.FAIL;
        }
        if (!BotPermissions.PLAYING.hasPermission(member)) {
            return CommandResult.NO_PERMISSION;
        }
        GuildVoiceState voiceState = member.getVoiceState();
        if (voiceState == null) {
            return CommandResult.FAIL;
        }
        MusicPlayer player = MusicPlayer.getInstance(guild.getId());
        if (voiceState.inAudioChannel()) {
            if (!URL2.isEmpty()) {
                if (!player.isPlaying()) {
                    try {
                        player.load(String.join((CharSequence)" ", args), e -> {
                            switch (e.getReason()) {
                                case SUCCESS: {
                                    MusicUtil.connectToAudioChannel(voiceState.getChannel().asVoiceChannel());
                                    player.add(e.getTrack());
                                    player.play();
                                    MessageEmbed embed = new EmbedBuilder().setTitle(e.getTrack().getInfo().title, e.getTrack().getInfo().uri).build();
                                    ((MessageCreateAction)channel.sendMessage((CharSequence)"Playing: ").addEmbeds(new MessageEmbed[]{embed})).queue();
                                    break;
                                }
                                case FAILED: {
                                    channel.sendMessage((CharSequence)"Failed").queue();
                                    break;
                                }
                                case NO_MATCHES: {
                                    channel.sendMessage((CharSequence)"No matches was found!").queue();
                                }
                            }
                        });
                    }
                    catch (Exception e2) {
                        LogHelper.error((String)e2.getMessage());
                    }
                } else {
                    channel.sendMessage((CharSequence)"Already playing!").queue();
                }
            } else if (player.isPlaying()) {
                player.resume();
                AudioTrack track = player.getPlaying();
                MessageEmbed embed = new EmbedBuilder().setTitle(track.getInfo().title, track.getInfo().uri).build();
                ((MessageCreateAction)channel.sendMessage((CharSequence)"Resumed playing: ").addEmbeds(new MessageEmbed[]{embed})).queue();
            } else if (!player.isQueueEmpty()) {
                MusicUtil.connectToAudioChannel(voiceState.getChannel().asVoiceChannel());
                player.play();
                AudioTrack track = player.getPlaying();
                MessageEmbed embed = new EmbedBuilder().setTitle(track.getInfo().title, track.getInfo().uri).build();
                ((MessageCreateAction)channel.sendMessage((CharSequence)"Started playing: ").addEmbeds(new MessageEmbed[]{embed})).queue();
            } else {
                channel.sendMessage((CharSequence)"Nothing is currently playing.").queue();
            }
        } else {
            channel.sendMessage((CharSequence)"Must be in a voice channel!").queue();
        }
        return CommandResult.PASS;
    }

    public String commandId() {
        return "play";
    }
}

