/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.servlet;

import htmlflow.HtmlFlow;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.User;
import org.mangorage.mangobot.modules.tricks.Trick;
import org.mangorage.mangobot.modules.tricks.TrickCommand;
import org.mangorage.mangobot.website.impl.ObjectMap;
import org.mangorage.mangobot.website.impl.StandardHttpServlet;
import org.xmlet.htmlapifaster.Body;
import org.xmlet.htmlapifaster.Button;
import org.xmlet.htmlapifaster.Div;
import org.xmlet.htmlapifaster.EnumMethodType;
import org.xmlet.htmlapifaster.EnumRelType;
import org.xmlet.htmlapifaster.EnumTypeButtonType;
import org.xmlet.htmlapifaster.EnumTypeInputType;
import org.xmlet.htmlapifaster.EnumWrapType;
import org.xmlet.htmlapifaster.Form;
import org.xmlet.htmlapifaster.H1;
import org.xmlet.htmlapifaster.H2;
import org.xmlet.htmlapifaster.H3;
import org.xmlet.htmlapifaster.Head;
import org.xmlet.htmlapifaster.Html;
import org.xmlet.htmlapifaster.Label;
import org.xmlet.htmlapifaster.Option;
import org.xmlet.htmlapifaster.P;
import org.xmlet.htmlapifaster.Select;
import org.xmlet.htmlapifaster.Textarea;
import org.xmlet.htmlapifaster.Title;

public class TricksServlet
extends StandardHttpServlet {
    public static String getUser(JDA jda, long id) {
        User user = jda.getUserById(id);
        return user != null ? user.getName() : "";
    }

    public static String getGuild(JDA jda, long id) {
        Guild guild = jda.getGuildById(id);
        return guild != null ? guild.getName() : "";
    }

    private static long getLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (Exception ignored) {
            return -1L;
        }
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ObjectMap map = (ObjectMap)this.getServletConfig().getServletContext().getAttribute("web_object");
        TrickCommand command = map.get("trickCommand", TrickCommand.class);
        JDA jda = map.get("jda", JDA.class);
        resp.setContentType("text/html");
        String guildId = req.getParameter("guildId");
        String trickId = req.getParameter("trickId");
        Div html = (Div)((Body)((Html)((Head)((Head)((Title)((Head)HtmlFlow.doc((Appendable)resp.getWriter()).html().head().meta().attrCharset("UTF-8").__()).title().text((Object)"Mangobot Tricks")).__()).link().attrRel(EnumRelType.STYLESHEET).attrHref(this.getStyles()).__()).__()).body().attrClass("page-body")).div().attrClass("container");
        if (guildId == null && trickId == null) {
            Select a = (Select)((Select)((Form)((Label)((Form)((Div)((H2)((H2)html.h2().attrClass("title")).text((Object)"Select Guild")).__()).form().attrMethod(EnumMethodType.GET).attrAction("/trick").attrClass("form-group")).label().attrFor("guildId").text((Object)"Choose a Guild:")).__()).select().attrName("guildId").attrId("guildId")).attrClass("select-input");
            for (Long guild : command.getGuilds()) {
                ((Option)a.option().attrValue(guild.toString()).text((Object)TricksServlet.getGuild(jda, guild))).__();
            }
            ((Form)((Button)((Button)((Form)a.__()).button().attrType(EnumTypeButtonType.SUBMIT).attrClass("btn btn-primary")).text((Object)"Enter!")).__()).__();
        } else if (guildId != null && trickId == null) {
            Select a = (Select)((Select)((Form)((Label)((Form)((Form)((Div)((H2)((H2)html.h2().attrClass("title")).text((Object)"Select Trick")).__()).form().attrMethod(EnumMethodType.GET).attrAction("/trick").attrClass("form-group")).input().attrType(EnumTypeInputType.HIDDEN).attrName("guildId").attrValue(guildId).__()).label().attrFor("trickId").text((Object)"Choose a Trick:")).__()).select().attrName("trickId").attrId("trickId")).attrClass("select-input");
            for (Trick trick : command.getTricksForGuild(TricksServlet.getLong(guildId))) {
                ((Option)a.option().attrValue(trick.getTrickID()).text((Object)trick.getTrickID())).__();
            }
            ((Form)((Button)((Button)((Form)a.__()).button().attrType(EnumTypeButtonType.SUBMIT).attrClass("btn btn-primary")).text((Object)"Enter!")).__()).__();
        } else if (guildId != null && trickId != null) {
            try {
                Trick trick = command.getTrick(trickId, Long.parseLong(guildId));
                if (trick != null) {
                    ((H2)((H2)html.h2().attrClass("trick-title")).text((Object)"Trick Details")).__();
                    ((Div)((P)((P)((Div)((P)((P)((Div)((P)((P)((Div)html.div().attrClass("trick-info")).p().attrClass("trick-id")).text((Object)("ID: " + trick.getTrickID()))).__()).p().attrClass("trick-type")).text((Object)("Type: " + String.valueOf((Object)trick.getType())))).__()).p().attrClass("trick-guild")).text((Object)("Guild: " + trick.getGuildID() + " " + TricksServlet.getGuild(jda, trick.getGuildID())))).__()).__();
                    switch (trick.getType()) {
                        case ALIAS: {
                            ((H3)((H3)html.h3().attrClass("section-title")).text((Object)"Alias Target")).__();
                            ((Div)((Div)html.div().attrClass("trick-alias")).text((Object)trick.getAliasTarget())).__();
                            break;
                        }
                        case NORMAL: {
                            ((H3)((H3)html.h3().attrClass("section-title")).text((Object)"Content")).__();
                            ((Div)((Textarea)((Div)html.div().attrClass("trick-content")).textarea().attrCols(Long.valueOf(50L)).attrRows(Long.valueOf(20L)).attrWrap(EnumWrapType.HARD).attrReadonly(Boolean.valueOf(true)).text((Object)trick.getContent())).__()).__();
                            break;
                        }
                        case SCRIPT: {
                            ((H3)((H3)html.h3().attrClass("section-title")).text((Object)"Script")).__();
                            ((Div)((Textarea)((Div)html.div().attrClass("trick-script")).textarea().attrCols(Long.valueOf(50L)).attrRows(Long.valueOf(20L)).attrWrap(EnumWrapType.HARD).attrReadonly(Boolean.valueOf(true)).text((Object)trick.getScript())).__()).__();
                        }
                    }
                    ((Div)((P)((P)((Div)((P)((P)((Div)((P)((P)((Div)((P)((P)((Div)((P)((P)((Div)((P)((P)((Div)((P)((P)((Div)html.div().attrClass("trick-meta")).p().attrClass("meta-item")).text((Object)("Trick Owner: " + trick.getOwnerID() + " " + TricksServlet.getUser(jda, trick.getOwnerID())))).__()).p().attrClass("meta-item")).text((Object)("Last Edited By: " + trick.getLastUserEdited() + " " + TricksServlet.getUser(jda, trick.getLastUserEdited())))).__()).p().attrClass("meta-item")).text((Object)("Created: " + String.valueOf(Date.from(Instant.ofEpochMilli(trick.getCreated())))))).__()).p().attrClass("meta-item")).text((Object)("Last Edited: " + String.valueOf(Date.from(Instant.ofEpochMilli(trick.getLastEdited())))))).__()).p().attrClass("meta-item")).text((Object)("Times Used: " + trick.getTimesUsed()))).__()).p().attrClass("meta-item")).text((Object)("Locked: " + trick.isLocked()))).__()).p().attrClass("meta-item")).text((Object)("Embeds Suppressed: " + trick.isSuppressed()))).__()).__();
                } else {
                    ((H1)((H1)html.h1().attrClass("error")).text((Object)("Invalid Trick " + trickId + " supplied for Guild " + guildId))).__();
                }
            }
            catch (Exception ignored) {
                ((H1)((H1)html.h1().attrClass("error")).text((Object)"An error occurred while processing your request.")).__();
            }
        }
        ((Html)((Body)html.__()).__()).__();
    }

    @Override
    public boolean useDefaultStyles() {
        return false;
    }
}

