/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.filters;

import htmlflow.HtmlFlow;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.server.Request;
import org.mangorage.basicutils.LogHelper;
import org.mangorage.mangobot.website.util.WebUtil;
import org.xmlet.htmlapifaster.EnumHttpEquivType;
import org.xmlet.htmlapifaster.Head;

@WebFilter(value={"/*"})
public class RequestInterceptorFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof Request) {
            Request main = (Request)request;
            String ip = main.getHeader("X-Forwarded-For");
            LogHelper.info((String)"Intercepted Request from %s for %s -> https://mangobot.mangorage.org%s".formatted(ip == null ? request.getRemoteAddr() : ip, main.getMethod(), main.getOriginalURI()));
        } else if (request instanceof HttpServletRequest) {
            HttpServletRequest http = (HttpServletRequest)request;
            String ip = http.getHeader("X-Forwarded-For");
            LogHelper.info((String)"Unknown Type (Class) From %s -> %s".formatted(ip == null ? http.getRemoteAddr() : ip, request.getClass()));
        } else {
            LogHelper.info((String)"Unknown Type (Class) From %s -> %s".formatted(request.getRemoteAddr(), request.getClass()));
        }
        if (response instanceof HttpServletResponse) {
            HttpServletResponse resp = (HttpServletResponse)response;
            if (request instanceof HttpServletRequest) {
                HttpServletRequest req = (HttpServletRequest)request;
                WebUtil.getOrCreateUserToken(req, resp);
                ((Head)((Head)((Head)((Head)HtmlFlow.doc((Appendable)resp.getWriter()).html().head().meta().attrName("og:title").attrContent("MangoBot").__()).meta().attrName("og:description").attrContent("The Official MangoBot Discord Bot.").__()).meta().attrName("og:image").attrContent("https://mangobot.mangorage.org/pink-sheep.png").attrHttpEquiv(EnumHttpEquivType.CONTENT_TYPE).__()).meta().attrName("og:url").attrContent("https://mangobot.mangorage.org/file?id=568d44d8-b6bc-4394-a860-915fac5c085d&target=0").attrHttpEquiv(EnumHttpEquivType.CONTENT_TYPE).__()).meta().attrName("og:type").attrContent("website").__();
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

