/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.filters;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.server.Request;
import org.mangorage.basicutils.LogHelper;
import org.mangorage.mangobot.website.util.WebUtil;

@WebFilter(value={"/*"})
public class RequestInterceptorFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof Request) {
            Request main = (Request)request;
            String ip = main.getHeader("X-Forwarded-For");
            LogHelper.info((String)"Intercepted Request from %s for %s -> https://mangobot.mangorage.org%s".formatted(ip == null ? request.getRemoteAddr() : ip, main.getMethod(), main.getOriginalURI()));
        } else if (request instanceof HttpServletRequest) {
            HttpServletRequest http = (HttpServletRequest)request;
            String ip = http.getHeader("X-Forwarded-For");
            LogHelper.info((String)"Unknown Type (Class) From %s -> %s".formatted(ip == null ? http.getRemoteAddr() : ip, request.getClass()));
        } else {
            LogHelper.info((String)"Unknown Type (Class) From %s -> %s".formatted(request.getRemoteAddr(), request.getClass()));
        }
        if (response instanceof HttpServletResponse) {
            HttpServletResponse resp = (HttpServletResponse)response;
            if (request instanceof HttpServletRequest) {
                HttpServletRequest req = (HttpServletRequest)request;
                WebUtil.getOrCreateUserToken(req, resp);
                resp.setHeader("Content-Security-Policy", "img-src 'self' https://mangobot.mangorage.org/file?id=8e79263e-1579-4e88-8233-62ee91c52156&target=0; frame-src 'self' https://mangobot.mangorage.org/file?id=8e79263e-1579-4e88-8233-62ee91c52156&target=0;");
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

