/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.MultipartConfigElement;
import java.net.URL;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;
import org.mangorage.basicutils.LogHelper;
import org.mangorage.mangobot.website.FolderPruner;
import org.mangorage.mangobot.website.filters.RequestInterceptorFilter;
import org.mangorage.mangobot.website.handlers.DefaultErrorHandler;
import org.mangorage.mangobot.website.impl.ObjectMap;
import org.mangorage.mangobot.website.servlet.AccountServlet;
import org.mangorage.mangobot.website.servlet.FileServlet;
import org.mangorage.mangobot.website.servlet.FileUploadServlet;
import org.mangorage.mangobot.website.servlet.InfoServlet;
import org.mangorage.mangobot.website.servlet.LoginServlet;
import org.mangorage.mangobot.website.servlet.TestAuthServlet;
import org.mangorage.mangobot.website.servlet.TricksServlet;
import org.mangorage.mangobot.website.util.ResolveString;
import org.mangorage.mangobot.website.util.ServletContextHandlerBuilder;

public final class WebServer {
    public static final ResolveString WEBPAGE_INTERNAL = new ResolveString("webpage-internal");
    public static final ResolveString WEBPAGE_ROOT = new ResolveString("webpage-root");
    public static final ResolveString WEBPAGE_PAGE = WEBPAGE_ROOT.resolve("webpage");

    public static void startWebServerSafely(ObjectMap objectMap) {
        new Thread(() -> {
            try {
                FolderPruner.init();
                WebServer.startWebServer(objectMap);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).start();
    }

    public static void main(String[] args) {
        WebServer.startWebServerSafely(new ObjectMap());
    }

    public static void startWebServer(ObjectMap objectMap) throws Exception {
        Server server = new Server();
        ServletContextHandlerBuilder builder = WebServer.configureBuilders(objectMap);
        ServletContextHandler contextHandler = builder.getServletContextHandler();
        ConstraintSecurityHandler securityHandler = builder.getConstraintSecurityHandler();
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)WebServer.configureInternalResourceHandler());
        handlers.addHandler((Handler)WebServer.configureExternalResourceHandler());
        handlers.addHandler((Handler)contextHandler);
        securityHandler.setHandler((Handler)handlers);
        server.setHandler((Handler)securityHandler);
        ServerConnector connector = WebServer.getServerConnector(server);
        server.addConnector((Connector)connector);
        objectMap.put("login_service", securityHandler);
        objectMap.put("auth", securityHandler.getAuthenticator());
        server.start();
        LogHelper.info((String)"Webserver Started");
        server.join();
    }

    @NotNull
    private static ResourceHandler configureInternalResourceHandler() {
        URL file = WebServer.class.getClassLoader().getResource(WEBPAGE_INTERNAL.value());
        if (file == null) {
            throw new RuntimeException("Unable to find resource directory");
        }
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setBaseResource(Resource.newResource((URL)file));
        return resourceHandler;
    }

    @NotNull
    private static ResourceHandler configureExternalResourceHandler() {
        ResourceHandler resourceHandler = new ResourceHandler();
        resourceHandler.setResourceBase(WEBPAGE_PAGE.value());
        return resourceHandler;
    }

    @NotNull
    private static ServletContextHandlerBuilder configureBuilders(ObjectMap objectMap) {
        ServletContextHandlerBuilder builder = ServletContextHandlerBuilder.create(new ServletContextHandler(1));
        builder.setContextPath("/").setResourceBase(WEBPAGE_PAGE.value()).dynamic(h -> h.setErrorHandler((ErrorHandler)new DefaultErrorHandler())).addServlet(DefaultServlet.class, "/*").addHttpServlet(InfoServlet.class, "/info").addHttpServlet(TricksServlet.class, "/trick").addHttpServlet(FileServlet.class, "/file").addHttpServlet(TestAuthServlet.class, "/testAuth").addHttpServlet(LoginServlet.class, "/login").addHttpServlet(AccountServlet.class, "/account").addHttpServlet(FileUploadServlet.class, "/upload", h -> h.getRegistration().setMultipartConfig(new MultipartConfigElement("/tmp/uploads"))).setAttribute("web_object", objectMap).addFilter(RequestInterceptorFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST)).configureLoginBuilder(security -> security.setFullValidate(true).setAuthenticator((Authenticator)new BasicAuthenticator()).addUser("admin", "pass", Set.of("admin")).lock(Set.of("admin"), "/testAuth"));
        return builder;
    }

    @NotNull
    private static ServerConnector getServerConnector(Server server) {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setTrustAll(true);
        sslContextFactory.setKeyStorePath(WEBPAGE_ROOT.resolveFully("keystore.jks"));
        sslContextFactory.setKeyStorePassword("mango12");
        sslContextFactory.setKeyManagerPassword("mango12");
        ServerConnector sslConnector = new ServerConnector(server, sslContextFactory);
        sslConnector.setPort(443);
        return sslConnector;
    }
}

