/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.util;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.util.EnumSet;
import java.util.function.Consumer;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.mangorage.mangobot.website.impl.StandardHttpServlet;
import org.mangorage.mangobot.website.util.ConstraintSecurityHandlerBuilder;

public final class ServletContextHandlerBuilder {
    private final ConstraintSecurityHandlerBuilder securityHandlerBuilder = ConstraintSecurityHandlerBuilder.create();
    private final ServletContextHandler handler;

    public static ServletContextHandlerBuilder create(ServletContextHandler handler) {
        return new ServletContextHandlerBuilder(handler);
    }

    ServletContextHandlerBuilder(ServletContextHandler handler) {
        this.handler = handler;
    }

    public ServletContextHandlerBuilder dynamic(Consumer<ServletContextHandler> consumer) {
        consumer.accept(this.handler);
        return this;
    }

    public ServletContextHandlerBuilder setContextPath(String contextPath) {
        this.handler.setContextPath(contextPath);
        return this;
    }

    public ServletContextHandlerBuilder setResourceBase(String resourceBase) {
        this.handler.setResourceBase(resourceBase);
        return this;
    }

    public ServletContextHandlerBuilder setAttribute(String id, Object value) {
        this.handler.setAttribute(id, value);
        return this;
    }

    public ServletContextHandlerBuilder addFilter(Class<? extends Filter> filterClass, String pathSpec, EnumSet<DispatcherType> dispatches) {
        this.handler.addFilter(filterClass, pathSpec, dispatches);
        return this;
    }

    public ServletContextHandlerBuilder addServlet(Class<? extends Servlet> servletClass, String pathSpec) {
        this.handler.addServlet(new ServletHolder(servletClass), pathSpec);
        return this;
    }

    public ServletContextHandlerBuilder addServlet(Class<? extends Servlet> servletClass, String pathSpec, Consumer<ServletHolder> consumer) {
        ServletHolder holder = new ServletHolder(servletClass);
        consumer.accept(holder);
        this.handler.addServlet(holder, pathSpec);
        return this;
    }

    public ServletContextHandlerBuilder addHttpServlet(Class<? extends StandardHttpServlet> servletClass, String pathSpec) {
        return this.addServlet(servletClass, pathSpec);
    }

    public ServletContextHandlerBuilder addHttpServlet(Class<? extends StandardHttpServlet> servletClass, String pathSpec, Consumer<ServletHolder> consumer) {
        return this.addServlet(servletClass, pathSpec, consumer);
    }

    public void configureLoginBuilder(Consumer<ConstraintSecurityHandlerBuilder> consumer) {
        consumer.accept(this.securityHandlerBuilder);
    }

    public ConstraintSecurityHandler getConstraintSecurityHandler() {
        return this.securityHandlerBuilder.getConstraintSecurityHandler();
    }

    public ServletContextHandler getServletContextHandler() {
        return this.handler;
    }
}

