/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.servlet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import htmlflow.HtmlFlow;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import org.mangorage.mangobot.website.WebServer;
import org.mangorage.mangobot.website.impl.StandardHttpServlet;
import org.mangorage.mangobot.website.servlet.file.TargetFile;
import org.mangorage.mangobot.website.servlet.file.UploadConfig;
import org.mangorage.mangobot.website.util.ResolveString;
import org.xmlet.htmlapifaster.A;
import org.xmlet.htmlapifaster.Body;
import org.xmlet.htmlapifaster.Button;
import org.xmlet.htmlapifaster.EnumTypeInputType;
import org.xmlet.htmlapifaster.H1;
import org.xmlet.htmlapifaster.H3;
import org.xmlet.htmlapifaster.H4;
import org.xmlet.htmlapifaster.Head;
import org.xmlet.htmlapifaster.Html;
import org.xmlet.htmlapifaster.Input;
import org.xmlet.htmlapifaster.Meta;

public class FileServlet
extends StandardHttpServlet {
    private static final ResolveString UPLOADS_DATA = WebServer.WEBPAGE_ROOT.resolve("uploads").resolve("data");
    private static final ResolveString UPLOADS_CONFIGS = WebServer.WEBPAGE_ROOT.resolve("uploads").resolve("cfg");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, String> EXTENSIONS = new HashMap<String, String>();

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id = request.getParameter("id");
        String target = request.getParameter("target");
        String download = request.getParameter("dl");
        String delete = request.getParameter("delete");
        if (id != null && !id.isBlank()) {
            UploadConfig config = this.fetchConfig(id);
            if (config == null) {
                response.sendError(400, "Invalid File ID");
                return;
            }
            boolean isOwner = config.isAccount(request, response);
            if (!isOwner && delete != null) {
                ((H3)((Body)((H1)((Html)((Head)((Meta)((Meta)HtmlFlow.doc((Appendable)response.getWriter()).html().head().meta().addAttr("http-equiv", "refresh")).addAttr("content", "5;url=/file?id=%s".formatted(id))).__()).__()).body().h1().text((Object)"Cant delete, insufficient permission...")).__()).h3().text((Object)"Redirecting you back in 5 seconds...")).__();
                return;
            }
            if (isOwner && delete != null) {
                if (target != null) {
                    TargetFile targetFile2 = config.targets().get(target);
                    if (targetFile2 == null) {
                        ((Body)((H1)HtmlFlow.doc((Appendable)response.getWriter()).html().body().h1().text((Object)"Invalid Target")).__()).__();
                        return;
                    }
                    config.targets().remove(target);
                    Path uploadCfgPath = Paths.get(UPLOADS_CONFIGS.value(), new String[0]);
                    Path dataPath = Paths.get(UPLOADS_DATA.value(), new String[0]);
                    targetFile2.delete(dataPath);
                    if (!Files.exists(uploadCfgPath, new LinkOption[0])) {
                        Files.createDirectories(uploadCfgPath, new FileAttribute[0]);
                    }
                    Files.write(uploadCfgPath.resolve(id), GSON.toJson((Object)config).getBytes(), new OpenOption[0]);
                } else {
                    Path uploadCfgPath = Paths.get(UPLOADS_CONFIGS.value(), new String[0]);
                    Path dataPath = Paths.get(UPLOADS_DATA.value(), new String[0]);
                    config.delete(uploadCfgPath, dataPath);
                }
                ((H3)((Body)((H1)((Html)((Head)((Meta)((Meta)HtmlFlow.doc((Appendable)response.getWriter()).html().head().meta().addAttr("http-equiv", "refresh")).addAttr("content", "5;url=/file?id=%s".formatted(id))).__()).__()).body().h1().text((Object)"Deleted")).__()).h3().text((Object)"Redirecting you back in 5 seconds...")).__();
                return;
            }
            if (target == null) {
                Body flow = (Body)((Button)((Button)((Body)((Input)HtmlFlow.doc((Appendable)response.getWriter()).html().body().input().attrType(EnumTypeInputType.TEXT).attrValue("https://mangobot.mangorage.org/file?id=" + id).attrReadonly(Boolean.valueOf(true)).attrId("copyInput")).__()).button().attrOnclick("document.getElementById('copyInput').select(); document.execCommand('copy');")).text((Object)"Click to copy to clipboard to share!")).__();
                if (isOwner) {
                    ((A)flow.a().attrHref("/file?id=%s&delete=1".formatted(id)).text((Object)"Delete")).__();
                }
                config.targets().forEach((k, targetFile) -> {
                    if (isOwner) {
                        ((H4)((A)((H4)((A)flow.h4().a().attrHref("/file?id=%s&target=%s".formatted(id, targetFile.index())).text((Object)targetFile.name())).__()).a().attrHref("/file?id=%s&target=%s&dl=1".formatted(id, targetFile.index())).text((Object)"Download")).__()).a().attrHref("/file?id=%s&target=%s&delete=1".formatted(id, targetFile.index())).text((Object)"Delete");
                    } else {
                        ((H4)((A)flow.h4().a().attrHref("/file?id=%s&target=%s".formatted(id, targetFile.index())).text((Object)targetFile.name())).__()).a().attrHref("/file?id=%s&target=%s&dl=1".formatted(id, targetFile)).text((Object)"Download");
                    }
                });
                return;
            }
            if (download == null) {
                TargetFile targetFile3 = config.targets().get(target);
                if (targetFile3 != null) {
                    this.handleFileRequest(targetFile3, false, response);
                    return;
                }
                response.sendError(400, "Invalid Target");
                return;
            }
            TargetFile targetFile4 = config.targets().get(target);
            if (targetFile4 != null) {
                this.handleFileRequest(targetFile4, true, response);
                return;
            }
            response.sendError(400, "Invalid Target");
            return;
        }
        response.sendError(400, "File ID is required.");
    }

    private UploadConfig fetchConfig(String id) {
        Path file = Paths.get(UPLOADS_CONFIGS.value(), new String[0]).resolve(id);
        if (Files.exists(file, new LinkOption[0])) {
            UploadConfig uploadConfig;
            FileReader reader = new FileReader(file.toFile());
            try {
                uploadConfig = (UploadConfig)GSON.fromJson((Reader)reader, UploadConfig.class);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return null;
                }
            }
            reader.close();
            return uploadConfig;
        }
        return null;
    }

    private void handleFileRequest(TargetFile targetFile, boolean download, HttpServletResponse response) throws IOException {
        File file = new File(UPLOADS_DATA.value(), targetFile.path());
        if (file.exists() && file.isFile()) {
            String contentType = download ? "application/octet-stream" : EXTENSIONS.getOrDefault(targetFile.extension(), "text/plain");
            response.setContentType(contentType);
            response.setContentLengthLong(file.length());
            if (download) {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + targetFile.name() + "\"");
            }
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                ((InputStream)fileInputStream).transferTo((OutputStream)response.getOutputStream());
            }
        } else {
            response.sendError(404, "File not found.");
        }
    }

    static {
        EXTENSIONS.put(".jpg", "image/jpeg");
        EXTENSIONS.put(".jpeg", "image/jpeg");
        EXTENSIONS.put(".png", "image/png");
        EXTENSIONS.put(".gif", "image/gif");
        EXTENSIONS.put(".bmp", "image/bmp");
        EXTENSIONS.put(".webp", "image/webp");
        EXTENSIONS.put(".ico", "image/x-icon");
        EXTENSIONS.put(".svg", "image/svg+xml");
        EXTENSIONS.put(".tif", "image/tiff");
        EXTENSIONS.put(".tiff", "image/tiff");
        EXTENSIONS.put(".pdf", "application/pdf");
        EXTENSIONS.put(".txt", "text/plain");
        EXTENSIONS.put(".csv", "text/csv");
        EXTENSIONS.put(".json", "application/json");
        EXTENSIONS.put(".xml", "application/xml");
        EXTENSIONS.put(".mp3", "audio/mpeg");
        EXTENSIONS.put(".wav", "audio/wav");
        EXTENSIONS.put(".ogg", "audio/ogg");
        EXTENSIONS.put(".flac", "audio/flac");
        EXTENSIONS.put(".aac", "audio/aac");
        EXTENSIONS.put(".mp4", "video/mp4");
        EXTENSIONS.put(".avi", "video/x-msvideo");
        EXTENSIONS.put(".mov", "video/quicktime");
        EXTENSIONS.put(".wmv", "video/x-ms-wmv");
        EXTENSIONS.put(".flv", "video/x-flv");
        EXTENSIONS.put(".webm", "video/webm");
        EXTENSIONS.put(".ttf", "font/ttf");
        EXTENSIONS.put(".otf", "font/otf");
        EXTENSIONS.put(".woff", "font/woff");
        EXTENSIONS.put(".woff2", "font/woff2");
    }
}

