/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.basic.commands;

import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import org.jetbrains.annotations.NotNull;
import org.mangorage.mangobot.core.BotPermissions;
import org.mangorage.mangobotapi.core.commands.Arguments;
import org.mangorage.mangobotapi.core.commands.CommandPrefix;
import org.mangorage.mangobotapi.core.commands.CommandResult;
import org.mangorage.mangobotapi.core.commands.IBasicCommand;
import org.mangorage.mangobotapi.core.plugin.api.CorePlugin;

public class PrefixCommand
implements IBasicCommand {
    private final CorePlugin corePlugin;

    public PrefixCommand(CorePlugin corePlugin) {
        this.corePlugin = corePlugin;
    }

    @NotNull
    public CommandResult execute(Message message, Arguments args) {
        String prefix = args.getOrDefault(0, "");
        Member member = message.getMember();
        Guild guild = message.getGuild();
        if (member == null) {
            return CommandResult.GUILD_ONLY;
        }
        if (!BotPermissions.PREFIX_ADMIN.hasPermission(member)) {
            return CommandResult.of((String)"You dont have permission to use this command! Lacking Permission Node '%s'".formatted(BotPermissions.PREFIX_ADMIN.getId()));
        }
        if (prefix.equals(CommandPrefix.getPrefix((String)guild.getId()))) {
            this.corePlugin.getMessageSettings().apply(message.reply((CharSequence)"Already have command prefix set to '%s'".formatted(prefix))).queue();
            return CommandResult.PASS;
        }
        if (!prefix.isEmpty()) {
            CommandPrefix.configure((String)guild.getId(), (String)prefix);
            this.corePlugin.getMessageSettings().apply(message.reply((CharSequence)"Changed command prefix to '%s'".formatted(prefix))).queue();
            return CommandResult.PASS;
        }
        return CommandResult.FAIL;
    }

    public String commandId() {
        return "setPrefix";
    }
}

