/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website;

import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.mangorage.basicutils.LogHelper;

public final class FolderPruner {
    private static final String FOLDER_PATH = "webpage-root/uploads";
    private static final double MAX_SIZE_GB = 0.2;
    private static final long FILE_AGE_LIMIT_HOURS = 12L;
    private static final long PRUNE_INTERVAL_MINUTES = 30L;

    public static void init() {
    }

    private static void pruneFolder() {
        File folder = new File(FOLDER_PATH);
        if (!folder.exists() || !folder.isDirectory()) {
            LogHelper.error((String)"Invalid folder path.");
            return;
        }
        long maxSizeBytes = 0L;
        long currentSizeBytes = FolderPruner.calculateFolderSize(folder);
        if (currentSizeBytes > maxSizeBytes) {
            LogHelper.info((String)"Folder exceeds size limit. Starting pruning process...");
            List<File> filesToDelete = Arrays.stream(folder.listFiles()).filter(file -> file.lastModified() < System.currentTimeMillis() - 43200000L).sorted(Comparator.comparingLong(File::lastModified)).toList();
            for (File file2 : filesToDelete) {
                if (FolderPruner.calculateFolderSize(folder) <= maxSizeBytes) continue;
                LogHelper.info((String)("Deleting file: " + file2.getName()));
                file2.delete();
            }
        } else {
            LogHelper.info((String)"Folder size is within limit. No pruning needed.");
        }
    }

    private static long calculateFolderSize(File folder) {
        return Arrays.stream(folder.listFiles()).mapToLong(file -> file.isFile() ? file.length() : 0L).sum();
    }
}

