/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import java.net.URI;
import java.net.URL;
import java.util.EnumSet;
import java.util.function.Consumer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;
import org.mangorage.basicutils.LogHelper;
import org.mangorage.mangobot.website.FolderPruner;
import org.mangorage.mangobot.website.RequestInterceptorFilter;
import org.mangorage.mangobot.website.impl.ObjectMap;
import org.mangorage.mangobot.website.servlet.FileServlet;
import org.mangorage.mangobot.website.servlet.FileUploadServlet;
import org.mangorage.mangobot.website.servlet.InfoServlet;
import org.mangorage.mangobot.website.servlet.TricksServlet;

public final class WebServer {
    private static ServletHolder of(Class<? extends Servlet> tClass) {
        return new ServletHolder(tClass);
    }

    private static ServletHolder of(Class<? extends Servlet> tClass, Consumer<ServletHolder> holderConsumer) {
        ServletHolder holder = WebServer.of(tClass);
        holderConsumer.accept(holder);
        return holder;
    }

    public static void startWebServerSafely(ObjectMap objectMap) {
        new Thread(() -> {
            try {
                FolderPruner.init();
                WebServer.startWebServer(objectMap);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).start();
    }

    public static void main(String[] args) {
        WebServer.startWebServerSafely(new ObjectMap());
    }

    public static void startWebServer(ObjectMap objectMap) throws Exception {
        Server server = new Server();
        ResourceHandler fileResourceHandler = new ResourceHandler();
        fileResourceHandler.setResourceBase("webpage-root/webpage");
        ClassLoader cl = WebServer.class.getClassLoader();
        URL f = cl.getResource("webpage-data/");
        if (f == null) {
            throw new RuntimeException("Unable to find resource directory");
        }
        URI webRootUri = f.toURI();
        ResourceHandler jarResourceHandler = new ResourceHandler();
        jarResourceHandler.setBaseResource(Resource.newResource((URI)webRootUri));
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.setResourceBase("webpage-root/webpage");
        context.addServlet(DefaultServlet.class, "/*");
        context.addServlet(WebServer.of(InfoServlet.class), "/info");
        context.addServlet(WebServer.of(TricksServlet.class), "/trick");
        context.addServlet(WebServer.of(FileUploadServlet.class, h -> h.getRegistration().setMultipartConfig(new MultipartConfigElement("/tmp/uploads"))), "/upload");
        context.addServlet(WebServer.of(FileServlet.class), "/file");
        context.setAttribute("map", (Object)objectMap);
        context.addFilter(RequestInterceptorFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        ServerConnector connector = WebServer.getServerConnector(server);
        server.addConnector((Connector)connector);
        HandlerCollection handlers = new HandlerCollection();
        handlers.addHandler((Handler)jarResourceHandler);
        handlers.addHandler((Handler)fileResourceHandler);
        handlers.addHandler((Handler)context);
        server.setHandler((Handler)handlers);
        server.start();
        LogHelper.info((String)"Webserver Started");
        server.join();
    }

    @NotNull
    private static ServerConnector getServerConnector(Server server) {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setTrustAll(true);
        sslContextFactory.setKeyStorePath("webpage-root/keystore.jks");
        sslContextFactory.setKeyStorePassword("mango12");
        sslContextFactory.setKeyManagerPassword("mango12");
        ServerConnector sslConnector = new ServerConnector(server, sslContextFactory);
        sslConnector.setPort(443);
        return sslConnector;
    }
}

