/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.UUID;

public final class WebUtil {
    private static final String TOKEN_NAME = "user_token";

    public static String getOrCreateUserToken(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!TOKEN_NAME.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return WebUtil.setVisitorIdCookie(response, String.valueOf(UUID.randomUUID()));
    }

    public static String setVisitorIdCookie(HttpServletResponse response, String visitorId) {
        Cookie cookie = new Cookie(TOKEN_NAME, visitorId);
        cookie.setMaxAge(31536000);
        cookie.setPath("/");
        response.addCookie(cookie);
        return visitorId;
    }
}

