/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.servlet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import htmlflow.HtmlFlow;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.UUID;
import org.mangorage.mangobot.website.impl.AbstractServlet;
import org.mangorage.mangobot.website.servlet.file.TargetFile;
import org.mangorage.mangobot.website.servlet.file.UploadConfig;
import org.xmlet.htmlapifaster.Body;
import org.xmlet.htmlapifaster.Div;
import org.xmlet.htmlapifaster.EnumEnctypeType;
import org.xmlet.htmlapifaster.EnumMethodType;
import org.xmlet.htmlapifaster.EnumRelType;
import org.xmlet.htmlapifaster.EnumTypeInputType;
import org.xmlet.htmlapifaster.Form;
import org.xmlet.htmlapifaster.H1;
import org.xmlet.htmlapifaster.Head;
import org.xmlet.htmlapifaster.Html;
import org.xmlet.htmlapifaster.Input;
import org.xmlet.htmlapifaster.P;
import org.xmlet.htmlapifaster.Title;

@MultipartConfig
public class FileUploadServlet
extends AbstractServlet {
    private static final String UPLOADS_DATA = "webpage-root/uploads/data";
    private static final String UPLOADS_CONFIGS = "webpage-root/uploads/cfg/";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpResp = (HttpServletResponse)res;
        if ("GET".equals(httpReq.getMethod())) {
            ((Body)((Body)((Form)((Form)((Form)((Div)((Input)((Div)((P)((Div)((Body)((H1)((Html)((Head)((Head)((Title)HtmlFlow.doc((Appendable)httpResp.getWriter()).html().head().title().text((Object)"File Upload Page")).__()).link().attrRel(EnumRelType.STYLESHEET).attrHref("/css/dragDropUpload.css").__()).__()).body().h1().text((Object)"Upload a File")).__()).form().attrMethod(EnumMethodType.POST).attrAction("/upload").attrEnctype(EnumEnctypeType.MULTIPART_FORM_DATA).div().attrId("drop-area")).p().text((Object)"Drag and drop a file here or click to select")).__()).input().attrType(EnumTypeInputType.FILE).attrId("file-input")).attrName("file").__()).__()).br().__()).input().attrType(EnumTypeInputType.SUBMIT).attrValue("Upload").__()).__()).script().attrSrc("/js/dragDropUpload.js").__()).__();
        } else if ("POST".equals(httpReq.getMethod())) {
            String UPLOAD_ID = String.valueOf(UUID.randomUUID());
            HashMap<String, TargetFile> targets = new HashMap<String, TargetFile>();
            Integer index = 0;
            for (Part filePart : httpReq.getParts()) {
                String fileId = String.valueOf(UUID.randomUUID());
                String fileName = Paths.get(filePart.getSubmittedFileName(), new String[0]).getFileName().toString();
                String fileExtension = fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".")) : "";
                targets.put(index.toString(), new TargetFile(fileName, fileId, fileExtension));
                Integer n = index;
                index = index + 1;
                Path filePath = Paths.get(UPLOADS_DATA, new String[0]);
                if (!Files.exists(filePath, new LinkOption[0])) {
                    Files.createDirectories(filePath, new FileAttribute[0]);
                }
                InputStream input = filePart.getInputStream();
                try {
                    Files.copy(input, filePath.resolve(fileId), StandardCopyOption.REPLACE_EXISTING);
                }
                finally {
                    if (input == null) continue;
                    input.close();
                }
            }
            Path uploadCfgPath = Paths.get(UPLOADS_CONFIGS, new String[0]);
            if (!Files.exists(uploadCfgPath, new LinkOption[0])) {
                Files.createDirectories(uploadCfgPath, new FileAttribute[0]);
            }
            Files.write(uploadCfgPath.resolve(UPLOAD_ID), GSON.toJson((Object)new UploadConfig(targets)).getBytes(), new OpenOption[0]);
            httpResp.sendRedirect("/file?id=" + UPLOAD_ID);
        }
    }
}

