/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.servlet;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import htmlflow.HtmlFlow;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.mangorage.mangobot.website.servlet.file.TargetFile;
import org.mangorage.mangobot.website.servlet.file.UploadConfig;
import org.xmlet.htmlapifaster.A;
import org.xmlet.htmlapifaster.Body;
import org.xmlet.htmlapifaster.Button;
import org.xmlet.htmlapifaster.EnumTypeInputType;
import org.xmlet.htmlapifaster.H4;
import org.xmlet.htmlapifaster.Input;

public class FileServlet
extends HttpServlet {
    private static final String UPLOADS_DATA = "webpage-root/uploads/data/";
    private static final String UPLOADS_CONFIGS = "webpage-root/uploads/cfg/";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, String> EXTENSIONS = new HashMap<String, String>();

    /*
     * Enabled aggressive block sorting
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String id = request.getParameter("id");
        String target = request.getParameter("target");
        String download = request.getParameter("dl");
        if (id != null && !id.isBlank()) {
            UploadConfig config = this.fetchConfig(id);
            if (config == null) {
                response.sendError(400, "Invalid File ID");
                return;
            }
            if (target == null) {
                Body flow = (Body)((Button)((Button)((Body)((Input)HtmlFlow.doc((Appendable)response.getWriter()).html().body().input().attrType(EnumTypeInputType.TEXT).attrValue("https://mangobot.mangorage.org/file?id=" + id).attrReadonly(Boolean.valueOf(true)).attrId("copyInput")).__()).button().attrOnclick("document.getElementById('copyInput').select(); document.execCommand('copy');")).text((Object)"Click to copy to clipboard to share!")).__();
                config.targets().forEach((k, targetFile) -> ((A)((H4)((A)flow.h4().a().attrHref("/file?id=%s&target=%s".formatted(id, k)).text((Object)targetFile.name())).__()).a().attrHref("/file?id=%s&target=%s&dl=1".formatted(id, k)).text((Object)"Download")).__());
                return;
            }
            if (download == null) {
                TargetFile targetFile2 = config.targets().get(target);
                if (targetFile2 != null) {
                    this.handleFileRequest(targetFile2, false, response);
                    return;
                }
                response.sendError(400, "Invalid Target");
                return;
            }
            TargetFile targetFile3 = config.targets().get(target);
            if (targetFile3 != null) {
                this.handleFileRequest(targetFile3, true, response);
                return;
            }
            response.sendError(400, "Invalid Target");
            return;
        }
        response.sendError(400, "File ID is required.");
    }

    private UploadConfig fetchConfig(String id) {
        Path file = Paths.get(UPLOADS_CONFIGS, new String[0]).resolve(id);
        if (Files.exists(file, new LinkOption[0])) {
            try {
                return (UploadConfig)GSON.fromJson((Reader)new FileReader(file.toFile()), UploadConfig.class);
            }
            catch (FileNotFoundException ignored) {
                return null;
            }
        }
        return null;
    }

    private void handleFileRequest(TargetFile targetFile, boolean download, HttpServletResponse response) throws IOException {
        File file = new File(UPLOADS_DATA, targetFile.path());
        if (file.exists() && file.isFile()) {
            String contentType = download ? "application/octet-stream" : EXTENSIONS.getOrDefault(targetFile.extension(), "text/plain");
            response.setContentType(contentType);
            response.setContentLengthLong(file.length());
            if (download) {
                response.setHeader("Content-Disposition", "attachment; filename=\"" + targetFile.name() + "\"");
            }
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                ((InputStream)fileInputStream).transferTo((OutputStream)response.getOutputStream());
            }
        } else {
            response.sendError(404, "File not found.");
        }
    }

    static {
        EXTENSIONS.put(".jpg", "image/jpeg");
        EXTENSIONS.put(".jpeg", "image/jpeg");
        EXTENSIONS.put(".png", "image/png");
        EXTENSIONS.put(".gif", "image/gif");
        EXTENSIONS.put(".bmp", "image/bmp");
        EXTENSIONS.put(".webp", "image/webp");
        EXTENSIONS.put(".ico", "image/x-icon");
        EXTENSIONS.put(".svg", "image/svg+xml");
        EXTENSIONS.put(".tif", "image/tiff");
        EXTENSIONS.put(".tiff", "image/tiff");
        EXTENSIONS.put(".pdf", "application/pdf");
        EXTENSIONS.put(".txt", "text/plain");
        EXTENSIONS.put(".csv", "text/csv");
        EXTENSIONS.put(".json", "application/json");
        EXTENSIONS.put(".xml", "application/xml");
        EXTENSIONS.put(".mp3", "audio/mpeg");
        EXTENSIONS.put(".wav", "audio/wav");
        EXTENSIONS.put(".ogg", "audio/ogg");
        EXTENSIONS.put(".flac", "audio/flac");
        EXTENSIONS.put(".aac", "audio/aac");
        EXTENSIONS.put(".mp4", "video/mp4");
        EXTENSIONS.put(".avi", "video/x-msvideo");
        EXTENSIONS.put(".mov", "video/quicktime");
        EXTENSIONS.put(".wmv", "video/x-ms-wmv");
        EXTENSIONS.put(".flv", "video/x-flv");
        EXTENSIONS.put(".webm", "video/webm");
        EXTENSIONS.put(".ttf", "font/ttf");
        EXTENSIONS.put(".otf", "font/otf");
        EXTENSIONS.put(".woff", "font/woff");
        EXTENSIONS.put(".woff2", "font/woff2");
    }
}

