/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Scanner;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.AnnotatedEventManager;
import net.dv8tion.jda.api.hooks.IEventManager;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import org.mangorage.basicutils.LogHelper;
import org.mangorage.basicutils.config.Config;
import org.mangorage.basicutils.config.ConfigSetting;
import org.mangorage.basicutils.config.ISetting;
import org.mangorage.basicutils.config.Transformer;
import org.mangorage.basicutils.config.Transformers;
import org.mangorage.eventbus.interfaces.IEvent;
import org.mangorage.eventbus.interfaces.IEventBus;
import org.mangorage.eventbus.interfaces.IEventType;
import org.mangorage.jdautils.command.Command;
import org.mangorage.mangobot.AutoUpdate;
import org.mangorage.mangobot.config.GuildConfig;
import org.mangorage.mangobot.core.BotEventListener;
import org.mangorage.mangobot.core.BotPermissions;
import org.mangorage.mangobot.core.Listeners;
import org.mangorage.mangobot.modules.actions.TrashButtonAction;
import org.mangorage.mangobot.modules.basic.commands.AntiPingCommand;
import org.mangorage.mangobot.modules.basic.commands.GetEmbedsCommand;
import org.mangorage.mangobot.modules.basic.commands.HelpCommand;
import org.mangorage.mangobot.modules.basic.commands.InfoCommand;
import org.mangorage.mangobot.modules.basic.commands.JoinCommand;
import org.mangorage.mangobot.modules.basic.commands.LeaveCommand;
import org.mangorage.mangobot.modules.basic.commands.PermissionCommand;
import org.mangorage.mangobot.modules.basic.commands.PingCommand;
import org.mangorage.mangobot.modules.basic.commands.PluginsCommand;
import org.mangorage.mangobot.modules.basic.commands.PrefixCommand;
import org.mangorage.mangobot.modules.basic.commands.VersionCommand;
import org.mangorage.mangobot.modules.developer.EchoCommand;
import org.mangorage.mangobot.modules.developer.KickBotCommand;
import org.mangorage.mangobot.modules.developer.RestartCommand;
import org.mangorage.mangobot.modules.developer.RunCode;
import org.mangorage.mangobot.modules.developer.SpeakCommand;
import org.mangorage.mangobot.modules.developer.TerminateCommand;
import org.mangorage.mangobot.modules.developer.WhitelistBotCommand;
import org.mangorage.mangobot.modules.github.GHIssueStatus;
import org.mangorage.mangobot.modules.github.GHPRStatus;
import org.mangorage.mangobot.modules.github.IssueScanCommand;
import org.mangorage.mangobot.modules.github.PRScanCommand;
import org.mangorage.mangobot.modules.github.PasteRequestModule;
import org.mangorage.mangobot.modules.music.commands.PauseCommand;
import org.mangorage.mangobot.modules.music.commands.PlayCommand;
import org.mangorage.mangobot.modules.music.commands.PlayingCommand;
import org.mangorage.mangobot.modules.music.commands.QueueCommand;
import org.mangorage.mangobot.modules.music.commands.StopCommand;
import org.mangorage.mangobot.modules.music.commands.VolumeCommand;
import org.mangorage.mangobot.modules.tricks.TrickCommand;
import org.mangorage.mangobot.website.WebServer;
import org.mangorage.mangobot.website.impl.ObjectMap;
import org.mangorage.mangobotapi.core.commands.IBasicCommand;
import org.mangorage.mangobotapi.core.events.DiscordEvent;
import org.mangorage.mangobotapi.core.events.LoadEvent;
import org.mangorage.mangobotapi.core.events.SaveEvent;
import org.mangorage.mangobotapi.core.events.ShutdownEvent;
import org.mangorage.mangobotapi.core.events.StartupEvent;
import org.mangorage.mangobotapi.core.modules.action.ButtonAction;
import org.mangorage.mangobotapi.core.modules.action.ButtonActionRegistry;
import org.mangorage.mangobotapi.core.plugin.api.JDAPlugin;
import org.mangorage.mangobotapi.core.plugin.api.PluginMessageEvent;
import org.mangorage.mangobotapi.core.plugin.impl.Plugin;
import org.mangorage.mangobotapi.core.registry.commands.CommandRegistry;
import org.mangorage.mangobotapi.core.registry.permissions.PermissionRegistry;

@Plugin(id="mangobot")
public class MangoBotPlugin
extends JDAPlugin {
    public static final String ID = "mangobot";
    private static final EnumSet<GatewayIntent> intents = EnumSet.of(GatewayIntent.GUILD_MESSAGES, new GatewayIntent[]{GatewayIntent.DIRECT_MESSAGES, GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MESSAGE_REACTIONS, GatewayIntent.DIRECT_MESSAGE_REACTIONS, GatewayIntent.GUILD_VOICE_STATES, GatewayIntent.GUILD_EMOJIS_AND_STICKERS, GatewayIntent.SCHEDULED_EVENTS, GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_PRESENCES});
    private static final EnumSet<CacheFlag> cacheFlags = EnumSet.of(CacheFlag.EMOJI, new CacheFlag[]{CacheFlag.ROLE_TAGS, CacheFlag.VOICE_STATE, CacheFlag.ACTIVITY, CacheFlag.CLIENT_STATUS, CacheFlag.MEMBER_OVERRIDES, CacheFlag.STICKER, CacheFlag.SCHEDULED_EVENTS, CacheFlag.FORUM_TAGS});
    public static final Config CONFIG = new Config(Path.of("plugins/%s/.env".formatted("mangobot"), new String[0]));
    public static final ISetting<String> BOT_TOKEN = ConfigSetting.create((Config)CONFIG, (String)"BOT_TOKEN", (String)"empty");
    public static final ISetting<String> GITHUB_TOKEN = ConfigSetting.create((Config)CONFIG, (String)"PASTE_TOKEN", (String)"empty");
    public static final ISetting<String> GITHUB_USERNAME = ConfigSetting.create((Config)CONFIG, (String)"GITHUB_USERNAME", (String)"RealMangoRage");
    public static final ISetting<Boolean> AUTO_UPDATE = ConfigSetting.create((Config)CONFIG, (String)"AUTO_UPDATE", (Transformer)Transformers.BOOLEAN, (Object)false);
    public static final ButtonActionRegistry ACTION_REGISTRY = new ButtonActionRegistry();
    private final ObjectMap objectMap = new ObjectMap();
    private static final List<Long> AUTO_PUBLISH_CHANNELS = List.of(Long.valueOf(1129095997461647402L), Long.valueOf(1129077934330744882L));

    public MangoBotPlugin() {
        super(ID, JDABuilder.createDefault((String)((String)BOT_TOKEN.get())).setEnabledIntents(intents).enableCache(cacheFlags).setActivity(Activity.of((Activity.ActivityType)Activity.ActivityType.CUSTOM_STATUS, (String)"    MangoBot is on version %s\n".formatted(VersionCommand.getVersion()), (String)"https://www.discord.minecraftforge.net/")).setStatus(OnlineStatus.ONLINE).setMemberCachePolicy(MemberCachePolicy.ALL).setEventManager((IEventManager)new AnnotatedEventManager()).setEnableShutdownHook(true).setAutoReconnect(true).build());
        this.getJDA().addEventListener(new Object[]{new BotEventListener(this)});
        this.objectMap.put("jda", this.getJDA());
        new AutoUpdate(this);
        this.init();
    }

    public void startup() {
        BotPermissions.init();
    }

    public void onMessage(DiscordEvent<MessageReceivedEvent> event) {
        MessageReceivedEvent dEvent = (MessageReceivedEvent)event.getInstance();
        long channel = dEvent.getChannel().getIdLong();
        if (AUTO_PUBLISH_CHANNELS.contains(channel)) {
            Message msg = dEvent.getMessage();
            if (dEvent.isFromType(ChannelType.NEWS)) {
                msg.crosspost().queue();
            }
        }
    }

    public void registration() {
        CommandRegistry cmdRegistry = this.getCommandRegistry();
        PermissionRegistry permRegistry = this.getPermissionRegistry();
        ACTION_REGISTRY.register((ButtonAction)new TrashButtonAction());
        permRegistry.register(BotPermissions.PLAYING);
        permRegistry.register(BotPermissions.TRICK_ADMIN);
        permRegistry.register(BotPermissions.PREFIX_ADMIN);
        permRegistry.register(BotPermissions.MOD_MAIL);
        permRegistry.register(BotPermissions.PERMISSION_ADMIN);
        permRegistry.register(BotPermissions.CUSTOM_VC_ADMIN);
        cmdRegistry.addBasicCommand((IBasicCommand)new HelpCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new InfoCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new JoinCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new LeaveCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new PermissionCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new PingCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new PrefixCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new VersionCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new AntiPingCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new PluginsCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new KickBotCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new RestartCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new SpeakCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new TerminateCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new EchoCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new WhitelistBotCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new PlayCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new PauseCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new PlayingCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new QueueCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new StopCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new VolumeCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)this.objectMap.putAndReturn("trickCommand", new TrickCommand(this)));
        cmdRegistry.addBasicCommand((IBasicCommand)new RunCode(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new GetEmbedsCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new PRScanCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new IssueScanCommand(this));
        GuildConfig.loadServerConfigs();
        permRegistry.save();
        PasteRequestModule.register((IEventBus<IEventType.INormalBusEvent>)this.getPluginBus());
        new GHPRStatus(this);
        new GHIssueStatus(this);
        this.getPluginBus().addListener(10, PluginMessageEvent.class, pm -> {
            if (pm.getMethod().equals("getDate")) {
                if (pm.getObject().get() == null) {
                    return;
                }
                Object patt0$temp = pm.getObject().get();
                if (patt0$temp instanceof Date) {
                    Date date = (Date)patt0$temp;
                    System.out.println("Received a Plugin Comms with Data: %s from %s".formatted(date, pm.getOrigin().getId()));
                }
            }
        });
        new Listeners(this);
        this.getPluginBus().addGenericListener(10, MessageReceivedEvent.class, DiscordEvent.class, this::onMessage);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.getPluginBus().post((IEvent)new ShutdownEvent(ShutdownEvent.Phase.PRE))));
    }

    public void finished() {
        this.getPluginBus().post((IEvent)new LoadEvent());
        this.getJDA().updateCommands().addCommands((Collection)Command.globalCommands).queue();
        try {
            WebServer.startWebServerSafely(this.objectMap);
        }
        catch (Exception e) {
            LogHelper.error((String)"Failed to start WebServer");
            LogHelper.trace((String)e.getMessage());
        }
    }

    public void shutdownPre() {
        this.getPluginBus().post((IEvent)new SaveEvent());
    }

    public String getCommandPrefix() {
        return "mb?";
    }

    public void startup(StartupEvent.Phase phase) {
        switch (phase) {
            case STARTUP: {
                this.startup();
                break;
            }
            case REGISTRATION: {
                this.registration();
                break;
            }
            case FINISHED: {
                this.finished();
            }
        }
    }

    public void shutdown(ShutdownEvent.Phase phase) {
        switch (phase) {
            case PRE: {
                this.shutdownPre();
            }
        }
    }

    public static String getToken() {
        if (((String)BOT_TOKEN.get()).equals("empty") || ((String)BOT_TOKEN.get()).equals("")) {
            System.out.println("Empty bot token, replace the bot token with the one from discord in" + String.valueOf(CONFIG.getFile()) + " or by typing it in here if you are not in gradle:");
            Scanner scanner = new Scanner(System.in);
            if (scanner.hasNext()) {
                String token = scanner.nextLine();
                BOT_TOKEN.set((Object)token);
                scanner.close();
                return token;
            }
            System.out.println("Blank response, this is expected from being run within Gradle. You need to put your token here " + String.valueOf(CONFIG.getFile()));
            scanner.close();
            return (String)BOT_TOKEN.get();
        }
        return (String)BOT_TOKEN.get();
    }
}

