/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.basic.commands;

import java.util.List;
import net.dv8tion.jda.api.entities.Message;
import org.jetbrains.annotations.NotNull;
import org.mangorage.mangobotapi.core.commands.Arguments;
import org.mangorage.mangobotapi.core.commands.CommandResult;
import org.mangorage.mangobotapi.core.commands.CommandType;
import org.mangorage.mangobotapi.core.commands.IBasicCommand;
import org.mangorage.mangobotapi.core.plugin.api.CorePlugin;
import org.mangorage.mangobotapi.core.util.MessageSettings;

public class InfoCommand
implements IBasicCommand {
    private final CorePlugin corePlugin;

    public InfoCommand(CorePlugin corePlugin) {
        this.corePlugin = corePlugin;
    }

    @NotNull
    public CommandResult execute(Message message, Arguments args) {
        MessageSettings settings = this.corePlugin.getMessageSettings();
        String cmd = args.get(0);
        if (cmd == null) {
            settings.apply(message.reply((CharSequence)this.usage())).queue();
            return CommandResult.PASS;
        }
        IBasicCommand command = this.corePlugin.getCommandRegistry().getCommand(cmd);
        if (command == null) {
            settings.apply(message.reply((CharSequence)"Command not found!")).queue();
            return CommandResult.PASS;
        }
        StringBuilder result = new StringBuilder();
        List aliases = command.commandAliases();
        String description = command.description();
        String usage = command.usage();
        CommandType commandType = command.commandType();
        boolean ignoreCase = command.ignoreCase();
        List allowedGuilds = command.allowedGuilds();
        List allowedUsers = command.allowedUsers();
        result.append("CommandId").append(" -> ").append(command.commandId()).append("\n");
        if (!aliases.isEmpty()) {
            result.append("Aliases:").append("\n");
            for (String alias : aliases) {
                result.append(" -> ").append(alias).append("\n");
            }
        }
        if (!description.isEmpty()) {
            result.append("Description:").append("\n").append(" -> ").append(description).append("\n");
        }
        if (!usage.isEmpty()) {
            result.append("Usage:").append("\n").append(" -> ").append(usage).append("\n");
        }
        if (!allowedGuilds.isEmpty()) {
            result.append("Allowed Guilds:").append("\n");
            for (String guild : allowedGuilds) {
                result.append(" -> ").append(guild).append("\n");
            }
        }
        if (!allowedUsers.isEmpty()) {
            result.append("Allowed Users:").append("\n");
            for (String user : allowedUsers) {
                result.append(" -> ").append(user).append("\n");
            }
        }
        result.append("Command Type").append(" -> ").append(commandType).append("\n");
        result.append("Ignore Case").append(" -> ").append(ignoreCase).append("\n");
        settings.apply(message.reply((CharSequence)result.toString())).queue();
        return CommandResult.PASS;
    }

    public String commandId() {
        return "info";
    }

    public String usage() {
        return "!info <commandId>";
    }

    public String description() {
        return "Gets info about a command";
    }
}

