/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.tricks.lua.builders;

import java.util.Arrays;
import java.util.List;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;

public class LuaMessageResponseBuilder {
    private final MessageCreateAction message;

    public LuaMessageResponseBuilder(MessageCreateAction message) {
        this.message = message;
    }

    public LuaMessageResponseBuilder reply(String content) {
        this.message.setContent(content);
        return this;
    }

    public LuaMessageResponseBuilder setMentions(String name) {
        String[] names = name.split(":");
        if (names.length == 0 || names[0].isEmpty()) {
            this.message.setAllowedMentions(List.of());
        } else {
            this.message.setAllowedMentions(Arrays.stream(names).map(Message.MentionType::valueOf).filter(t -> {
                if (t == Message.MentionType.EVERYONE) {
                    return false;
                }
                return t != Message.MentionType.HERE;
            }).toList());
        }
        return this;
    }

    public LuaMessageResponseBuilder setSuppressedNotifications(boolean value) {
        this.message.setSuppressedNotifications(value);
        return this;
    }

    public LuaMessageResponseBuilder setMentionsUser(boolean mentionsUser) {
        this.message.mentionRepliedUser(mentionsUser);
        return this;
    }

    public LuaMessageResponseBuilder setMention(String user) {
        String[] users = user.split(":");
        this.message.mentionUsers(users);
        return this;
    }

    public LuaMessageResponseBuilder setEmbed(MessageEmbed embed) {
        this.message.setEmbeds(new MessageEmbed[]{embed});
        return this;
    }

    public void queue() {
        ((MessageCreateAction)this.message.setAllowedMentions(this.message.getAllowedMentions().stream().filter(t -> {
            if (t == Message.MentionType.EVERYONE) {
                return false;
            }
            return t != Message.MentionType.HERE;
        }).toList())).queue();
    }
}

