/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.developer;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import net.dv8tion.jda.api.entities.Message;
import org.jetbrains.annotations.NotNull;
import org.mangorage.mangobotapi.core.commands.Arguments;
import org.mangorage.mangobotapi.core.commands.CommandResult;
import org.mangorage.mangobotapi.core.commands.IBasicCommand;
import org.mangorage.mangobotapi.core.data.DataHandler;
import org.mangorage.mangobotapi.core.data.IEmptyFileNameResolver;
import org.mangorage.mangobotapi.core.data.IFileNameResolver;
import org.mangorage.mangobotapi.core.plugin.api.JDAPlugin;

public class WhitelistBotCommand
implements IBasicCommand {
    private static final List<String> ALLOWED_USERS = List.of("194596094200643584");
    private static final DataHandler<SaveData> WHITELIST_DATA = DataHandler.create().path("data/serverwl/data").file().build(SaveData.class);
    private final Set<String> SERVERS = new CopyOnWriteArraySet<String>();
    private final JDAPlugin plugin;
    private final Timer timer = new Timer();
    private final TimerTask TASK = new TimerTask(){

        @Override
        public void run() {
            if (WhitelistBotCommand.this.whitelistOn) {
                System.out.println("Checking Guilds bot is in....");
                WhitelistBotCommand.this.plugin.getJDA().getGuilds().forEach(g -> {
                    if (!WhitelistBotCommand.this.SERVERS.contains(g.getId())) {
                        System.out.println("Left Guild -> " + g.getIdLong());
                        g.leave().queue();
                    }
                });
            }
        }
    };
    private boolean whitelistOn = false;

    public WhitelistBotCommand(JDAPlugin plugin) {
        this.plugin = plugin;
        Optional data = WHITELIST_DATA.loadFile(plugin.getPluginDirectory());
        data.ifPresent(d -> {
            this.SERVERS.addAll(d.serverIds());
            this.whitelistOn = d.whiteliston();
        });
        this.timer.scheduleAtFixedRate(this.TASK, 10000L, 1800000L);
    }

    @NotNull
    public CommandResult execute(Message message, Arguments arguments) {
        if (arguments.hasArg("toggle")) {
            this.whitelistOn = !this.whitelistOn;
            message.reply((CharSequence)("Set Server Whitelist to " + (this.whitelistOn ? "On" : "Off"))).queue();
            WHITELIST_DATA.save(this.plugin.getPluginDirectory(), (IFileNameResolver[])new SaveData[]{new SaveData(new HashSet<String>(this.SERVERS), this.whitelistOn)});
            if (this.whitelistOn) {
                this.runTask();
            }
        } else if (arguments.hasArg("add")) {
            this.handle(true, arguments.findArg("add"), message);
        } else if (arguments.hasArg("remove")) {
            this.handle(false, arguments.findArg("remove"), message);
        }
        return CommandResult.PASS;
    }

    private void runTask() {
    }

    private void handle(boolean add, String id, Message message) {
        if (this.SERVERS.contains(id) && add) {
            message.reply((CharSequence)"Server with Id %s is already whitelisted".formatted(id)).queue();
            return;
        }
        if (!this.SERVERS.contains(id) && !add) {
            message.reply((CharSequence)"Server with Id %s is already removed from whitelist".formatted(id)).queue();
            return;
        }
        message.reply((CharSequence)((add ? "Added " : "Removed ") + "server with ID of " + id)).queue();
        if (add) {
            this.SERVERS.add(id);
            if (this.whitelistOn) {
                this.runTask();
            }
        }
        if (!add) {
            this.SERVERS.remove(id);
        }
        WHITELIST_DATA.save(this.plugin.getPluginDirectory(), (IFileNameResolver[])new SaveData[]{new SaveData(new HashSet<String>(this.SERVERS), this.whitelistOn)});
    }

    public String commandId() {
        return "serverwl";
    }

    public List<String> allowedUsers() {
        return ALLOWED_USERS;
    }

    public String usage() {
        return "serverwl toggle\nserverwl add/remove id\n";
    }

    private record SaveData(HashSet<String> serverIds, boolean whiteliston) implements IEmptyFileNameResolver
    {
    }
}

