/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.servlet;

import htmlflow.HtmlFlow;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.mangorage.mangobot.website.impl.AbstractServlet;
import org.xmlet.htmlapifaster.Body;
import org.xmlet.htmlapifaster.EnumEnctypeType;
import org.xmlet.htmlapifaster.EnumMethodType;
import org.xmlet.htmlapifaster.EnumTypeInputType;
import org.xmlet.htmlapifaster.Form;
import org.xmlet.htmlapifaster.H1;
import org.xmlet.htmlapifaster.H3;
import org.xmlet.htmlapifaster.Head;
import org.xmlet.htmlapifaster.Html;
import org.xmlet.htmlapifaster.Pre;
import org.xmlet.htmlapifaster.Title;

@MultipartConfig
public class FileUploadServlet
extends AbstractServlet {
    private static final String UPLOAD_DIR = "webpage-root/uploads";

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest httpReq = (HttpServletRequest)req;
        HttpServletResponse httpResp = (HttpServletResponse)res;
        if ("GET".equals(httpReq.getMethod())) {
            ((Body)((Form)((Form)((Form)((Body)((H1)((Html)((Head)((Title)HtmlFlow.doc((Appendable)httpResp.getWriter()).html().head().title().text((Object)"File Upload Page")).__()).__()).body().h1().text((Object)"Upload a File")).__()).form().attrMethod(EnumMethodType.POST).attrAction("/upload").attrEnctype(EnumEnctypeType.MULTIPART_FORM_DATA).input().attrType(EnumTypeInputType.FILE).attrName("file").__()).br().__()).input().attrType(EnumTypeInputType.SUBMIT).attrValue("Upload").__()).__()).hr().__();
            HtmlFlow.view((Appendable)httpResp.getWriter(), page -> {
                Body body = page.html().body();
                String uploadedFile = httpReq.getParameter("file");
                if (uploadedFile != null) {
                    if (uploadedFile.endsWith(".png") || uploadedFile.endsWith(".jpg") || uploadedFile.endsWith(".jpeg")) {
                        body.img().attrSrc("/webpage-root/uploads/" + uploadedFile).attrAlt("Uploaded Image").attrWidth(Long.valueOf(300L)).__();
                    } else if (uploadedFile.endsWith(".txt") || uploadedFile.endsWith(".log")) {
                        ((H3)body.h3().text((Object)"File Content:")).__();
                        try {
                            ((Pre)body.pre().text((Object)this.readFile("webpage-root/uploads/" + uploadedFile))).__();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
        } else if ("POST".equals(httpReq.getMethod())) {
            Part filePart = httpReq.getPart("file");
            UUID ID = UUID.randomUUID();
            String fileName = Paths.get(filePart.getSubmittedFileName(), new String[0]).getFileName().toString();
            Path uploadPath = Paths.get(UPLOAD_DIR, new String[0]);
            if (!Files.exists(uploadPath, new LinkOption[0])) {
                Files.createDirectories(uploadPath, new FileAttribute[0]);
            }
            try (InputStream input = filePart.getInputStream();){
                Files.copy(input, uploadPath.resolve(ID.toString()), StandardCopyOption.REPLACE_EXISTING);
            }
            httpResp.sendRedirect("/file?id=" + String.valueOf(ID));
        }
    }

    private String readFile(String filePath) throws IOException {
        return new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
    }
}

