/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileServlet
extends HttpServlet {
    private static final String UPLOAD_DIR = "webpage-root/uploads";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String fileId = request.getParameter("id");
        if (fileId == null || fileId.isEmpty()) {
            response.sendError(400, "File ID is required.");
            return;
        }
        this.handleFileRequest(fileId, response);
    }

    private void handleFileRequest(String fileName, HttpServletResponse response) throws IOException {
        if (fileName.contains("..") || fileName.contains("/") || fileName.contains("\\")) {
            response.sendError(403, "Invalid file name.");
            return;
        }
        File file = new File(UPLOAD_DIR, fileName);
        if (file.exists() && file.isFile()) {
            String contentType = this.determineContentType(file);
            response.setContentType(contentType);
            response.setContentLengthLong(file.length());
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                ((InputStream)fileInputStream).transferTo((OutputStream)response.getOutputStream());
            }
        } else {
            response.sendError(404, "File not found.");
        }
    }

    private String determineContentType(File file) {
        String contentType = "text/plain";
        String fileName = file.getName().toLowerCase();
        if (fileName.endsWith(".txt")) {
            contentType = "text/plain";
        } else if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
            contentType = "image/jpeg";
        } else if (fileName.endsWith(".png")) {
            contentType = "image/png";
        } else if (fileName.endsWith(".gif")) {
            contentType = "image/gif";
        } else if (fileName.endsWith(".pdf")) {
            contentType = "application/pdf";
        } else if (fileName.endsWith(".json")) {
            contentType = "application/json";
        } else if (fileName.endsWith(".css")) {
            contentType = "text/css";
        } else if (fileName.endsWith(".js")) {
            contentType = "application/javascript";
        }
        return contentType;
    }
}

