/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot;

import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.mangorage.basicutils.LogHelper;
import org.mangorage.mangobot.MangoBotPlugin;
import org.mangorage.mangobotapi.core.plugin.api.JDAPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public final class AutoUpdate
implements Runnable {
    private static final String URL = "https://maven.minecraftforge.net/org/mangorage/mangobotplugin/maven-metadata.xml";
    private long lastUpdated = -1L;
    private boolean running = true;
    private final JDAPlugin plugin;

    public static String getLastUpdated(String mavenMetadataUrl) {
        try {
            InputStream inputStream = new URL(mavenMetadataUrl).openStream();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(inputStream);
            NodeList nodeList = doc.getElementsByTagName("lastUpdated");
            if (nodeList.getLength() > 0) {
                return nodeList.item(0).getTextContent();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    AutoUpdate(JDAPlugin plugin) {
        this.plugin = plugin;
        if (((Boolean)MangoBotPlugin.AUTO_UPDATE.get()).booleanValue()) {
            try {
                this.lastUpdated = Long.valueOf(AutoUpdate.getLastUpdated(URL));
            }
            catch (Exception exception) {
                // empty catch block
            }
            LogHelper.info((String)"Started Auto Updater");
            new Thread(this).start();
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(10000L);
                Long last = Long.valueOf(AutoUpdate.getLastUpdated(URL));
                if (this.lastUpdated == -1L) {
                    this.lastUpdated = last;
                    continue;
                }
                if (this.lastUpdated == last) continue;
                LogHelper.info((String)"Detected New Version! Restarting!");
                this.running = false;
            }
            catch (Exception exception) {}
        }
        System.exit(0);
    }
}

