/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.servlet;

import htmlflow.HtmlFlow;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.User;
import org.mangorage.mangobot.modules.tricks.Trick;
import org.mangorage.mangobot.modules.tricks.TrickCommand;
import org.mangorage.mangobot.website.impl.AbstractServlet;
import org.mangorage.mangobot.website.impl.ObjectMap;
import org.xmlet.htmlapifaster.Body;
import org.xmlet.htmlapifaster.Div;
import org.xmlet.htmlapifaster.EnumRelType;
import org.xmlet.htmlapifaster.EnumTypeInputType;
import org.xmlet.htmlapifaster.EnumWrapType;
import org.xmlet.htmlapifaster.Form;
import org.xmlet.htmlapifaster.H2;
import org.xmlet.htmlapifaster.Head;
import org.xmlet.htmlapifaster.Html;
import org.xmlet.htmlapifaster.Option;
import org.xmlet.htmlapifaster.Select;
import org.xmlet.htmlapifaster.Textarea;

public class TricksServlet
extends AbstractServlet {
    public static String getUser(JDA jda, long id) {
        User user = jda.getUserById(id);
        if (user != null) {
            return user.getName();
        }
        return "";
    }

    public static String getGuild(JDA jda, long id) {
        Guild guild = jda.getGuildById(id);
        if (guild != null) {
            return guild.getName();
        }
        return "";
    }

    private static long getLong(String value) {
        try {
            return Long.valueOf(value);
        }
        catch (Exception ignored) {
            return -1L;
        }
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        ObjectMap map = (ObjectMap)this.getServletConfig().getServletContext().getAttribute("map");
        TrickCommand command = map.get("trickCommand", TrickCommand.class);
        JDA jda = map.get("jda", JDA.class);
        response.setContentType("text/html");
        String guildId = request.getParameter("guildId");
        String trickId = request.getParameter("trickId");
        Body html = ((Html)((Head)HtmlFlow.doc((Appendable)response.getWriter()).html().head().link().attrRel(EnumRelType.STYLESHEET).attrHref(this.getStyles()).__()).__()).body();
        if (guildId == null && trickId == null) {
            Select form = ((Body)((H2)html.h2().text((Object)"SELECT GUILD")).__()).form().select().attrName("guildId");
            for (Long guild : command.getGuilds()) {
                form = (Select)((Option)form.option().attrValue(guild.toString()).text((Object)TricksServlet.getGuild(jda, guild))).__();
            }
            ((Form)form.__()).button().attrFormtarget("guildId").text((Object)"Enter!");
        } else if (guildId != null && trickId == null) {
            Select form = ((Form)((Body)((H2)html.h2().text((Object)"SELECT TRICK")).__()).form().input().attrType(EnumTypeInputType.HIDDEN).attrName("guildId").attrValue(guildId).__()).form().select().attrName("trickId");
            for (Trick trick : command.getTricksForGuild(TricksServlet.getLong(guildId))) {
                form = (Select)((Option)form.option().attrValue(trick.getTrickID()).text((Object)trick.getTrickID())).__();
            }
            ((Form)form.__()).button().attrFormtarget("trickId").text((Object)"Enter!");
        } else if (guildId != null && trickId != null) {
            try {
                Trick trick = command.getTrick(trickId, Long.parseLong(guildId));
                if (trick != null) {
                    html.h2().text((Object)("Id: " + trick.getTrickID()));
                    html.h2().text((Object)("Type: " + String.valueOf((Object)trick.getType())));
                    html.h2().text((Object)("GuildId: " + trick.getGuildID() + " " + TricksServlet.getGuild(jda, trick.getGuildID())));
                    switch (trick.getType()) {
                        case ALIAS: {
                            ((Body)((H2)html.h2().text((Object)"Alias Target:")).__()).h2().text((Object)trick.getAliasTarget());
                            break;
                        }
                        case NORMAL: {
                            ((Div)((Textarea)((Body)((H2)html.h2().text((Object)"Content:")).__()).div().textarea().attrCols(Long.valueOf(50L)).attrRows(Long.valueOf(20L)).attrWrap(EnumWrapType.HARD).attrReadonly(Boolean.valueOf(true)).text((Object)trick.getContent())).__()).__();
                            break;
                        }
                        case SCRIPT: {
                            ((Div)((Textarea)((Body)((H2)html.h2().text((Object)"Script:")).__()).div().textarea().attrCols(Long.valueOf(50L)).attrRows(Long.valueOf(20L)).attrWrap(EnumWrapType.HARD).attrReadonly(Boolean.valueOf(true)).text((Object)trick.getScript())).__()).__();
                        }
                    }
                    html.h4().text((Object)("Trick Owner: " + trick.getOwnerID() + " " + TricksServlet.getUser(jda, trick.getOwnerID())));
                    html.h4().text((Object)("Last User to edit: " + trick.getLastUserEdited() + " " + TricksServlet.getUser(jda, trick.getLastUserEdited())));
                    html.h4().text((Object)("Trick Creation Date: " + String.valueOf(Date.from(Instant.ofEpochMilli(trick.getCreated())))));
                    html.h4().text((Object)("Trick Last Edited: " + String.valueOf(Date.from(Instant.ofEpochMilli(trick.getLastEdited())))));
                    html.h4().text((Object)("Times Used: " + trick.getTimesUsed()));
                } else {
                    html.h1().text((Object)"Invalid Trick %s Supplied for Guild %s".formatted(trickId, guildId));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean useDefaultStyles() {
        return false;
    }
}

