/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website.servlet;

import htmlflow.HtmlFlow;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.User;
import org.mangorage.mangobot.modules.tricks.Trick;
import org.mangorage.mangobot.modules.tricks.TrickCommand;
import org.mangorage.mangobot.website.impl.AbstractServlet;
import org.mangorage.mangobot.website.impl.ObjectMap;
import org.xmlet.htmlapifaster.Body;
import org.xmlet.htmlapifaster.EnumRelType;
import org.xmlet.htmlapifaster.Head;
import org.xmlet.htmlapifaster.Html;
import org.xmlet.htmlapifaster.Textarea;

public class TricksServlet
extends AbstractServlet {
    public static String getUser(JDA jda, long id) {
        User user = jda.getUserById(id);
        if (user != null) {
            return user.getName();
        }
        return "";
    }

    public static String getGuild(JDA jda, long id) {
        Guild guild = jda.getGuildById(id);
        if (guild != null) {
            return guild.getName();
        }
        return "";
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        block10: {
            ObjectMap map = (ObjectMap)this.getServletConfig().getServletContext().getAttribute("map");
            TrickCommand command = map.get("trickCommand", TrickCommand.class);
            JDA jda = map.get("jda", JDA.class);
            response.setContentType("text/html");
            String guildId = request.getParameter("guildId");
            String trickId = request.getParameter("trickId");
            Body html = ((Html)((Head)HtmlFlow.doc((Appendable)response.getWriter()).html().head().link().attrRel(EnumRelType.STYLESHEET).attrHref(this.getStyles()).__()).__()).body();
            if (guildId != null && trickId != null) {
                try {
                    Trick trick = command.getTrick(trickId, Long.parseLong(guildId));
                    if (trick != null) {
                        html.h2().text((Object)("Id: " + trick.getTrickID()));
                        html.h2().text((Object)("Type: " + String.valueOf((Object)trick.getType())));
                        html.h2().text((Object)("GuildId: " + trick.getGuildID() + " " + TricksServlet.getGuild(jda, trick.getGuildID())));
                        switch (trick.getType()) {
                            case ALIAS: {
                                html.h2().text((Object)"Alias Target:");
                                html.h2().text((Object)trick.getAliasTarget());
                                break;
                            }
                            case NORMAL: {
                                html.h2().text((Object)"Content:");
                                ((Textarea)html.div().textarea().attrCols(Long.valueOf(50L)).attrRows(Long.valueOf(20L)).text((Object)trick.getContent())).__();
                                break;
                            }
                            case SCRIPT: {
                                html.h2().text((Object)"Script:");
                                html.h2().text((Object)trick.getScript());
                            }
                        }
                        html.h4().text((Object)("Trick Owner: " + trick.getOwnerID() + " " + TricksServlet.getUser(jda, trick.getOwnerID())));
                        html.h4().text((Object)("Last User to edit: " + trick.getLastUserEdited() + " " + TricksServlet.getUser(jda, trick.getLastUserEdited())));
                        html.h4().text((Object)("Trick Creation Date: " + String.valueOf(Date.from(Instant.ofEpochMilli(trick.getCreated())))));
                        html.h4().text((Object)("Trick Last Edited: " + String.valueOf(Date.from(Instant.ofEpochMilli(trick.getLastEdited())))));
                        html.h4().text((Object)("Times Used: " + trick.getTimesUsed()));
                        break block10;
                    }
                    html.h1().text((Object)"Invalid Trick %s Supplied for Guild %s".formatted(trickId, guildId));
                }
                catch (Exception exception) {}
            } else {
                html.h1().text((Object)"URL Format /trick?guildId=1234&trickId=example");
            }
        }
    }

    @Override
    public boolean useDefaultStyles() {
        return false;
    }
}

