/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.github;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import org.eclipse.egit.github.core.Gist;
import org.eclipse.egit.github.core.GistFile;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.GistService;
import org.mangorage.basicutils.TaskScheduler;
import org.mangorage.basicutils.misc.LazyReference;
import org.mangorage.eventbus.interfaces.IEventBus;
import org.mangorage.eventbus.interfaces.IEventType;
import org.mangorage.mangobot.MangoBotPlugin;
import org.mangorage.mangobot.modules.logs.BrokenDrivers;
import org.mangorage.mangobot.modules.logs.EarlyWindow;
import org.mangorage.mangobot.modules.logs.Java22;
import org.mangorage.mangobot.modules.logs.LogAnalyser;
import org.mangorage.mangobot.modules.logs.MissingDeps;
import org.mangorage.mangobotapi.core.events.DiscordEvent;

public class PasteRequestModule {
    public static final LogAnalyser analyser = LogAnalyser.of(new BrokenDrivers(), new EarlyWindow(), new Java22(), new MissingDeps(), LogAnalyser.createModule((s, m) -> ((MessageCreateAction)((MessageCreateAction)m.reply((CharSequence)"This is a common issue on Modrinth Theseus. Modrinth's launcher has been known to be problematic in some cases with Forge. If you need to download a Modrinth format modpack you can use Prism Launcher, GDLauncher, ATLauncher, or others which are far more reliable.").setSuppressEmbeds(true)).mentionRepliedUser(true)).queue(), List.of("Invalid registry value type detected for PerfOS counters", "com.modrinth.theseus")), LogAnalyser.createModule((s, m) -> ((MessageCreateAction)((MessageCreateAction)m.reply((CharSequence)"This issue is in most cases caused by an outdated version of Java with issues with Let's Encrypt SSL. Please Update to a newer build of Java [Guide](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft). It can also be caused by networking issues.").setSuppressEmbeds(true)).mentionRepliedUser(true)).queue(), List.of("net.minecraftforge.installertools", "sun.security.validator.PKIXValidator")), LogAnalyser.createModule((s, m) -> ((MessageCreateAction)((MessageCreateAction)m.reply((CharSequence)"Use Java 8. [Guide](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft).").setSuppressEmbeds(true)).mentionRepliedUser(true)).queue(), List.of("jdk.internal.loader.ClassLoaders$AppClassLoader cannot be cast to class java.net.URLClassLoader")), LogAnalyser.createModule((s, m) -> ((MessageCreateAction)((MessageCreateAction)m.reply((CharSequence)"You are using old Java version. Use Java 17 for 1.17-1.20.4 or Java 21 for 1.20.5+. [Guide](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft).").setSuppressEmbeds(true)).mentionRepliedUser(true)).queue(), List.of("Current Java is", "but we require at least")), LogAnalyser.createModule((s, m) -> ((MessageCreateAction)((MessageCreateAction)m.reply((CharSequence)"You are using old Java version. Use Java 17 for 1.17-1.20.4 or Java 21 for 1.20.5+. [Guide](https://mikumikudance.jp/index.php?title=Installing_Java_For_Minecraft).").setSuppressEmbeds(true)).mentionRepliedUser(true)).queue(), List.of("Error: could not open", "user_jvm_args.txt")), LogAnalyser.createModule((s, m) -> ((MessageCreateAction)((MessageCreateAction)m.reply((CharSequence)"Update FeatureCreep").setSuppressEmbeds(true)).mentionRepliedUser(true)).queue(), List.of("Caused by: java.lang.IllegalArgumentException: Missing scheme", "org.jboss.modules")));
    static final LazyReference<GitHubClient> GITHUB_CLIENT = LazyReference.create(() -> new GitHubClient().setOAuth2Token((String)MangoBotPlugin.GITHUB_TOKEN.get()));
    private static final List<String> GUILDS = List.of("1129059589325852724", "834300742864601088", "1179586337431633991", "716249661798612992");
    private static final Emoji EMOJI = Emoji.fromUnicode((String)"\ud83d\udccb");

    public static void register(IEventBus<IEventType.INormalBusEvent> bus) {
        bus.addGenericListener(10, MessageReceivedEvent.class, DiscordEvent.class, PasteRequestModule::onMessage);
        bus.addGenericListener(10, MessageReactionAddEvent.class, DiscordEvent.class, PasteRequestModule::onReact);
    }

    private static byte[] getData(InputStream stream) {
        try {
            byte[] data = stream.readAllBytes();
            stream.close();
            return data;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String getFileName(Message.Attachment attachment, int count) {
        String fileName = attachment.getFileName();
        String ext = ".%s".formatted(attachment.getFileExtension());
        if (ext == null) {
            return attachment.getFileName();
        }
        String fileNameNoExt = fileName.substring(0, fileName.length() - ext.length());
        return "%s_%s%s".formatted(fileNameNoExt, count, ext);
    }

    private static double calculatePrintableCharacterConfidence(String input) {
        long printableCount = input.codePoints().filter(codePoint -> codePoint >= 32 && codePoint <= 126).count();
        double confidence = (double)printableCount / (double)input.length();
        return confidence;
    }

    private static boolean containsPrintableCharacters(String input) {
        return PasteRequestModule.calculatePrintableCharacterConfidence(input) > 0.6;
    }

    public static void createGists(Message msg, User requester) {
        TaskScheduler.getExecutor().execute(() -> {
            if (!msg.isFromGuild()) {
                return;
            }
            if (!GUILDS.contains(msg.getGuildId())) {
                ((MessageCreateAction)msg.reply((CharSequence)"Your server is not on the allowlist for Gist Paste. Please contact the server admin if you use wish to use this functionality.").mentionRepliedUser(false)).queue();
                return;
            }
            List attachments = msg.getAttachments();
            if (attachments.isEmpty()) {
                return;
            }
            GitHubClient CLIENT = (GitHubClient)GITHUB_CLIENT.get();
            GistService service = new GistService(CLIENT);
            AtomicInteger count = new AtomicInteger(1);
            Gist gist = new Gist();
            gist.setPublic(false);
            gist.setDescription("Automatically made from MangoBot.");
            HashMap FILES = new HashMap();
            attachments.forEach(attachment -> {
                try {
                    byte[] bytes = PasteRequestModule.getData((InputStream)attachment.getProxy().download().get());
                    if (bytes == null) {
                        return;
                    }
                    String content = new String(bytes, StandardCharsets.UTF_8);
                    if (!PasteRequestModule.containsPrintableCharacters(content)) {
                        return;
                    }
                    String fileName = PasteRequestModule.getFileName(attachment, count.getAndAdd(1));
                    GistFile gistFile = new GistFile();
                    gistFile.setContent(content);
                    gistFile.setFilename(fileName);
                    FILES.put(fileName, gistFile);
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            gist.setFiles(FILES);
            try {
                Gist remote = service.createGist(gist);
                StringBuilder result = new StringBuilder();
                result.append("Gist -> [[gist](%s)]".formatted(remote.getHtmlUrl()));
                remote.getFiles().forEach((key, file) -> result.append(" [[raw %s](%s)]".formatted(file.getFilename(), file.getRawUrl())));
                ((MessageCreateAction)((MessageCreateAction)msg.reply((CharSequence)result).setSuppressEmbeds(true)).mentionRepliedUser(false)).queue();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void onMessage(DiscordEvent<MessageReceivedEvent> event) {
        MessageReceivedEvent dEvent = (MessageReceivedEvent)event.getInstance();
        Message message = dEvent.getMessage();
        List attachments = message.getAttachments();
        analyser.scanMessage(message);
        if (!attachments.isEmpty()) {
            TaskScheduler.getExecutor().execute(() -> {
                AtomicBoolean suceeeded = new AtomicBoolean(false);
                for (Message.Attachment attachment : attachments) {
                    try {
                        String content;
                        byte[] bytes = PasteRequestModule.getData((InputStream)attachment.getProxy().download().get());
                        if (bytes == null || !PasteRequestModule.containsPrintableCharacters(content = new String(bytes, StandardCharsets.UTF_8))) continue;
                        suceeeded.set(true);
                        analyser.readLog(message, content);
                        break;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (suceeeded.get()) {
                    message.addReaction(EMOJI).queue();
                }
            });
        }
    }

    public static void onReact(DiscordEvent<MessageReactionAddEvent> event) {
        MessageReactionAddEvent dEvent = (MessageReactionAddEvent)event.getInstance();
        if (!dEvent.isFromGuild()) {
            return;
        }
        if (dEvent.getUser() == null) {
            return;
        }
        if (dEvent.getUser().isBot()) {
            return;
        }
        dEvent.retrieveMessage().queue(a -> {
            if (a.getAttachments().isEmpty()) {
                return;
            }
            a.retrieveReactionUsers(EMOJI).queue(b -> b.stream().filter(user -> user.getId().equals(dEvent.getJDA().getSelfUser().getId())).findFirst().ifPresent(c -> {
                a.clearReactions(EMOJI).queue();
                PasteRequestModule.createGists(a, dEvent.getUser());
            }));
        });
    }
}

