/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.website;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.User;
import org.mangorage.mangobot.modules.tricks.Trick;
import org.mangorage.mangobot.modules.tricks.TrickCommand;
import org.mangorage.mangobot.website.impl.AbstractServlet;
import org.mangorage.mangobot.website.impl.ObjectMap;

public class TricksServlet
extends AbstractServlet {
    public static String getUser(JDA jda, long id) {
        User user = jda.getUserById(id);
        if (user != null) {
            return user.getName();
        }
        return "";
    }

    public static String getGuild(JDA jda, long id) {
        Guild guild = jda.getGuildById(id);
        if (guild != null) {
            return guild.getName();
        }
        return "";
    }

    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        block10: {
            ObjectMap map = (ObjectMap)this.getServletConfig().getServletContext().getAttribute("map");
            TrickCommand command = map.get("trickCommand", TrickCommand.class);
            JDA jda = map.get("jda", JDA.class);
            response.setContentType("text/html");
            String guildId = request.getParameter("guildId");
            String trickId = request.getParameter("trickId");
            String str3 = "<html><body><h2>%s</h2></body></html>";
            String str4 = "<html><body><h4>%s</h4></body></html>";
            if (guildId != null && trickId != null) {
                try {
                    Trick trick = command.getTrick(trickId, Long.parseLong(guildId));
                    if (trick != null) {
                        response.getWriter().write(str3.formatted("Id: " + trick.getTrickID()));
                        response.getWriter().write(str3.formatted("Type: " + String.valueOf((Object)trick.getType())));
                        response.getWriter().write(str3.formatted("GuildId: " + trick.getGuildID() + " " + TricksServlet.getGuild(jda, trick.getGuildID())));
                        switch (trick.getType()) {
                            case ALIAS: {
                                response.getWriter().write(str3.formatted("Alias Target:"));
                                response.getWriter().write(str3.formatted(trick.getAliasTarget()));
                                break;
                            }
                            case NORMAL: {
                                response.getWriter().write(str3.formatted("Content:"));
                                response.getWriter().write(str3.formatted(trick.getContent()));
                                break;
                            }
                            case SCRIPT: {
                                response.getWriter().write(str3.formatted("Script:"));
                                response.getWriter().write(str3.formatted(trick.getScript()));
                            }
                        }
                        response.getWriter().write(str4.formatted("Trick Owner: " + trick.getOwnerID() + " " + TricksServlet.getUser(jda, trick.getOwnerID())));
                        response.getWriter().write(str4.formatted("Last User to edit: " + trick.getLastUserEdited() + " " + TricksServlet.getUser(jda, trick.getLastUserEdited())));
                        response.getWriter().write(str4.formatted("Trick Creation Date: " + String.valueOf(Date.from(Instant.ofEpochMilli(trick.getCreated())))));
                        response.getWriter().write(str4.formatted("Trick Last Edited: " + String.valueOf(Date.from(Instant.ofEpochMilli(trick.getLastEdited())))));
                        response.getWriter().write(str4.formatted("Times Used: " + trick.getTimesUsed()));
                        break block10;
                    }
                    response.getWriter().write(str3.formatted("Invalid Trick %s Supplied for Guild %s".formatted(trickId, guildId)));
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
            } else {
                response.getWriter().write(str3.formatted("URL Format /trick?guildId=1234&trickId=example"));
            }
        }
    }
}

