/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.github;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.mangorage.mangobot.MangoBotPlugin;
import org.mangorage.mangobot.config.GuildConfig;
import org.mangorage.mangobotapi.core.plugin.api.JDAPlugin;

public class GHIssueStatus
extends TimerTask {
    public static ArrayList<String> indexed_channels = new ArrayList();
    private final JDAPlugin JDAPlugin;

    public static void save(int number, Path fileName) {
        try {
            File file = fileName.toFile();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write(Integer.toString(number));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int get(Path fileName) {
        int result = 0;
        File file = fileName.toFile();
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line = reader.readLine();
                if (line != null) {
                    result = Integer.parseInt(line.trim());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public GHIssueStatus(JDAPlugin JDAPlugin2) {
        this.JDAPlugin = JDAPlugin2;
        new Timer().scheduleAtFixedRate((TimerTask)this, 15000L, 3600000L);
    }

    @Override
    public void run() {
        try {
            String token = (String)MangoBotPlugin.GITHUB_TOKEN.get();
            GitHub github = GitHub.connect((String)((String)MangoBotPlugin.GITHUB_USERNAME.get()), (String)token);
            for (String chan : indexed_channels) {
                String[] stringArray;
                String guild = this.JDAPlugin.getJDA().getTextChannelById(chan).getGuild().getId();
                GuildConfig config = GuildConfig.guildsConfig(guild);
                if (((String)config.GIT_REPOS_ISSUE_SCANNED.get()).contains(",")) {
                    stringArray = ((String)config.GIT_REPOS_ISSUE_SCANNED.get()).split(",");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)config.GIT_REPOS_ISSUE_SCANNED.get();
                }
                String[] repos = stringArray;
                if (repos.length == 0) continue;
                int issues = 0;
                StringBuilder builder = new StringBuilder();
                for (String repo : repos) {
                    int lastChecked;
                    int number = lastChecked = GHIssueStatus.get(this.getFile(repo));
                    GHRepository repository = github.getRepository(repo);
                    repository.getIssues(GHIssueState.OPEN);
                    repository.getIssues(GHIssueState.OPEN).stream();
                    ArrayList<GHIssue> ISSUES = new ArrayList<GHIssue>(repository.getIssues(GHIssueState.OPEN).stream().filter(pr -> pr.getNumber() > lastChecked).toList());
                    if (ISSUES.isEmpty()) continue;
                    issues += ISSUES.size();
                    builder.append("New ").append(repo).append(" Issue's: %s".formatted(ISSUES.size())).append("\n");
                    for (GHIssue issue : ISSUES) {
                        System.out.println(issue.getNumber());
                        if (issue.getNumber() > number) {
                            number = issue.getNumber();
                        }
                        builder.append("- %s [%s](%s)".formatted(issue.getTitle(), issue.getNumber(), issue.getHtmlUrl())).append("\n");
                    }
                    GHIssueStatus.save(number, this.getFile(repo));
                }
                if (builder.isEmpty()) continue;
                TextChannel channel = this.JDAPlugin.getJDA().getTextChannelById(chan);
                if (channel == null) {
                    return;
                }
                ((MessageCreateAction)channel.sendMessage((CharSequence)builder).setSuppressEmbeds(true)).queue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Path getFile(String repo) {
        return this.JDAPlugin.getPluginDirectory().resolve("ghissuestatus/" + repo.replace("/", ".") + ".txt");
    }
}

