/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.github;

import java.util.ArrayList;
import java.util.Arrays;
import net.dv8tion.jda.api.entities.Message;
import org.mangorage.mangobot.config.GuildConfig;
import org.mangorage.mangobot.core.BotPermissions;
import org.mangorage.mangobot.modules.github.GHPRStatus;
import org.mangorage.mangobotapi.core.commands.Arguments;
import org.mangorage.mangobotapi.core.commands.CommandResult;
import org.mangorage.mangobotapi.core.commands.IBasicCommand;
import org.mangorage.mangobotapi.core.plugin.api.CorePlugin;
import org.mangorage.mangobotapi.core.util.MessageSettings;

public class PRScanCommand
implements IBasicCommand {
    private final CorePlugin plugin;

    public PRScanCommand(CorePlugin plugin) {
        this.plugin = plugin;
    }

    /*
     * Enabled aggressive block sorting
     */
    public CommandResult execute(Message message, Arguments args) {
        MessageSettings dMessage = this.plugin.getMessageSettings();
        String type = args.get(0);
        String answer = args.get(1);
        GuildConfig guildConfig = GuildConfig.guildsConfig(message.getGuildId());
        if (!BotPermissions.TRICK_ADMIN.hasPermission(message.getMember())) {
            dMessage.apply(message.reply((CharSequence)"No permission!")).queue();
            return CommandResult.NO_PERMISSION;
        }
        if (!type.equals("") && !type.equals(" ")) {
            if (type.equals("-add")) {
                String[] repos_arr = ((String)guildConfig.GIT_REPOS_PR_SCANNED.get()).split(",");
                ArrayList<String> repos = new ArrayList<String>(Arrays.asList(repos_arr));
                repos.add(answer);
                String result = String.join((CharSequence)",", repos);
                guildConfig.GIT_REPOS_PR_SCANNED.set((Object)result);
                dMessage.apply(message.reply((CharSequence)("Added: " + answer))).queue();
                return CommandResult.PASS;
            }
            if (type.equals("-remove")) {
                String[] repos_arr = ((String)guildConfig.GIT_REPOS_PR_SCANNED.get()).split(",");
                ArrayList<String> repos = new ArrayList<String>(Arrays.asList(repos_arr));
                repos.remove(answer);
                String result = String.join((CharSequence)",", repos);
                guildConfig.GIT_REPOS_PR_SCANNED.set((Object)result);
                dMessage.apply(message.reply((CharSequence)("Removed: " + answer))).queue();
                return CommandResult.PASS;
            }
            if (type.equals("-list")) {
                String[] repos = ((String)guildConfig.GIT_REPOS_PR_SCANNED.get()).split(",");
                StringBuilder builder = new StringBuilder();
                String[] stringArray = repos;
                int n = stringArray.length;
                int n2 = 0;
                while (true) {
                    if (n2 >= n) {
                        dMessage.apply(message.reply((CharSequence)builder)).queue();
                        return CommandResult.PASS;
                    }
                    String repo = stringArray[n2];
                    builder.append(repo + "\n");
                    ++n2;
                }
            }
            if (!type.equals("-setchannel")) {
                dMessage.apply(message.reply((CharSequence)("Invalid arg " + type))).queue();
                return CommandResult.FAIL;
            }
            GHPRStatus.indexed_channels.remove(guildConfig.GIT_REPOS_PR_SCANNED_CHANNELID.get());
            if (answer == null) {
                answer = message.getChannelId();
            }
            guildConfig.GIT_REPOS_PR_SCANNED_CHANNELID.set((Object)answer);
            GHPRStatus.indexed_channels.add(answer);
            dMessage.apply(message.reply((CharSequence)"Set Channel")).queue();
            return CommandResult.PASS;
        }
        dMessage.apply(message.reply((CharSequence)"PR Scan Command Usage:\n``!prscan -add Org/Repo`` Adds a Repository\n``!prscan -remove Org/Repo`` Removes a Repository\n``!prscan -list`` Lists Indexed Repository\n``!prscan -setchannel`` Sets this as the current channel to list the pull requests\n")).queue();
        return CommandResult.PASS;
    }

    public String commandId() {
        return "prscan";
    }
}

