/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.github;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.mangorage.mangobot.MangoBotPlugin;
import org.mangorage.mangobot.config.GuildConfig;
import org.mangorage.mangobotapi.core.plugin.api.CorePlugin;

public class GHPRStatus
extends TimerTask {
    public static ArrayList<String> indexed_channels = new ArrayList();
    private final CorePlugin corePlugin;

    public static void save(int number, Path fileName) {
        try {
            File file = fileName.toFile();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                writer.write(Integer.toString(number));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int get(Path fileName) {
        int result = 0;
        File file = fileName.toFile();
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String line = reader.readLine();
                if (line != null) {
                    result = Integer.parseInt(line.trim());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public GHPRStatus(CorePlugin corePlugin) {
        this.corePlugin = corePlugin;
        new Timer().scheduleAtFixedRate((TimerTask)this, 15000L, 3600000L);
    }

    @Override
    public void run() {
        try {
            String token = (String)MangoBotPlugin.GITHUB_TOKEN.get();
            GitHub github = GitHub.connect((String)((String)MangoBotPlugin.GITHUB_USERNAME.get()), (String)token);
            for (String chan : indexed_channels) {
                String[] stringArray;
                String guild = this.corePlugin.getJDA().getTextChannelById(chan).getGuild().getId();
                GuildConfig config = GuildConfig.guildsConfig(guild);
                if (((String)config.GIT_REPOS_PR_SCANNED.get()).contains(",")) {
                    stringArray = ((String)config.GIT_REPOS_PR_SCANNED.get()).split(",");
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = (String)config.GIT_REPOS_PR_SCANNED.get();
                }
                String[] repos = stringArray;
                if (repos.length == 0) continue;
                int prs = 0;
                StringBuilder builder = new StringBuilder();
                for (String repo : repos) {
                    int lastChecked;
                    int number = lastChecked = GHPRStatus.get(this.getFile(repo));
                    GHRepository repository = github.getRepository(repo);
                    ArrayList<GHPullRequest> PRS = new ArrayList<GHPullRequest>(repository.getPullRequests(GHIssueState.OPEN).stream().filter(pr -> pr.getNumber() > lastChecked).toList());
                    if (PRS.isEmpty()) continue;
                    prs += PRS.size();
                    builder.append("New ").append(repo).append(" PR's: %s".formatted(PRS.size())).append("\n");
                    for (GHPullRequest PR : PRS) {
                        System.out.println(PR.getNumber());
                        if (PR.getNumber() > number) {
                            number = PR.getNumber();
                        }
                        builder.append("- %s [%s](%s)".formatted(PR.getTitle(), PR.getNumber(), PR.getHtmlUrl())).append("\n");
                    }
                    GHPRStatus.save(number, this.getFile(repo));
                }
                if (builder.isEmpty()) continue;
                TextChannel channel = this.corePlugin.getJDA().getTextChannelById(chan);
                if (channel == null) {
                    return;
                }
                ((MessageCreateAction)channel.sendMessage((CharSequence)builder).setSuppressEmbeds(true)).queue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Path getFile(String repo) {
        return this.corePlugin.getPluginDirectory().resolve("ghprstatus/" + repo.replace("/", ".") + ".txt");
    }
}

