/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.config;

import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import org.mangorage.basicutils.config.Config;
import org.mangorage.basicutils.config.ConfigSetting;
import org.mangorage.basicutils.config.ISetting;
import org.mangorage.mangobot.MangoBotPlugin;
import org.mangorage.mangobot.modules.github.GHIssueStatus;
import org.mangorage.mangobot.modules.github.GHPRStatus;

public class GuildConfig {
    public static HashMap<String, GuildConfig> configs = new HashMap();
    public final Config guildConfig;
    public final ISetting<String> GIT_REPOS_PR_SCANNED;
    public final ISetting<String> GIT_REPOS_PR_SCANNED_CHANNELID;
    public final ISetting<String> GIT_REPOS_ISSUE_SCANNED;
    public final ISetting<String> GIT_REPOS_ISSUE_SCANNED_CHANNELID;

    private GuildConfig(String guildID) {
        Path root = MangoBotPlugin.CONFIG.getFile().getParent();
        this.guildConfig = new Config(Path.of("%s/guildConfigs/%s/config.conf".formatted(root, guildID), new String[0]));
        this.GIT_REPOS_PR_SCANNED = ConfigSetting.create((Config)this.guildConfig, (String)"GIT_REPOS_PR_SCANNED", (String)"");
        this.GIT_REPOS_PR_SCANNED_CHANNELID = ConfigSetting.create((Config)this.guildConfig, (String)"GIT_REPOS_PR_SCANNED_CHANNELID", (String)"empty");
        this.GIT_REPOS_ISSUE_SCANNED = ConfigSetting.create((Config)this.guildConfig, (String)"GIT_REPOS_ISSUE_SCANNED", (String)"");
        this.GIT_REPOS_ISSUE_SCANNED_CHANNELID = ConfigSetting.create((Config)this.guildConfig, (String)"GIT_REPOS_ISSUE_SCANNED_CHANNELID", (String)"empty");
        configs.put(guildID, this);
        if (!((String)this.GIT_REPOS_PR_SCANNED_CHANNELID.get()).equals("empty")) {
            GHPRStatus.indexed_channels.add((String)this.GIT_REPOS_PR_SCANNED_CHANNELID.get());
        }
        if (!((String)this.GIT_REPOS_ISSUE_SCANNED_CHANNELID.get()).equals("empty")) {
            GHIssueStatus.indexed_channels.add((String)this.GIT_REPOS_ISSUE_SCANNED_CHANNELID.get());
        }
    }

    public static GuildConfig guildsConfig(String guildID) {
        if (configs.containsKey(guildID)) {
            return configs.get(guildID);
        }
        return new GuildConfig(guildID);
    }

    public static void loadServerConfigs() {
        Path root = MangoBotPlugin.CONFIG.getFile().getParent();
        File path = new File(String.valueOf(root) + "/guildConfigs/");
        if (path.exists()) {
            File[] listOfFiles = path.listFiles();
            if (listOfFiles != null) {
                for (File file : listOfFiles) {
                    if (!file.isDirectory()) continue;
                    GuildConfig.guildsConfig(file.getName());
                }
            }
        } else {
            System.out.println("No Guild Configs!");
        }
    }
}

