/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.mappings;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.dv8tion.jda.api.entities.Message;
import org.mangorage.basicutils.config.ISetting;
import org.mangorage.mangobot.modules.mappings.Mappings;

public class MappingsManager {
    public Mappings SRG;
    public Mappings SUGARCANE;
    public Mappings YARN;
    public Mappings FABRIC_INTERMEDIARY;

    public static MappingsManager new_() {
        return new MappingsManager();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] download(URL url) {
        try {
            URLConnection connection = url.openConnection();
            try (InputStream inputStream = connection.getInputStream();){
                byte[] byArray;
                try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                    byte[] fileContents;
                    int length;
                    byte[] buffer = new byte[1024];
                    while ((length = inputStream.read(buffer)) != -1) {
                        outputStream.write(buffer, 0, length);
                    }
                    byArray = fileContents = outputStream.toByteArray();
                }
                return byArray;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    private String get_mappings() {
        String latest = "";
        System.out.println("Checking for latest version of Mappings and Downloading them");
        try {
            String version;
            URL version_url = new URL("https://pagure.io/FeatureCreep/featurecreep-moderation-bot/raw/main/f/mappings/latest");
            latest = version = new String(this.download(version_url), StandardCharsets.UTF_8);
            String mc_version = version.split("-")[0];
            File dir = new File("mappings/" + mc_version + "/");
            dir.mkdirs();
            URL url = new URL("https://pagure.io/FeatureCreep/featurecreep-moderation-bot/raw/main/f/mappings/" + mc_version + "/todos.zip");
            byte[] zip = this.download(url);
            try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zip));){
                ZipEntry entry = zis.getNextEntry();
                while (entry != null) {
                    String fileName = entry.getName();
                    File file = new File(String.valueOf(dir) + "/" + fileName);
                    if (entry.isDirectory()) {
                        file.mkdirs();
                    } else {
                        file.getParentFile().mkdirs();
                        try (FileOutputStream fos = new FileOutputStream(file);){
                            int len;
                            byte[] buffer = new byte[1024];
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                        }
                    }
                    zis.closeEntry();
                    entry = zis.getNextEntry();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return latest;
    }

    private String checkForUpdates(ISetting<String> conf) {
        System.out.println("Checking for Mapping Updates");
        try {
            URL version_url = new URL("https://pagure.io/FeatureCreep/featurecreep-moderation-bot/raw/main/f/mappings/latest");
            Path version_path = Paths.get(version_url.toURI());
            String version = new String(Files.readAllBytes(version_path), StandardCharsets.UTF_8);
            if (version.compareTo((String)conf.get()) > 0) {
                System.out.println("Mapping update found. Downloading");
                return this.get_mappings();
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
        return (String)conf.get();
    }

    public void init(ISetting<String> conf) {
        String latest;
        if (((String)conf.get()).equals("empty")) {
            latest = this.get_mappings().split("-")[0];
            conf.set((Object)latest);
        } else {
            String current = ((String)conf.get()).split("-")[0];
            latest = (String)conf.get();
        }
        try {
            System.out.println("Version -> %s".formatted(latest));
            this.SRG = new Mappings(new FileInputStream(new File("mappings/" + latest + "/srg.pdme")));
            this.SUGARCANE = new Mappings(new FileInputStream(new File("mappings/" + latest + "/sugarcane.pdme")));
            this.YARN = new Mappings(new FileInputStream(new File("mappings/" + latest + "/yarn.pdme")));
            this.FABRIC_INTERMEDIARY = new Mappings(new FileInputStream(new File("mappings/" + latest + "/fabric-intermediary.pdme")));
        }
        catch (FileNotFoundException e) {
            this.SRG = new Mappings();
            this.SUGARCANE = new Mappings();
            this.YARN = new Mappings();
            this.FABRIC_INTERMEDIARY = new Mappings();
            this.SRG.reverse = new Mappings();
            this.SUGARCANE.reverse = new Mappings();
            this.YARN.reverse = new Mappings();
            this.FABRIC_INTERMEDIARY.reverse = new Mappings();
            e.printStackTrace(System.out);
        }
    }

    public Mappings getSRG() {
        return this.SRG;
    }

    public Mappings getSUGARCANE() {
        return this.SUGARCANE;
    }

    public Mappings getYARN() {
        return this.YARN;
    }

    public Mappings getFABRIC_INTERMEDIARY() {
        return this.FABRIC_INTERMEDIARY;
    }

    public String fciclassfind(String fciName) {
        fciName = fciName.replace("/", ".");
        boolean isPackage = fciName.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<CallSite> outputs = new ArrayList<CallSite>();
        if (isPackage && this.FABRIC_INTERMEDIARY.reverse.classes.containsKey(fciName)) {
            targets.add(fciName);
        } else {
            for (Map.Entry<String, String> entry : this.FABRIC_INTERMEDIARY.classes.entrySet()) {
                if (!entry.getValue().contains(fciName)) continue;
                targets.add(entry.getValue());
            }
        }
        for (String target : targets) {
            String output = "FeatureCreep Intermediary: `" + target + "`\n";
            if (this.SUGARCANE.reverse.classes.containsKey(target)) {
                String sugarcaneOutput = this.SUGARCANE.reverse.getClassMappedName(target);
                output = output + "MojMap: `" + sugarcaneOutput + "`\n";
            }
            if (this.YARN.reverse.classes.containsKey(target)) {
                String yarnOutput = this.YARN.reverse.getClassMappedName(target);
                output = output + "Yarn: `" + yarnOutput + "`\n";
            }
            if (this.SRG.reverse.classes.containsKey(target)) {
                String srgOutput = this.SRG.reverse.getClassMappedName(target);
                output = output + "SRG: `" + srgOutput + "`\n";
            }
            if (this.FABRIC_INTERMEDIARY.reverse.classes.containsKey(target)) {
                String fainOutput = this.FABRIC_INTERMEDIARY.reverse.getClassMappedName(target);
                output = output + "Fabric Intermediary: `" + fainOutput + "`\n";
            }
            outputs.add((CallSite)((Object)output));
        }
        if (outputs.isEmpty()) {
            String out = "No class mapping found for " + fciName + ". Make sure it's in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
            return out;
        }
        String result = String.join((CharSequence)"\n", outputs);
        if (result.length() > 2000) {
            result = "Output too long. Please Narrow your Search";
        }
        return result;
    }

    public String srgclassfind(String srg_name) {
        srg_name = srg_name.replace("/", ".");
        boolean pack = srg_name.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<CallSite> outputs = new ArrayList<CallSite>();
        if (pack && this.SRG.classes.containsKey(srg_name)) {
            targets.add(srg_name);
        } else {
            for (Map.Entry<String, String> entry : this.SRG.classes.entrySet()) {
                if (!entry.getKey().contains(srg_name)) continue;
                targets.add(entry.getKey());
            }
        }
        for (String target : targets) {
            String output = "**SRG:** `" + target + "`\n";
            if (this.SRG.classes.containsKey(target)) {
                String fci_output = this.SRG.getClassMappedName(target);
                output = output + "**FeatureCreep Intermediary:** `" + fci_output + "`\n";
                if (this.SUGARCANE.reverse.classes.containsKey(fci_output)) {
                    String sugarcane_output = this.SUGARCANE.reverse.getClassMappedName(fci_output);
                    output = output + "**MojMap:** `" + sugarcane_output + "`\n";
                }
                if (this.YARN.reverse.classes.containsKey(fci_output)) {
                    String yarn_output = this.YARN.reverse.getClassMappedName(fci_output);
                    output = output + "**Yarn:** `" + yarn_output + "`\n";
                }
                if (this.FABRIC_INTERMEDIARY.reverse.classes.containsKey(fci_output)) {
                    String fain_output = this.FABRIC_INTERMEDIARY.reverse.getClassMappedName(fci_output);
                    output = output + "**Fabric Intermediary:** `" + fain_output + "`\n";
                }
            }
            outputs.add((CallSite)((Object)output));
        }
        if (outputs.isEmpty()) {
            return "No class mapping found for " + srg_name + ". Make sure it's in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        }
        return String.join((CharSequence)"\n", outputs);
    }

    public String yarnclassfind(String yarn_name) {
        yarn_name = yarn_name.replace("/", ".");
        boolean pack = yarn_name.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<CallSite> outputs = new ArrayList<CallSite>();
        if (pack && this.YARN.classes.containsKey(yarn_name)) {
            targets.add(yarn_name);
        } else {
            for (Map.Entry<String, String> entry : this.YARN.classes.entrySet()) {
                if (!entry.getKey().contains(yarn_name)) continue;
                targets.add(entry.getKey());
            }
        }
        for (String target : targets) {
            String output = "**Yarn:** `" + target + "`\n";
            if (this.YARN.classes.containsKey(target)) {
                String fci_output = this.YARN.getClassMappedName(target);
                output = output + "**FeatureCreep Intermediary:** `" + fci_output + "`\n";
                if (this.SUGARCANE.reverse.classes.containsKey(fci_output)) {
                    String sugarcane_output = this.SUGARCANE.reverse.getClassMappedName(fci_output);
                    output = output + "**MojMap:** `" + sugarcane_output + "`\n";
                }
                if (this.SRG.reverse.classes.containsKey(fci_output)) {
                    String yarn_output = this.SRG.reverse.getClassMappedName(fci_output);
                    output = output + "**SRG:** `" + yarn_output + "`\n";
                }
                if (this.FABRIC_INTERMEDIARY.reverse.classes.containsKey(fci_output)) {
                    String fain_output = this.FABRIC_INTERMEDIARY.reverse.getClassMappedName(fci_output);
                    output = output + "**Fabric Intermediary:** `" + fain_output + "`\n";
                }
            }
            outputs.add((CallSite)((Object)output));
        }
        if (outputs.isEmpty()) {
            return "No class mapping found for " + yarn_name + ". Make sure it's in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        }
        return String.join((CharSequence)"\n", outputs);
    }

    public String sugarcaneclassfind(String moj_name) {
        moj_name = moj_name.replace("/", ".");
        boolean pack = moj_name.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<CallSite> outputs = new ArrayList<CallSite>();
        if (pack && this.SUGARCANE.classes.containsKey(moj_name)) {
            targets.add(moj_name);
        } else {
            for (Map.Entry<String, String> entry : this.SUGARCANE.classes.entrySet()) {
                if (!entry.getKey().contains(moj_name)) continue;
                targets.add(entry.getKey());
            }
        }
        for (String target : targets) {
            String output = "**MojMap:** `" + target + "`\n";
            if (this.SUGARCANE.classes.containsKey(target)) {
                String fci_output = this.SUGARCANE.getClassMappedName(target);
                output = output + "**FeatureCreep Intermediary:** `" + fci_output + "`\n";
                if (this.YARN.reverse.classes.containsKey(fci_output)) {
                    String sugarcane_output = this.YARN.reverse.getClassMappedName(fci_output);
                    output = output + "**Yarn:** `" + sugarcane_output + "`\n";
                }
                if (this.SRG.reverse.classes.containsKey(fci_output)) {
                    String yarn_output = this.SRG.reverse.getClassMappedName(fci_output);
                    output = output + "**SRG:** `" + yarn_output + "`\n";
                }
                if (this.FABRIC_INTERMEDIARY.reverse.classes.containsKey(fci_output)) {
                    String fain_output = this.FABRIC_INTERMEDIARY.reverse.getClassMappedName(fci_output);
                    output = output + "**Fabric Intermediary:** `" + fain_output + "`\n";
                }
            }
            outputs.add((CallSite)((Object)output));
        }
        if (outputs.isEmpty()) {
            return "No class mapping found for " + moj_name + ". Make sure it's in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        }
        return String.join((CharSequence)"\n", outputs);
    }

    public String fainclassfind(String fain_name) {
        fain_name = fain_name.replace("/", ".");
        boolean pack = fain_name.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<CallSite> outputs = new ArrayList<CallSite>();
        if (pack && this.FABRIC_INTERMEDIARY.classes.containsKey(fain_name)) {
            targets.add(fain_name);
        } else {
            for (Map.Entry<String, String> entry : this.FABRIC_INTERMEDIARY.classes.entrySet()) {
                if (!entry.getKey().contains(fain_name)) continue;
                targets.add(entry.getKey());
            }
        }
        for (String target : targets) {
            String output = "**Fabric Intermediary:** `" + target + "`\n";
            if (this.FABRIC_INTERMEDIARY.classes.containsKey(target)) {
                String fci_output = this.FABRIC_INTERMEDIARY.getClassMappedName(target);
                output = output + "**FeatureCreep Intermediary:** `" + fci_output + "`\n";
                if (this.SUGARCANE.reverse.classes.containsKey(fci_output)) {
                    String sugarcane_output = this.SUGARCANE.reverse.getClassMappedName(fci_output);
                    output = output + "**MojMap:** `" + sugarcane_output + "`\n";
                }
                if (this.SRG.reverse.classes.containsKey(fci_output)) {
                    String yarn_output = this.SRG.reverse.getClassMappedName(fci_output);
                    output = output + "**SRG:** `" + yarn_output + "`\n";
                }
                if (this.YARN.reverse.classes.containsKey(fci_output)) {
                    String fain_output = this.YARN.reverse.getClassMappedName(fci_output);
                    output = output + "**Yarn:** `" + fain_output + "`\n";
                }
            }
            outputs.add((CallSite)((Object)output));
        }
        if (outputs.isEmpty()) {
            return "No class mapping found for " + fain_name + ". Make sure it's in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        }
        return String.join((CharSequence)"\n", outputs);
    }

    public String srgdeffind(String srg_name) {
        Object out;
        boolean pack = srg_name.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<String> outputs = new ArrayList<String>();
        if (pack && this.SRG.defs.containsKey(srg_name)) {
            targets.add(srg_name);
        } else {
            for (Map.Entry<String, String> entry : this.SRG.defs.entrySet()) {
                if (!entry.getKey().contains(srg_name)) continue;
                targets.add(entry.getKey());
            }
        }
        for (String target : targets) {
            StringBuilder output = new StringBuilder("**SRG:** `" + target + "`\n");
            if (this.SRG.defs.containsKey(target)) {
                String desc_temp;
                String old_desc_temp;
                Object fci_output = this.SRG.getDefMappedName(target);
                String[] old_clazz_old = target.split("\\.");
                CharSequence[] old_clazz = Arrays.copyOf(old_clazz_old, old_clazz_old.length - 1);
                String clazz = this.SRG.getClassMappedName(String.join((CharSequence)".", old_clazz));
                String old_desc = target.split("\\(")[1];
                String desc = this.SRG.renameClassesInMethodDescriptor(old_desc);
                fci_output = (String)fci_output + "(" + desc;
                output.append("**FeatureCreep Intermediary:** `" + (String)fci_output + "`\n");
                String fci_output_temp = clazz + "." + (String)fci_output;
                if (this.SUGARCANE.reverse.defs.containsKey(fci_output_temp)) {
                    String sugarcane_output = this.SUGARCANE.reverse.getDefMappedName(fci_output_temp);
                    old_desc_temp = fci_output_temp.split("\\(")[1];
                    desc_temp = this.SUGARCANE.reverse.renameClassesInMethodDescriptor(old_desc_temp);
                    output.append("**MojMap:** `" + sugarcane_output + "(" + desc_temp + "`\n");
                }
                if (this.YARN.reverse.defs.containsKey(fci_output_temp)) {
                    String yarn_output = this.YARN.reverse.getDefMappedName(fci_output_temp);
                    old_desc_temp = fci_output_temp.split("\\(")[1];
                    desc_temp = this.YARN.reverse.renameClassesInMethodDescriptor(old_desc_temp);
                    output.append("**Yarn:** `" + yarn_output + "(" + desc_temp + "`\n");
                }
                if (this.FABRIC_INTERMEDIARY.reverse.defs.containsKey(fci_output_temp)) {
                    String fain_output = this.FABRIC_INTERMEDIARY.reverse.getDefMappedName(fci_output_temp);
                    old_desc_temp = fci_output_temp.split("\\(")[1];
                    desc_temp = this.FABRIC_INTERMEDIARY.reverse.renameClassesInMethodDescriptor(old_desc_temp);
                    output.append("**Fabric Intermediary:** `" + fain_output + "(" + desc_temp + "`\n");
                }
                HashMap<String, String> args = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : this.SRG.params.entrySet()) {
                    if (!entry.getKey().contains(target)) continue;
                    String name = entry.getValue();
                    String loc = entry.getKey().split("_")[entry.getKey().split("_").length - 1];
                    args.put(loc, name);
                }
                if (!args.isEmpty()) {
                    output.append("**FCI Args:** `" + args.toString() + "`\n");
                }
            }
            outputs.add(output.toString());
        }
        if (outputs.isEmpty()) {
            out = "No mapping found for " + srg_name + ". Make sure its in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        } else {
            out = String.join((CharSequence)"\n", outputs);
            if (((String)out).length() > 2000) {
                out = "Output too long. Please Narrow your Search. If the name is short and you have the full name but not descriptor add ( to the end";
            }
        }
        return out;
    }

    public String sugarcanedeffind(String moj_name) {
        Object out;
        boolean pack = moj_name.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<String> outputs = new ArrayList<String>();
        if (pack && this.SUGARCANE.defs.containsKey(moj_name)) {
            targets.add(moj_name);
        } else {
            for (Map.Entry<String, String> entry : this.SUGARCANE.defs.entrySet()) {
                if (!entry.getKey().contains(moj_name)) continue;
                targets.add(entry.getKey());
            }
        }
        for (String target : targets) {
            StringBuilder output = new StringBuilder("**MojMap:** `" + target + "`\n");
            if (this.SUGARCANE.defs.containsKey(target)) {
                String desc_temp;
                String old_desc_temp;
                Object fci_output = this.SUGARCANE.getDefMappedName(target);
                String[] old_clazz_old = target.split("\\.");
                CharSequence[] old_clazz = Arrays.copyOf(old_clazz_old, old_clazz_old.length - 1);
                String clazz = this.SUGARCANE.getClassMappedName(String.join((CharSequence)".", old_clazz));
                String old_desc = target.split("\\(")[1];
                String desc = this.SUGARCANE.renameClassesInMethodDescriptor(old_desc);
                fci_output = (String)fci_output + "(" + desc;
                output.append("**FeatureCreep Intermediary:** `" + (String)fci_output + "`\n");
                String fci_output_temp = clazz + "." + (String)fci_output;
                if (this.SRG.reverse.defs.containsKey(fci_output_temp)) {
                    String sugarcane_output = this.SRG.reverse.getDefMappedName(fci_output_temp);
                    old_desc_temp = fci_output_temp.split("\\(")[1];
                    desc_temp = this.SRG.reverse.renameClassesInMethodDescriptor(old_desc_temp);
                    output.append("**SRG:** `" + sugarcane_output + "(" + desc_temp + "`\n");
                }
                if (this.YARN.reverse.defs.containsKey(fci_output_temp)) {
                    String yarn_output = this.YARN.reverse.getDefMappedName(fci_output_temp);
                    old_desc_temp = fci_output_temp.split("\\(")[1];
                    desc_temp = this.YARN.reverse.renameClassesInMethodDescriptor(old_desc_temp);
                    output.append("**Yarn:** `" + yarn_output + "(" + desc_temp + "`\n");
                }
                if (this.FABRIC_INTERMEDIARY.reverse.defs.containsKey(fci_output_temp)) {
                    String fain_output = this.FABRIC_INTERMEDIARY.reverse.getDefMappedName(fci_output_temp);
                    old_desc_temp = fci_output_temp.split("\\(")[1];
                    desc_temp = this.FABRIC_INTERMEDIARY.reverse.renameClassesInMethodDescriptor(old_desc_temp);
                    output.append("**Fabric Intermediary:** `" + fain_output + "(" + desc_temp + "`\n");
                }
                HashMap<String, String> args = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : this.SUGARCANE.params.entrySet()) {
                    if (!entry.getKey().contains(target)) continue;
                    String name = entry.getValue();
                    String loc = entry.getKey().split("_")[entry.getKey().split("_").length - 1];
                    args.put(loc, name);
                }
                if (!args.isEmpty()) {
                    output.append("**FCI Args:** `" + args.toString() + "`\n");
                }
            }
            outputs.add(output.toString());
        }
        if (outputs.isEmpty()) {
            out = "No mapping found for " + moj_name + ". Make sure its in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        } else {
            out = String.join((CharSequence)"\n", outputs);
            if (((String)out).length() > 2000) {
                out = "Output too long. Please Narrow your Search. If the name is short and you have the full name but not descriptor add ( to the end";
            }
        }
        return out;
    }

    public String faindeffind(String fain_name) {
        Object out;
        boolean pack = fain_name.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<String> outputs = new ArrayList<String>();
        if (pack && this.SRG.defs.containsKey(fain_name)) {
            targets.add(fain_name);
        } else {
            for (Map.Entry<String, String> entry : this.FABRIC_INTERMEDIARY.defs.entrySet()) {
                if (!entry.getKey().contains(fain_name)) continue;
                targets.add(entry.getKey());
            }
        }
        for (String target : targets) {
            StringBuilder output = new StringBuilder("**Fabric Intermediary:** `" + target + "`\n");
            if (this.FABRIC_INTERMEDIARY.defs.containsKey(target)) {
                String desc_temp;
                String old_desc_temp;
                Object fci_output = this.FABRIC_INTERMEDIARY.getDefMappedName(target);
                String[] old_clazz_old = target.split("\\.");
                CharSequence[] old_clazz = Arrays.copyOf(old_clazz_old, old_clazz_old.length - 1);
                String clazz = this.FABRIC_INTERMEDIARY.getClassMappedName(String.join((CharSequence)".", old_clazz));
                String old_desc = target.split("\\(")[1];
                String desc = this.FABRIC_INTERMEDIARY.renameClassesInMethodDescriptor(old_desc);
                fci_output = (String)fci_output + "(" + desc;
                output.append("**FeatureCreep Intermediary:** `" + (String)fci_output + "`\n");
                String fci_output_temp = clazz + "." + (String)fci_output;
                if (this.SUGARCANE.reverse.defs.containsKey(fci_output_temp)) {
                    String sugarcane_output = this.SUGARCANE.reverse.getDefMappedName(fci_output_temp);
                    old_desc_temp = fci_output_temp.split("\\(")[1];
                    desc_temp = this.SUGARCANE.reverse.renameClassesInMethodDescriptor(old_desc_temp);
                    output.append("**MojMap:** `" + sugarcane_output + "(" + desc_temp + "`\n");
                }
                if (this.YARN.reverse.defs.containsKey(fci_output_temp)) {
                    String yarn_output = this.YARN.reverse.getDefMappedName(fci_output_temp);
                    old_desc_temp = fci_output_temp.split("\\(")[1];
                    desc_temp = this.YARN.reverse.renameClassesInMethodDescriptor(old_desc_temp);
                    output.append("**Yarn:** `" + yarn_output + "(" + desc_temp + "`\n");
                }
                if (this.SRG.reverse.defs.containsKey(fci_output_temp)) {
                    String fain_output = this.SRG.reverse.getDefMappedName(fci_output_temp);
                    old_desc_temp = fci_output_temp.split("\\(")[1];
                    desc_temp = this.SRG.reverse.renameClassesInMethodDescriptor(old_desc_temp);
                    output.append("**SRG:** `" + fain_output + "(" + desc_temp + "`\n");
                }
                HashMap<String, String> args = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : this.FABRIC_INTERMEDIARY.params.entrySet()) {
                    if (!entry.getKey().contains(target)) continue;
                    String name = entry.getValue();
                    String loc = entry.getKey().split("_")[entry.getKey().split("_").length - 1];
                    args.put(loc, name);
                }
                if (!args.isEmpty()) {
                    output.append("**FCI Args:** `" + args.toString() + "`\n");
                }
            }
            outputs.add(output.toString());
        }
        if (outputs.isEmpty()) {
            out = "No mapping found for " + fain_name + ". Make sure its in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        } else {
            out = String.join((CharSequence)"\n", outputs);
            if (((String)out).length() > 2000) {
                out = "Output too long. Please Narrow your Search. If the name is short and you have the full name but not descriptor add ( to the end";
            }
        }
        return out;
    }

    public String yarndeffind(String yarn_name) {
        Object out;
        boolean pack = yarn_name.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<String> outputs = new ArrayList<String>();
        if (pack && this.YARN.defs.containsKey(yarn_name)) {
            targets.add(yarn_name);
        } else {
            for (Map.Entry<String, String> entry : this.YARN.defs.entrySet()) {
                if (!entry.getKey().contains(yarn_name)) continue;
                targets.add(entry.getKey());
            }
        }
        for (String target : targets) {
            StringBuilder output = new StringBuilder("**Yarn:** `" + target + "`\n");
            if (this.YARN.defs.containsKey(target)) {
                String desc_temp;
                String old_desc_temp;
                Object fci_output = this.YARN.getDefMappedName(target);
                String[] old_clazz_old = target.split("\\.");
                CharSequence[] old_clazz = Arrays.copyOf(old_clazz_old, old_clazz_old.length - 1);
                String clazz = this.YARN.getClassMappedName(String.join((CharSequence)".", old_clazz));
                String old_desc = target.split("\\(")[1];
                String desc = this.YARN.renameClassesInMethodDescriptor(old_desc);
                fci_output = (String)fci_output + "(" + desc;
                output.append("**FeatureCreep Intermediary:** `" + (String)fci_output + "`\n");
                String fci_output_temp = clazz + "." + (String)fci_output;
                if (this.SRG.reverse.defs.containsKey(fci_output_temp)) {
                    String sugarcane_output = this.SRG.reverse.getDefMappedName(fci_output_temp);
                    old_desc_temp = fci_output_temp.split("\\(")[1];
                    desc_temp = this.SRG.reverse.renameClassesInMethodDescriptor(old_desc_temp);
                    output.append("**SRG:** `" + sugarcane_output + "(" + desc_temp + "`\n");
                }
                if (this.SUGARCANE.reverse.defs.containsKey(fci_output_temp)) {
                    String yarn_output = this.SUGARCANE.reverse.getDefMappedName(fci_output_temp);
                    old_desc_temp = fci_output_temp.split("\\(")[1];
                    desc_temp = this.SUGARCANE.reverse.renameClassesInMethodDescriptor(old_desc_temp);
                    output.append("**MojMap:** `" + yarn_output + "(" + desc_temp + "`\n");
                }
                if (this.FABRIC_INTERMEDIARY.reverse.defs.containsKey(fci_output_temp)) {
                    String fain_output = this.FABRIC_INTERMEDIARY.reverse.getDefMappedName(fci_output_temp);
                    old_desc_temp = fci_output_temp.split("\\(")[1];
                    desc_temp = this.FABRIC_INTERMEDIARY.reverse.renameClassesInMethodDescriptor(old_desc_temp);
                    output.append("**Fabric Intermediary:** `" + fain_output + "(" + desc_temp + "`\n");
                }
                HashMap<String, String> args = new HashMap<String, String>();
                for (Map.Entry<String, String> entry : this.YARN.params.entrySet()) {
                    if (!entry.getKey().contains(target)) continue;
                    String name = entry.getValue();
                    String loc = entry.getKey().split("_")[entry.getKey().split("_").length - 1];
                    args.put(loc, name);
                }
                if (!args.isEmpty()) {
                    output.append("**FCI Args:** `" + args.toString() + "`\n");
                }
            }
            outputs.add(output.toString());
        }
        if (outputs.isEmpty()) {
            out = "No mapping found for " + yarn_name + ". Make sure its in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        } else {
            out = String.join((CharSequence)"\n", outputs);
            if (((String)out).length() > 2000) {
                out = "Output too long. Please Narrow your Search. If the name is short and you have the full name but not descriptor add ( to the end";
            }
        }
        return out;
    }

    public String fcideffind(String fci_name) {
        boolean pack = fci_name.contains("(");
        ArrayList<Object> targets = new ArrayList<Object>();
        ArrayList<CallSite> outputs = new ArrayList<CallSite>();
        if (pack && this.FABRIC_INTERMEDIARY.reverse.defs.containsKey(fci_name)) {
            targets.add(fci_name);
        } else {
            for (Map.Entry<String, String> entry : this.FABRIC_INTERMEDIARY.defs.entrySet()) {
                if (!entry.getValue().contains(fci_name)) continue;
                String[] splitKeys = entry.getKey().split("\\.");
                String old_clazz = String.join((CharSequence)".", Arrays.copyOfRange(splitKeys, 0, splitKeys.length - 1));
                String clazz = this.FABRIC_INTERMEDIARY.getClassMappedName(old_clazz);
                String old_desc = "(" + entry.getKey().split("\\(")[1];
                String desc = this.FABRIC_INTERMEDIARY.renameClassesInMethodDescriptor(old_desc);
                targets.add(clazz + "." + entry.getValue() + desc);
            }
        }
        for (String string : targets) {
            String desc;
            String old_desc;
            String output = "**FeatureCreep Intermediary:** `" + string + "`\n";
            if (this.SUGARCANE.reverse.defs.containsKey(string)) {
                String sugarcane_output = this.SUGARCANE.reverse.getDefMappedName(string);
                old_desc = "(" + string.split("\\(")[1];
                desc = this.SUGARCANE.reverse.renameClassesInMethodDescriptor(old_desc);
                output = output + "**MojMap:** `" + sugarcane_output + desc + "`\n";
            }
            if (this.YARN.reverse.defs.containsKey(string)) {
                String yarn_output = this.YARN.reverse.getDefMappedName(string);
                old_desc = "(" + string.split("\\(")[1];
                desc = this.YARN.reverse.renameClassesInMethodDescriptor(old_desc);
                output = output + "**Yarn:** `" + yarn_output + "(" + desc + "`\n";
            }
            if (this.SRG.reverse.defs.containsKey(string)) {
                String srg_output = this.SRG.reverse.getDefMappedName(string);
                old_desc = "(" + string.split("\\(")[1];
                desc = this.SRG.reverse.renameClassesInMethodDescriptor(old_desc);
                output = output + "**SRG:** `" + srg_output + "(" + desc + "`\n";
            }
            if (this.FABRIC_INTERMEDIARY.reverse.defs.containsKey(string)) {
                String fain_output = this.FABRIC_INTERMEDIARY.reverse.getDefMappedName(string);
                old_desc = "(" + string.split("\\(")[1];
                desc = this.FABRIC_INTERMEDIARY.reverse.renameClassesInMethodDescriptor(old_desc);
                output = output + "**Fabric Intermediary:** `" + fain_output + "(" + desc + "`\n";
            }
            HashMap<String, String> args = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : this.FABRIC_INTERMEDIARY.params.entrySet()) {
                if (!entry.getKey().contains(this.FABRIC_INTERMEDIARY.reverse.getDefMappedName(string))) continue;
                String name = entry.getValue();
                String loc = entry.getKey().split("_")[1];
                args.put(loc, name);
            }
            if (!args.isEmpty()) {
                output = output + "**FCI Args:** `" + ((Object)args).toString() + "`\n";
            }
            outputs.add((CallSite)((Object)output));
        }
        Object out = "";
        if (outputs.isEmpty()) {
            out = "No mapping found for " + fci_name + ". Make sure its in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        } else {
            out = String.join((CharSequence)"\n", outputs);
            if (((String)out).length() > 2000) {
                out = "Output too long. Please Narrow your Search. If the name is short and you have the full name but not descriptor add ( to the end";
            }
        }
        return out;
    }

    public String fcivarfind(String fciName) {
        Object out;
        ArrayList<CallSite> targets = new ArrayList<CallSite>();
        ArrayList<CallSite> outputs = new ArrayList<CallSite>();
        for (Map.Entry<String, String> entry : this.FABRIC_INTERMEDIARY.vars.entrySet()) {
            if (!entry.getValue().contains(fciName)) continue;
            String[] splitKeys = entry.getKey().split("\\.");
            String old_clazz = String.join((CharSequence)".", Arrays.copyOfRange(splitKeys, 0, splitKeys.length - 1));
            String clazz = this.FABRIC_INTERMEDIARY.getClassMappedName(old_clazz);
            String oldDesc = entry.getKey().split(":")[1];
            String desc = this.FABRIC_INTERMEDIARY.renameClassesInFieldDescriptor(oldDesc);
            targets.add((CallSite)((Object)(clazz + "." + entry.getValue() + ":" + desc)));
        }
        for (String string : targets) {
            String desc;
            String oldDesc;
            String output = "**FeatureCreep Intermediary:** `" + string + "`\n";
            if (this.SUGARCANE.reverse.vars.containsKey(string)) {
                String sugarcaneOutput = this.SUGARCANE.reverse.getVarMappedName(string);
                oldDesc = ":" + string.split(":")[1];
                desc = this.SUGARCANE.reverse.renameClassesInFieldDescriptor(oldDesc);
                output = output + "**MojMap:** `" + sugarcaneOutput + desc + "`\n";
            }
            if (this.YARN.reverse.vars.containsKey(string)) {
                String yarnOutput = this.YARN.reverse.getVarMappedName(string);
                oldDesc = ":" + string.split(":")[1];
                desc = this.YARN.reverse.renameClassesInFieldDescriptor(oldDesc);
                output = output + "**Yarn:** `" + yarnOutput + desc + "`\n";
            }
            if (this.SRG.reverse.vars.containsKey(string)) {
                String srgOutput = this.SRG.reverse.getVarMappedName(string);
                oldDesc = ":" + string.split(":")[1];
                desc = this.SRG.reverse.renameClassesInFieldDescriptor(oldDesc);
                output = output + "**SRG:** `" + srgOutput + desc + "`\n";
            }
            if (this.FABRIC_INTERMEDIARY.reverse.vars.containsKey(string)) {
                String fainOutput = this.FABRIC_INTERMEDIARY.reverse.getVarMappedName(string);
                oldDesc = ":" + string.split(":")[1];
                desc = this.FABRIC_INTERMEDIARY.reverse.renameClassesInFieldDescriptor(oldDesc);
                output = output + "**Fabric Intermediary:** `" + fainOutput + desc + "`\n";
            }
            outputs.add((CallSite)((Object)output));
        }
        if (outputs.isEmpty()) {
            out = "No mapping found for " + fciName + ". Make sure its in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        } else {
            out = String.join((CharSequence)"\n", outputs);
            if (((String)out).length() > 2000) {
                out = "Output too long. Please Narrow your Search. If the name is short and you have the full name but not descriptor add : to the end";
            }
        }
        return out;
    }

    public String yarnvarfind(String yarn_name) {
        Object out;
        boolean pack = yarn_name.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<CallSite> outputs = new ArrayList<CallSite>();
        if (pack && this.YARN.vars.containsKey(yarn_name)) {
            targets.add(yarn_name);
        } else {
            for (Map.Entry<String, String> entry : this.YARN.vars.entrySet()) {
                if (!entry.getKey().contains(yarn_name)) continue;
                targets.add(entry.getKey());
            }
        }
        for (String target : targets) {
            String output = "**Yarn:** `" + target + "`\n";
            if (this.YARN.vars.containsKey(target)) {
                Object fci_output = this.YARN.getVarMappedName(target);
                String[] old_clazz_split = target.split("\\.");
                String old_clazz = String.join((CharSequence)".", Arrays.copyOfRange(old_clazz_split, 0, old_clazz_split.length - 1));
                String clazz = this.YARN.getClassMappedName(old_clazz);
                String[] old_desc_split = target.split(":");
                String old_desc = old_desc_split[1];
                String desc = this.YARN.renameClassesInFieldDescriptor(old_desc);
                fci_output = (String)fci_output + ":" + desc;
                output = output + "**FeatureCreep Intermediary:** `" + (String)fci_output + "`\n";
                if (this.SUGARCANE.reverse.vars.containsKey(fci_output = clazz + "." + (String)fci_output)) {
                    String sugarcane_output = this.SUGARCANE.reverse.getVarMappedName((String)fci_output);
                    String[] old_desc_split2 = ((String)fci_output).split(":");
                    String old_desc2 = old_desc_split2[1];
                    String desc2 = this.SUGARCANE.reverse.renameClassesInFieldDescriptor(old_desc2);
                    output = output + "**MojMap:** `" + sugarcane_output + desc2 + "`\n";
                }
                if (this.SRG.reverse.vars.containsKey(fci_output)) {
                    String yarn_output = this.SRG.reverse.getVarMappedName((String)fci_output);
                    String[] old_desc_split3 = ((String)fci_output).split(":");
                    String old_desc3 = old_desc_split3[1];
                    String desc3 = this.SRG.reverse.renameClassesInFieldDescriptor(old_desc3);
                    output = output + "**SRG:** `" + yarn_output + desc3 + "`\n";
                }
                if (this.FABRIC_INTERMEDIARY.reverse.vars.containsKey(fci_output)) {
                    String fain_output = this.FABRIC_INTERMEDIARY.reverse.getVarMappedName((String)fci_output);
                    String[] old_desc_split4 = ((String)fci_output).split(":");
                    String old_desc4 = old_desc_split4[1];
                    String desc4 = this.FABRIC_INTERMEDIARY.reverse.renameClassesInFieldDescriptor(old_desc4);
                    output = output + "**Fabric Intermediary:** `" + fain_output + desc4 + "`\n";
                }
            }
            outputs.add((CallSite)((Object)output));
        }
        if (outputs.isEmpty()) {
            out = "No mapping found for " + yarn_name + ". Make sure its in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        } else {
            out = String.join((CharSequence)"\n", outputs);
            if (((String)out).length() > 2000) {
                out = "Output too long. Please Narrow your Search. If the name is short and you have the full name but not descriptor add : to the end";
            }
        }
        return out;
    }

    public String srgvarfind(String srg_name) {
        Object out;
        boolean pack = srg_name.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<CallSite> outputs = new ArrayList<CallSite>();
        if (pack && this.SRG.vars.containsKey(srg_name)) {
            targets.add(srg_name);
        } else {
            for (Map.Entry<String, String> entry : this.SRG.vars.entrySet()) {
                if (!entry.getKey().contains(srg_name)) continue;
                targets.add(entry.getKey());
            }
        }
        for (String target : targets) {
            String output = "**SRG:** `" + target + "`\n";
            if (this.SRG.vars.containsKey(target)) {
                Object fci_output = this.SRG.getVarMappedName(target);
                String[] old_clazz_split = target.split("\\.");
                String old_clazz = String.join((CharSequence)".", Arrays.copyOfRange(old_clazz_split, 0, old_clazz_split.length - 1));
                String clazz = this.SRG.getClassMappedName(old_clazz);
                String[] old_desc_split = target.split(":");
                String old_desc = old_desc_split[1];
                String desc = this.SRG.renameClassesInFieldDescriptor(old_desc);
                fci_output = (String)fci_output + ":" + desc;
                output = output + "**FeatureCreep Intermediary:** `" + (String)fci_output + "`\n";
                if (this.SUGARCANE.reverse.vars.containsKey(fci_output = clazz + "." + (String)fci_output)) {
                    String sugarcane_output = this.SUGARCANE.reverse.getVarMappedName((String)fci_output);
                    String[] old_desc_split2 = ((String)fci_output).split(":");
                    String old_desc2 = old_desc_split2[1];
                    String desc2 = this.SUGARCANE.reverse.renameClassesInFieldDescriptor(old_desc2);
                    output = output + "**MojMap:** `" + sugarcane_output + ":" + desc2 + "`\n";
                }
                if (this.YARN.reverse.vars.containsKey(fci_output)) {
                    String yarn_output = this.YARN.reverse.getVarMappedName((String)fci_output);
                    String[] old_desc_split3 = ((String)fci_output).split(":");
                    String old_desc3 = old_desc_split3[1];
                    String desc3 = this.YARN.reverse.renameClassesInFieldDescriptor(old_desc3);
                    output = output + "**Yarn:** `" + yarn_output + ":" + desc3 + "`\n";
                }
                if (this.FABRIC_INTERMEDIARY.reverse.vars.containsKey(fci_output)) {
                    String fain_output = this.FABRIC_INTERMEDIARY.reverse.getVarMappedName((String)fci_output);
                    String[] old_desc_split4 = ((String)fci_output).split(":");
                    String old_desc4 = old_desc_split4[1];
                    String desc4 = this.FABRIC_INTERMEDIARY.reverse.renameClassesInFieldDescriptor(old_desc4);
                    output = output + "**Fabric Intermediary:** `" + fain_output + ":" + desc4 + "`\n";
                }
            }
            outputs.add((CallSite)((Object)output));
        }
        if (outputs.isEmpty()) {
            out = "No mapping found for " + srg_name + ". Make sure its in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        } else {
            out = String.join((CharSequence)"\n", outputs);
            if (((String)out).length() > 2000) {
                out = "Output too long. Please Narrow your Search. If the name is short and you have the full name but not descriptor add : to the end";
            }
        }
        return out;
    }

    public String sugarcanevarfind(String moj_name) {
        Object out;
        boolean pack = moj_name.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<CallSite> outputs = new ArrayList<CallSite>();
        if (pack && this.SUGARCANE.vars.containsKey(moj_name)) {
            targets.add(moj_name);
        } else {
            for (Map.Entry<String, String> entry : this.SUGARCANE.vars.entrySet()) {
                if (!entry.getKey().contains(moj_name)) continue;
                targets.add(entry.getKey());
            }
        }
        for (String target : targets) {
            String output = "**MojMap:** `" + target + "`\n";
            if (this.SUGARCANE.vars.containsKey(target)) {
                Object fci_output = this.SUGARCANE.getVarMappedName(target);
                String[] old_clazz_split = target.split("\\.");
                String old_clazz = String.join((CharSequence)".", Arrays.copyOfRange(old_clazz_split, 0, old_clazz_split.length - 1));
                String clazz = this.SUGARCANE.getClassMappedName(old_clazz);
                String[] old_desc_split = target.split(":");
                String old_desc = old_desc_split[1];
                String desc = this.SUGARCANE.renameClassesInFieldDescriptor(old_desc);
                fci_output = (String)fci_output + ":" + desc;
                output = output + "**FeatureCreep Intermediary:** `" + (String)fci_output + "`\n";
                if (this.SRG.reverse.vars.containsKey(fci_output = clazz + "." + (String)fci_output)) {
                    String sugarcane_output = this.SRG.reverse.getVarMappedName((String)fci_output);
                    String[] old_desc_split2 = ((String)fci_output).split(":");
                    String old_desc2 = old_desc_split2[1];
                    String desc2 = this.SRG.reverse.renameClassesInFieldDescriptor(old_desc2);
                    output = output + "**SRG:** `" + sugarcane_output + ":" + desc2 + "`\n";
                }
                if (this.YARN.reverse.vars.containsKey(fci_output)) {
                    String yarn_output = this.YARN.reverse.getVarMappedName((String)fci_output);
                    String[] old_desc_split3 = ((String)fci_output).split(":");
                    String old_desc3 = old_desc_split3[1];
                    String desc3 = this.YARN.reverse.renameClassesInFieldDescriptor(old_desc3);
                    output = output + "**Yarn:** `" + yarn_output + ":" + desc3 + "`\n";
                }
                if (this.FABRIC_INTERMEDIARY.reverse.vars.containsKey(fci_output)) {
                    String fain_output = this.FABRIC_INTERMEDIARY.reverse.getVarMappedName((String)fci_output);
                    String[] old_desc_split4 = ((String)fci_output).split(":");
                    String old_desc4 = old_desc_split4[1];
                    String desc4 = this.FABRIC_INTERMEDIARY.reverse.renameClassesInFieldDescriptor(old_desc4);
                    output = output + "**Fabric Intermediary:** `" + fain_output + ":" + desc4 + "`\n";
                }
            }
            outputs.add((CallSite)((Object)output));
        }
        if (outputs.isEmpty()) {
            out = "No mapping found for " + moj_name + ". Make sure its in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        } else {
            out = String.join((CharSequence)"\n", outputs);
            if (((String)out).length() > 2000) {
                out = "Output too long. Please Narrow your Search. If the name is short and you have the full name but not descriptor add : to the end";
            }
        }
        return out;
    }

    public String fainvarfind(String fain_name) {
        Object out;
        boolean pack = fain_name.contains(".");
        ArrayList<String> targets = new ArrayList<String>();
        ArrayList<CallSite> outputs = new ArrayList<CallSite>();
        if (pack && this.FABRIC_INTERMEDIARY.vars.containsKey(fain_name)) {
            targets.add(fain_name);
        } else {
            for (Map.Entry<String, String> entry : this.FABRIC_INTERMEDIARY.vars.entrySet()) {
                if (!entry.getKey().contains(fain_name)) continue;
                targets.add(entry.getKey());
            }
        }
        for (String target : targets) {
            String output = "**Fabric Intermediary:** `" + target + "`\n";
            if (this.FABRIC_INTERMEDIARY.vars.containsKey(target)) {
                Object fci_output = this.FABRIC_INTERMEDIARY.getVarMappedName(target);
                String[] old_clazz_split = target.split("\\.");
                String old_clazz = String.join((CharSequence)".", Arrays.copyOfRange(old_clazz_split, 0, old_clazz_split.length - 1));
                String clazz = this.FABRIC_INTERMEDIARY.getClassMappedName(old_clazz);
                String[] old_desc_split = target.split(":");
                String old_desc = old_desc_split[1];
                String desc = this.FABRIC_INTERMEDIARY.renameClassesInFieldDescriptor(old_desc);
                fci_output = (String)fci_output + ":" + desc;
                output = output + "**FeatureCreep Intermediary:** `" + (String)fci_output + "`\n";
                if (this.SRG.reverse.vars.containsKey(fci_output = clazz + "." + (String)fci_output)) {
                    String sugarcane_output = this.SRG.reverse.getVarMappedName((String)fci_output);
                    String[] old_desc_split2 = ((String)fci_output).split(":");
                    String old_desc2 = old_desc_split2[1];
                    String desc2 = this.SRG.reverse.renameClassesInFieldDescriptor(old_desc2);
                    output = output + "**SRG:** `" + sugarcane_output + ":" + desc2 + "`\n";
                }
                if (this.YARN.reverse.vars.containsKey(fci_output)) {
                    String yarn_output = this.YARN.reverse.getVarMappedName((String)fci_output);
                    String[] old_desc_split3 = ((String)fci_output).split(":");
                    String old_desc3 = old_desc_split3[1];
                    String desc3 = this.YARN.reverse.renameClassesInFieldDescriptor(old_desc3);
                    output = output + "**Yarn:** `" + yarn_output + ":" + desc3 + "`\n";
                }
                if (this.SUGARCANE.reverse.vars.containsKey(fci_output)) {
                    String fain_output = this.SUGARCANE.reverse.getVarMappedName((String)fci_output);
                    String[] old_desc_split4 = ((String)fci_output).split(":");
                    String old_desc4 = old_desc_split4[1];
                    String desc4 = this.SUGARCANE.reverse.renameClassesInFieldDescriptor(old_desc4);
                    output = output + "**MojMap:** `" + fain_output + ":" + desc4 + "`\n";
                }
            }
            outputs.add((CallSite)((Object)output));
        }
        if (outputs.isEmpty()) {
            out = "No mapping found for " + fain_name + ". Make sure its in the correct format using . instead of / in the main class (but not descriptors) and that the class is actually mapped and not the same on most mappings and that you are on the latest version and that the mapping DB has updated to the newest version.";
        } else {
            out = String.join((CharSequence)"\n", outputs);
            if (((String)out).length() > 2000) {
                out = "Output too long. Please Narrow your Search. If the name is short and you have the full name but not descriptor add : to the end";
            }
        }
        return out;
    }

    public String classmap(String input) {
        String[] args = input.split(" ");
        if (args.length == 0) {
            return "Command Usage:\nclassmap class-name-featurecreep-intermediary\nOR\nclassmap -mapping-name classname\n\nFeatureCreep Moderation Bot Mapping Module";
        }
        if (args.length == 1) {
            return this.fciclassfind(args[0]);
        }
        if (args.length == 2) {
            String origin = args[0].replace("-", "");
            if (origin.equals("srg")) {
                return this.srgclassfind(args[1]);
            }
            if (origin.equals("fci")) {
                return this.fciclassfind(args[1]);
            }
            if (origin.equals("sugarcane")) {
                return this.sugarcaneclassfind(args[1]);
            }
            if (origin.equals("parchment")) {
                return this.sugarcaneclassfind(args[1]);
            }
            if (origin.equals("moj")) {
                return this.sugarcaneclassfind(args[1]);
            }
            if (origin.equals("yarn")) {
                return this.yarnclassfind(args[1]);
            }
            if (origin.equals("fain")) {
                return this.fainclassfind(args[1]);
            }
            return "Unsupported Origin Mappings. Mapping Options\n`srg`  Searge Mappings\n`fci` FeatureCreep Intermediary\n`sugarcane` SugarCane/MojMap/Parchment\n`parchment` SugarCane/MojMap/Parchment\n`moj` SugarCane/MojMap/Parchment\n`yarn` Yarn\n`fain` Fabric Intermediary";
        }
        return null;
    }

    public String defmap(String event) {
        String[] args = event.split(" ");
        if (args.length == 0) {
            return "Command Usage:\n`defmap class.method(desc)\nOR\n`defmap -mapping-name class.method(desc)\n\nExample: `defmap -fain net.minecraft.class_8143.write(Lnet/minecraft/class_2540;)V\n\nFeatureCreep Moderation Bot Mapping Module";
        }
        if (args.length == 1) {
            return this.fcideffind(args[0]);
        }
        if (args.length == 2) {
            String origin = args[0].replaceAll("-", "");
            if (origin.equals("srg")) {
                return this.srgdeffind(args[1]);
            }
            if (origin.equals("fci")) {
                return this.fcideffind(args[1]);
            }
            if (origin.equals("sugarcane") || origin.equals("parchment") || origin.equals("moj")) {
                return this.sugarcanedeffind(args[1]);
            }
            if (origin.equals("yarn")) {
                return this.yarndeffind(args[1]);
            }
            if (origin.equals("fain")) {
                return this.faindeffind(args[1]);
            }
            return "Unsupported Origin Mappings. Mapping Options\n`srg` Searge Mappings\n`fci` FeatureCreep Intermediary\n`sugarcane` SugarCane/MojMap/Parchment\n`parchment` SugarCane/MojMap/Parchment\n`moj` SugarCane/MojMap/Parchment\n`yarn` Yarn\n`fain` Fabric Intermediary";
        }
        return "Too many Args";
    }

    public String varmap(String event) {
        String[] args = event.split(" ");
        if (args.length == 0) {
            return "Command Usage:\n`varmap class.method(desc)\nOR\n`varmap -mapping-name class.field:desc\n\nExample: `varmap -srg net.minecraft.src.C_290140_.f_291422_:Ljava/lang/String;\n\nFeatureCreep Moderation Bot Mapping Module\n";
        }
        if (args.length == 1) {
            return this.fcivarfind(args[0]);
        }
        if (args.length == 2) {
            String origin = args[0].replaceAll("-", "");
            if (origin.equals("srg")) {
                return this.srgvarfind(args[1]);
            }
            if (origin.equals("fci")) {
                return this.fcivarfind(args[1]);
            }
            if (origin.equals("sugarcane")) {
                return this.sugarcanevarfind(args[1]);
            }
            if (origin.equals("parchment")) {
                return this.sugarcanevarfind(args[1]);
            }
            if (origin.equals("moj")) {
                return this.sugarcanevarfind(args[1]);
            }
            if (origin.equals("yarn")) {
                return this.yarnvarfind(args[1]);
            }
            if (origin.equals("fain")) {
                return this.fainvarfind(args[1]);
            }
            return "Unsupported Origin Mappings. Mapping Options\n`srg` Searge Mappings\n`fci` FeatureCreep Intermediary\n`sugarcane` SugarCane/MojMap/Parchment\n`parchment` SugarCane/MojMap/Parchment\n`moj` SugarCane/MojMap/Parchment\n`yarn` Yarn\n`fain` Fabric Intermediary";
        }
        return "Too many Args";
    }

    public String mcp(String event) {
        String[] args = event.split(" ");
        if (args.length == 0) {
            return "Command Usage:\n`mcp def/var/class\nOR\n`mcp f/m/c def/var/class\n\nExample: `mcp f `f_291422_`\n\nFeatureCreep Moderation Bot Mapping Module";
        }
        if (args.length == 1) {
            String item = args[0];
            if (item.startsWith("f_") || item.startsWith("field_") || item.contains(":")) {
                return this.srgvarfind(item);
            }
            if (item.startsWith("m_") || item.startsWith("func_") || item.contains("(")) {
                return this.srgdeffind(item);
            }
            return this.srgclassfind(args[0]);
        }
        if (args.length == 2) {
            String type = args[0].replaceAll("-", "");
            String item = args[1];
            if (type.equals("f") || type.equals("field") || type.equals("var") || type.equals("v")) {
                return this.srgvarfind(item);
            }
            if (type.equals("m") || type.equals("method") || type.equals("func") || type.equals("def") || type.equals("d")) {
                return this.srgdeffind(item);
            }
            return this.srgclassfind(item);
        }
        return "Too many args";
    }

    public String fci(String event) {
        String[] args = event.split(" ");
        if (args.length == 0) {
            return "Command Usage:\nfci def/var/class\nOR\nfci v/d/c def/var/class\n\nExample: fci v toItem:Lgame/Item;";
        }
        if (args.length == 1) {
            String item = args[0];
            if (item.startsWith("var_") || item.contains(":")) {
                return this.fcivarfind(item);
            }
            if (item.startsWith("def") || item.contains("(")) {
                return this.fcideffind(item);
            }
            return this.fciclassfind(args[0]);
        }
        if (args.length == 2) {
            String type = args[0].replaceAll("-", "");
            String item = args[1];
            if (type.equals("f") || type.equals("field") || type.equals("var") || type.equals("v")) {
                return this.fcivarfind(item);
            }
            if (type.equals("m") || type.equals("method") || type.equals("func") || type.equals("def") || type.equals("d")) {
                return this.fcideffind(item);
            }
            return this.fciclassfind(item);
        }
        return "Too many args";
    }

    public String yc(String event) {
        String[] args = event.split(" ");
        return this.fainclassfind(args[0]);
    }

    public String ym(String event) {
        String[] args = event.split(" ");
        return this.faindeffind(args[0]);
    }

    public String yf(String event) {
        String[] args = event.split(" ");
        return this.fainvarfind(args[0]);
    }

    public String mappings_main(Message event) {
        String reply = new String("FeatureCreep Moderation Bot Mapping Module.Commands:**mappings** This command. Basic Information about the Mapping Module\n**classmap** Searches for Class Mappings\n**defmap** Searches for Def/Method/Function Mappings\n**varmap** Searches for Variable/Field Mappings\n**mcp** Converts srg names to other mappings\n**fci** Converts fci names to other mappings\n**yc/ym/yf** Converts Fabric Intermediary Classes/Methods/Fields to other mappings\n~~**qc/qm/qc** Converts Fabric Intermediary and Hashed MojMap Classes/Methods/Fields to other mappings~~\n");
        return reply;
    }
}

