/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Scanner;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.IMentionable;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.AnnotatedEventManager;
import net.dv8tion.jda.api.hooks.IEventManager;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.cache.CacheFlag;
import org.mangorage.basicutils.config.Config;
import org.mangorage.basicutils.config.ConfigSetting;
import org.mangorage.basicutils.config.ISetting;
import org.mangorage.eventbus.event.Event;
import org.mangorage.jdautils.command.Command;
import org.mangorage.mangobot.config.GuildConfig;
import org.mangorage.mangobot.core.BotEventListener;
import org.mangorage.mangobot.core.BotPermissions;
import org.mangorage.mangobot.core.Listeners;
import org.mangorage.mangobot.modules.actions.TrashButtonAction;
import org.mangorage.mangobot.modules.basic.commands.GetEmbedsCommand;
import org.mangorage.mangobot.modules.basic.commands.HelpCommand;
import org.mangorage.mangobot.modules.basic.commands.InfoCommand;
import org.mangorage.mangobot.modules.basic.commands.JoinCommand;
import org.mangorage.mangobot.modules.basic.commands.LeaveCommand;
import org.mangorage.mangobot.modules.basic.commands.PermissionCommand;
import org.mangorage.mangobot.modules.basic.commands.PingCommand;
import org.mangorage.mangobot.modules.basic.commands.PrefixCommand;
import org.mangorage.mangobot.modules.basic.commands.VersionCommand;
import org.mangorage.mangobot.modules.developer.EchoCommand;
import org.mangorage.mangobot.modules.developer.KickBotCommand;
import org.mangorage.mangobot.modules.developer.RestartCommand;
import org.mangorage.mangobot.modules.developer.RunCode;
import org.mangorage.mangobot.modules.developer.ServerAuthorizer;
import org.mangorage.mangobot.modules.developer.SpeakCommand;
import org.mangorage.mangobot.modules.developer.TerminateCommand;
import org.mangorage.mangobot.modules.github.GHIssueStatus;
import org.mangorage.mangobot.modules.github.GHPRStatus;
import org.mangorage.mangobot.modules.github.IssueScanCommand;
import org.mangorage.mangobot.modules.github.PRScanCommand;
import org.mangorage.mangobot.modules.github.PasteRequestModule;
import org.mangorage.mangobot.modules.mappings.ClassMapCommand;
import org.mangorage.mangobot.modules.mappings.DefMapCommand;
import org.mangorage.mangobot.modules.mappings.FCICommand;
import org.mangorage.mangobot.modules.mappings.MCPCommand;
import org.mangorage.mangobot.modules.mappings.MappingsMainCommand;
import org.mangorage.mangobot.modules.mappings.MappingsManager;
import org.mangorage.mangobot.modules.mappings.VarMapCommand;
import org.mangorage.mangobot.modules.mappings.YCCommand;
import org.mangorage.mangobot.modules.mappings.YFCommand;
import org.mangorage.mangobot.modules.mappings.YMCommand;
import org.mangorage.mangobot.modules.music.commands.PauseCommand;
import org.mangorage.mangobot.modules.music.commands.PlayCommand;
import org.mangorage.mangobot.modules.music.commands.PlayingCommand;
import org.mangorage.mangobot.modules.music.commands.QueueCommand;
import org.mangorage.mangobot.modules.music.commands.StopCommand;
import org.mangorage.mangobot.modules.music.commands.VolumeCommand;
import org.mangorage.mangobot.modules.tricks.TrickCommand;
import org.mangorage.mangobotapi.core.commands.IBasicCommand;
import org.mangorage.mangobotapi.core.events.DiscordEvent;
import org.mangorage.mangobotapi.core.events.LoadEvent;
import org.mangorage.mangobotapi.core.events.SaveEvent;
import org.mangorage.mangobotapi.core.modules.action.ButtonAction;
import org.mangorage.mangobotapi.core.modules.action.ButtonActionRegistry;
import org.mangorage.mangobotapi.core.plugin.api.CorePlugin;
import org.mangorage.mangobotapi.core.plugin.api.PluginMessageEvent;
import org.mangorage.mangobotapi.core.plugin.impl.Plugin;
import org.mangorage.mangobotapi.core.registry.commands.CommandRegistry;
import org.mangorage.mangobotapi.core.registry.permissions.PermissionRegistry;

@Plugin(id="mangobot")
public class MangoBotPlugin
extends CorePlugin {
    public static final String ID = "mangobot";
    private static final EnumSet<GatewayIntent> intents = EnumSet.of(GatewayIntent.GUILD_MESSAGES, new GatewayIntent[]{GatewayIntent.DIRECT_MESSAGES, GatewayIntent.MESSAGE_CONTENT, GatewayIntent.GUILD_MESSAGE_REACTIONS, GatewayIntent.DIRECT_MESSAGE_REACTIONS, GatewayIntent.GUILD_VOICE_STATES, GatewayIntent.GUILD_EMOJIS_AND_STICKERS, GatewayIntent.SCHEDULED_EVENTS, GatewayIntent.GUILD_MEMBERS, GatewayIntent.GUILD_PRESENCES});
    private static final EnumSet<CacheFlag> cacheFlags = EnumSet.of(CacheFlag.EMOJI, new CacheFlag[]{CacheFlag.ROLE_TAGS, CacheFlag.VOICE_STATE, CacheFlag.ACTIVITY, CacheFlag.CLIENT_STATUS, CacheFlag.MEMBER_OVERRIDES, CacheFlag.STICKER, CacheFlag.SCHEDULED_EVENTS, CacheFlag.FORUM_TAGS});
    public static final Config CONFIG = new Config(Path.of("plugins/%s/.env".formatted("mangobot"), new String[0]));
    public static final ISetting<String> MAPPINGS_VERSION = ConfigSetting.create((Config)CONFIG, (String)"MAPPINGS_VERSION", (String)"empty");
    public static final ISetting<String> BOT_TOKEN = ConfigSetting.create((Config)CONFIG, (String)"BOT_TOKEN", (String)"empty");
    public static final ISetting<String> GITHUB_TOKEN = ConfigSetting.create((Config)CONFIG, (String)"PASTE_TOKEN", (String)"empty");
    public static final ISetting<String> GITHUB_USERNAME = ConfigSetting.create((Config)CONFIG, (String)"GITHUB_USERNAME", (String)"RealMangoRage");
    public static final ISetting<String> DEEPL_TOKEN = ConfigSetting.create((Config)CONFIG, (String)"DEEPL_TOKEN", (String)"empty");
    public static final ButtonActionRegistry ACTION_REGISTRY = new ButtonActionRegistry();
    private final LongSet PINGS = LongSet.of((long)134030797756694528L, (long)194596094200643584L, (long)1129615044833976451L);
    private static final List<Long> AUTO_PUBLISH_CHANNELS = List.of(Long.valueOf(1129095997461647402L), Long.valueOf(1129077934330744882L));

    public MangoBotPlugin() {
        super(ID, JDABuilder.createDefault((String)((String)BOT_TOKEN.get())).setEnabledIntents(intents).enableCache(cacheFlags).setActivity(Activity.of((Activity.ActivityType)Activity.ActivityType.CUSTOM_STATUS, (String)"    MangoBot is on version %s\n".formatted(VersionCommand.getVersion()), (String)"https://www.discord.minecraftforge.net/")).setStatus(OnlineStatus.ONLINE).setMemberCachePolicy(MemberCachePolicy.ALL).setEventManager((IEventManager)new AnnotatedEventManager()).setEnableShutdownHook(true).setAutoReconnect(true).build());
        new ServerAuthorizer(this);
        this.getJDA().addEventListener(new Object[]{new BotEventListener(this)});
        this.getPluginBus().addGenericListener(10, MessageReceivedEvent.class, DiscordEvent.class, this::onMessage2);
    }

    public void onMessage2(DiscordEvent<MessageReceivedEvent> event) {
        MessageReceivedEvent i = (MessageReceivedEvent)event.getInstance();
        Message m = i.getMessage();
        Message r = m.getReferencedMessage();
        if (r != null) {
            User authorPinged = r.getAuthor();
            User whoPinged = m.getAuthor();
            if (!m.getMentions().isMentioned((IMentionable)authorPinged, new Message.MentionType[0])) {
                return;
            }
            if (this.PINGS.contains(authorPinged.getIdLong())) {
                whoPinged.openPrivateChannel().queue(pc -> ((MessageCreateAction)((MessageCreateAction)pc.sendMessageEmbeds(PingCommand.EMBED, new MessageEmbed[0]).setContent("")).setContent("Please do not ping this person -> %s".formatted(r.getJumpUrl()))).queue());
            }
        }
    }

    public void startup() {
        BotPermissions.init();
    }

    public void onMessage(DiscordEvent<MessageReceivedEvent> event) {
        MessageReceivedEvent dEvent = (MessageReceivedEvent)event.getInstance();
        long channel = dEvent.getChannel().getIdLong();
        if (AUTO_PUBLISH_CHANNELS.contains(channel)) {
            Message msg = dEvent.getMessage();
            if (dEvent.isFromType(ChannelType.NEWS)) {
                msg.crosspost().queue();
            }
        }
    }

    public void registration() {
        CommandRegistry cmdRegistry = this.getCommandRegistry();
        PermissionRegistry permRegistry = this.getPermissionRegistry();
        ACTION_REGISTRY.register((ButtonAction)new TrashButtonAction());
        permRegistry.register(BotPermissions.PLAYING);
        permRegistry.register(BotPermissions.TRICK_ADMIN);
        permRegistry.register(BotPermissions.PREFIX_ADMIN);
        permRegistry.register(BotPermissions.MOD_MAIL);
        permRegistry.register(BotPermissions.PERMISSION_ADMIN);
        permRegistry.register(BotPermissions.CUSTOM_VC_ADMIN);
        cmdRegistry.addBasicCommand((IBasicCommand)new HelpCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new InfoCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new JoinCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new LeaveCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new PermissionCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new PingCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new PrefixCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new VersionCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new KickBotCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new RestartCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new SpeakCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new TerminateCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new EchoCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new PlayCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new PauseCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new PlayingCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new QueueCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new StopCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new VolumeCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new TrickCommand(this));
        MappingsManager latest_mappings_manager = MappingsManager.new_();
        latest_mappings_manager.init(MAPPINGS_VERSION);
        cmdRegistry.addBasicCommand((IBasicCommand)new MappingsMainCommand(latest_mappings_manager, this));
        cmdRegistry.addBasicCommand((IBasicCommand)new ClassMapCommand(latest_mappings_manager, this));
        cmdRegistry.addBasicCommand((IBasicCommand)new DefMapCommand(latest_mappings_manager, this));
        cmdRegistry.addBasicCommand((IBasicCommand)new VarMapCommand(latest_mappings_manager, this));
        cmdRegistry.addBasicCommand((IBasicCommand)new MCPCommand(latest_mappings_manager, this));
        cmdRegistry.addBasicCommand((IBasicCommand)new FCICommand(latest_mappings_manager, this));
        cmdRegistry.addBasicCommand((IBasicCommand)new YCCommand(latest_mappings_manager, this));
        cmdRegistry.addBasicCommand((IBasicCommand)new YMCommand(latest_mappings_manager, this));
        cmdRegistry.addBasicCommand((IBasicCommand)new YFCommand(latest_mappings_manager, this));
        cmdRegistry.addBasicCommand((IBasicCommand)new RunCode());
        cmdRegistry.addBasicCommand((IBasicCommand)new GetEmbedsCommand());
        cmdRegistry.addBasicCommand((IBasicCommand)new PRScanCommand(this));
        cmdRegistry.addBasicCommand((IBasicCommand)new IssueScanCommand(this));
        GuildConfig.loadServerConfigs();
        permRegistry.save();
        PasteRequestModule.register(this.getPluginBus());
        new GHPRStatus(this);
        new GHIssueStatus(this);
        this.getPluginBus().addListener(10, PluginMessageEvent.class, pm -> {
            if (pm.getMethod().equals("getDate")) {
                if (pm.getObject().get() == null) {
                    return;
                }
                Object patt0$temp = pm.getObject().get();
                if (patt0$temp instanceof Date) {
                    Date date = (Date)patt0$temp;
                    System.out.println("Received a Plugin Comms with Data: %s from %s".formatted(date, pm.getOrigin().getId()));
                }
            }
        });
        new Listeners(this);
        this.getPluginBus().addGenericListener(10, MessageReceivedEvent.class, DiscordEvent.class, this::onMessage);
    }

    public void finished() {
        this.getPluginBus().post((Event)new LoadEvent());
        this.getJDA().updateCommands().addCommands((Collection)Command.globalCommands).queue();
    }

    public void shutdownPre() {
        this.getPluginBus().post((Event)new SaveEvent());
    }

    public void shutdownPost() {
    }

    public String getCommandPrefix() {
        return "mb?";
    }

    public static String getToken() {
        if (((String)BOT_TOKEN.get()).equals("empty") || ((String)BOT_TOKEN.get()).equals("")) {
            System.out.println("Empty bot token, replace the bot token with the one from discord in" + String.valueOf(CONFIG.getFile()) + " or by typing it in here if you are not in gradle:");
            Scanner scanner = new Scanner(System.in);
            if (scanner.hasNext()) {
                String token = scanner.nextLine();
                BOT_TOKEN.set((Object)token);
                scanner.close();
                return token;
            }
            System.out.println("Blank response, this is expected from being run within Gradle. You need to put your token here " + String.valueOf(CONFIG.getFile()));
            scanner.close();
            return (String)BOT_TOKEN.get();
        }
        return (String)BOT_TOKEN.get();
    }
}

