/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.mangobot.modules.tricks;

import com.google.gson.annotations.Expose;
import java.util.HashMap;
import org.mangorage.mangobot.modules.tricks.TrickType;
import org.mangorage.mangobot.modules.tricks.lua.MemoryBank;
import org.mangorage.mangobotapi.core.data.FileName;
import org.mangorage.mangobotapi.core.data.IFileNameResolver;

public class Trick
implements IFileNameResolver {
    @Expose
    private long ownerID;
    @Expose
    private long lastUserEdited;
    @Expose
    private boolean locked = false;
    @Expose
    private long lastEdited;
    @Expose
    private long timesUsed = 0L;
    @Expose
    private String content;
    @Expose
    private boolean suppress = false;
    @Expose
    private String script;
    @Expose
    private String aliasTarget;
    @Expose
    private final String trickID;
    @Expose
    private final long guildID;
    @Expose
    private final long created;
    @Expose
    private TrickType type;
    @Expose
    private MemoryBank memoryBank;

    protected Trick(String trickID, long guildID) {
        this.trickID = trickID;
        this.guildID = guildID;
        this.created = System.currentTimeMillis();
        if (this.getType() == TrickType.SCRIPT) {
            this.memoryBank = new MemoryBank(new HashMap<String, Object>());
        }
    }

    protected void setAliasTarget(String target) {
        this.aliasTarget = target;
    }

    protected void setSuppress(boolean suppress) {
        this.suppress = suppress;
    }

    protected void setType(TrickType type) {
        this.type = type;
    }

    protected void setContent(String content) {
        this.content = content;
    }

    protected void setScript(String script) {
        this.script = script;
    }

    protected void setOwnerID(long ownerID) {
        this.ownerID = ownerID;
    }

    protected void setLastUserEdited(long user) {
        this.lastUserEdited = user;
    }

    protected void setLock(boolean locked) {
        this.locked = locked;
    }

    protected void setLastEdited(long ms) {
        this.lastEdited = ms;
    }

    public TrickType getType() {
        return this.type;
    }

    public String getAliasTarget() {
        return this.aliasTarget;
    }

    public long getOwnerID() {
        return this.ownerID;
    }

    public long getLastUserEdited() {
        return this.lastUserEdited;
    }

    public long getLastEdited() {
        return this.lastEdited;
    }

    public long getTimesUsed() {
        return this.timesUsed;
    }

    public String getContent() {
        return this.content;
    }

    public String getScript() {
        return this.script;
    }

    public String getTrickID() {
        return this.trickID;
    }

    public long getCreated() {
        return this.created;
    }

    public long getGuildID() {
        return this.guildID;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isSuppressed() {
        return this.suppress;
    }

    public MemoryBank getMemoryBank() {
        if (this.memoryBank == null) {
            this.memoryBank = new MemoryBank(new HashMap<String, Object>());
        }
        return this.memoryBank;
    }

    protected void use() {
        ++this.timesUsed;
    }

    public FileName resolve() {
        return new FileName("" + this.guildID, this.trickID);
    }
}

